/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance.timesheet;

import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentSummaryObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.util.MathsUtils;
import au.com.ordermate.util.Price;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import ordermate.database.departments.Department;
import ordermate.database.departments.Payrate;
import ordermate.database.users.User;

@Entity
public class TimesheetSummaryReport
extends PersistentSummaryObject {
    public static final Props Properties = new Props();
    private BigDecimal totalSeconds = BigDecimal.valueOf(0L);
    private BigDecimal totalPay = BigDecimal.valueOf(0L);
    private Date reportDate;
    private Reference<Department> department;
    private Reference<User> user;
    private Reference<Payrate> payrate;
    private transient BigDecimal totalHours;

    public TimesheetSummaryReport() {
        this.department = this.createReference(TimesheetSummaryReport.Properties.DEPARTMENT);
        this.user = this.createReference(TimesheetSummaryReport.Properties.USER);
        this.payrate = this.createReference(TimesheetSummaryReport.Properties.PAYRATE);
    }

    @Column(name="total_seconds")
    public BigDecimal getTotalSeconds() {
        return this.totalSeconds;
    }

    @Transient
    public BigDecimal getTotalHours() {
        if (this.totalHours == null) {
            this.totalHours = BigDecimal.valueOf((double)this.totalSeconds.longValue() / 3600.0);
        }
        return this.totalHours;
    }

    @Column(name="total_pay")
    public BigDecimal getTotalPay() {
        return this.totalPay;
    }

    @ManyToOne
    @JoinColumn(name="fk_config_department")
    public Department getDepartment() {
        return this.department.get();
    }

    @Column(name="report_date")
    @Temporal(value=TemporalType.DATE)
    public Date getReportDate() {
        return this.reportDate;
    }

    public void setTotalSeconds(BigDecimal value) {
        this.totalSeconds = value;
    }

    public void setTotalPay(BigDecimal totalPay) {
        this.totalPay = totalPay;
    }

    public void setDepartment(Department value) {
        this.department.set(value);
    }

    public void setReportDate(Date reportDate) {
        this.reportDate = reportDate;
    }

    @ManyToOne
    @JoinColumn(name="fk_config_user")
    public User getUser() {
        return this.user.get();
    }

    public void setUser(User value) {
        this.user.set(value);
    }

    @ManyToOne
    @JoinColumn(name="fk_config_payrate")
    public Payrate getPayrate() {
        return this.payrate.get();
    }

    public void setPayrate(Payrate value) {
        this.payrate.set(value);
    }

    public void addReport(TimesheetSummaryReport report) {
        this.totalSeconds = this.totalSeconds.add(report.totalSeconds);
        this.totalPay = this.totalPay.add(report.totalPay);
        this.totalHours = null;
    }

    @Transient
    public Price getAveragePay() {
        if (MathsUtils.approxEquals(this.getTotalHours().doubleValue(), 0.0)) {
            return Price.ZERO_DOLLAR;
        }
        return new Price(this.getTotalPay().doubleValue() / this.getTotalHours().doubleValue(), 0.01);
    }

    @Transient
    public String getPayrollId() {
        if (this.getUser() != null) {
            return this.getUser().getPayrollID();
        }
        return "";
    }

    public static class Props
    extends PersistentSummaryObject.Props {
        public PropertiedObject.Property<BigDecimal> TOTAL_SECONDS;
        public PropertiedObject.Property<Double> TOTAL_PAY;
        public PropertiedObject.Property<Department> DEPARTMENT;
        public PropertiedObject.Property<Date> REPORT_DATE;
        public PropertiedObject.Property<User> USER;
        public PropertiedObject.Property<Payrate> PAYRATE;
        public PersistentObject.DerivedProperty<Price> AVERAGE_PAY = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)TimesheetSummaryReport.class), "averagePay");
        public PersistentObject.DerivedProperty<Double> TOTAL_HOURS = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)TimesheetSummaryReport.class), "totalHours");
        public PersistentObject.DerivedProperty<String> PAYROLLID = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)TimesheetSummaryReport.class), "payrollId");
    }
}

