/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance.transactions;

import au.com.ordermate.util.Price;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Transient;
import ordermate.database.config.ExperimentalFeature;
import ordermate.database.finance.Shift;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.finance.transactions.FinanceTransactionContext;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.finance.transactions.KickCashdrawer;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.users.User;
import org.hibernate.annotations.AccessType;

@Entity
@DiscriminatorValue(value="CASH")
@AccessType(value="property")
public class CashTransaction
extends FinanceTransaction {
    public static final Props Properties = new Props();
    private static ExperimentalFeature kickCashDrawerOn0Dollars;
    public static final String TYPE = "CASH";

    @Override
    @Transient
    public String getType() {
        return TYPE;
    }

    public CashTransaction() {
    }

    public CashTransaction(User user, Terminal creator, Price tendered, Price paid, Price tip, CashDrawer drawer, Shift shift) {
        super(user, creator, drawer, CashTransaction.getCashFinanceUnit(), shift);
        this.setTendered(tendered);
        this.setPaid(paid);
        this.setTip(tip);
        this.setRoundingAmt(new Price(paid.getAppliedRoundingAmt(), 0.0));
    }

    public CashTransaction(FinanceTransactionContext context, Price amountPaid) {
        this(context, amountPaid, amountPaid, Price.ZERO);
    }

    public CashTransaction(FinanceTransactionContext context, Price tendered, Price paid, Price tip) {
        this(context.getUser(), context.getTerminal(), tendered, paid, tip, context.getCashDrawer(), context.getShift());
    }

    @Override
    @Transient
    public String getLabel() {
        Price change;
        String label = "<html>";
        if (this.getTendered() != null && this.getTendered().equals(this.getPaid())) {
            label = label + this.getTendered().toString();
        } else {
            String tenderedLabel = this.getTendered() != null ? this.getTendered().toString() : "";
            String paidLabel = this.getPaid() != null ? this.getPaid().toString() : "";
            label = label + " <b>Paid: " + paidLabel + "</b>, Tendered: " + tenderedLabel;
        }
        if (this.getTip() != null && Math.abs(this.getTip().doubleValue()) > 0.001) {
            label = label + ", Tip: " + this.getTip();
        }
        if (this.getTip() != null && this.getPaid() != null && this.getTendered() != null && (change = this.getChange()) != null && Math.abs(change.doubleValue()) > 0.0) {
            label = label + ", <br><font size=\"+2\">Change:<font color=\"green\"> " + change.toString() + "</font></font>";
        }
        label = label + "</html>";
        return label;
    }

    @Override
    @Transient
    public String getIcon() {
        return "/waitermate/images/money_small.png";
    }

    @Override
    @Transient
    public Price getChange() {
        double totalVal = this.getPaid().doubleValue() + this.getTip().doubleValue();
        return new Price(this.getTendered().doubleValue() - totalVal);
    }

    @Override
    public boolean needsOpenCashdrawer() {
        if (kickCashDrawerOn0Dollars == null && (kickCashDrawerOn0Dollars = ExperimentalFeature.find("kickCashDrawerOn0Dollars")) == null) {
            kickCashDrawerOn0Dollars = new ExperimentalFeature("kickCashDrawerOn0Dollars", Boolean.FALSE.toString());
        }
        if (kickCashDrawerOn0Dollars.getBooleanValue(Boolean.FALSE).booleanValue()) {
            return KickCashdrawer.Always.equals((Object)this.getSubType().getKickCashdrawer());
        }
        return KickCashdrawer.Always.equals((Object)this.getSubType().getKickCashdrawer()) && !this.getPaid().equals(Price.ZERO_DOLLAR);
    }

    @Override
    public boolean usesEftpos() {
        return false;
    }

    @Override
    public boolean canDelete() {
        return true;
    }

    public static FinanceUnit getCashFinanceUnit() {
        return FinanceUnit.getDefaultUnitFor(TYPE);
    }

    @Override
    public void setPaid(Price paid) {
        super.setPaid(paid);
    }

    @Override
    public void setTendered(Price tendered) {
        super.setTendered(tendered);
    }

    @Override
    protected FinanceTransaction makeNew() {
        return new CashTransaction();
    }

    public static class Props
    extends FinanceTransaction.Props {
    }
}

