/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance.transactions;

import au.com.ordermate.util.Price;
import java.util.List;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Transient;
import ordermate.database.finance.Shift;
import ordermate.database.finance.transactions.EftposTransaction;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.users.User;
import org.hibernate.annotations.AccessType;

@Entity
@DiscriminatorValue(value="CREDIT")
@AccessType(value="property")
public class CreditTransaction
extends EftposTransaction {
    public static final Props Properties = new Props();
    public static final String TYPE = "CREDIT";

    @Override
    @Transient
    public String getType() {
        return TYPE;
    }

    public CreditTransaction() {
    }

    public CreditTransaction(User user, Terminal terminal, Price paid, Price tip, CashDrawer drawer, FinanceUnit type, Shift newShift) {
        super(user, terminal, paid, tip, Price.ZERO_DOLLAR, drawer, type, newShift);
    }

    @Override
    public boolean canDelete() {
        return true;
    }

    public static List<FinanceUnit> getCreditUnitTypes() {
        return FinanceUnit.getUnitsFor(TYPE);
    }

    @Override
    @Transient
    public String getIcon() {
        return "/waitermate/images/ccard_small.png";
    }

    @Override
    public CreditTransaction createReverseTransaction() {
        CreditTransaction copy = new CreditTransaction(this.getUser(), this.getTerminal(), this.getPaid().negate(), this.getTip().negate(), this.getCashDrawer(), this.getSubType(), this.getShift());
        return copy;
    }

    @Override
    public EftposTransaction copyTransaction() {
        CreditTransaction txn = new CreditTransaction(this.getUser(), this.getTerminal(), this.getPaid(), this.getTip(), this.getCashDrawer(), this.getSubType(), this.getShift());
        txn.setSurcharge(this.getSurcharge());
        return txn;
    }

    @Override
    protected FinanceTransaction makeNew() {
        return new CreditTransaction();
    }

    public static class Props
    extends EftposTransaction.Props {
    }
}

