/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance.transactions;

import java.util.List;
import ordermate.database.finance.giftvoucher.GiftVoucherTransaction;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.sales.ItemGroup;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.sales.itemfilter.ItemFilter;
import ordermate.database.sales.itemfilter.OrderableItemFilter;

public class CreditTransactionHelper {
    public boolean shouldCreateUnorderableItem(ItemGroup itemGroup, FinanceUnit unit) {
        return this.shouldCreateUnorderableItem(itemGroup, this.hasSurcharge(unit));
    }

    public boolean shouldCreateUnorderableItem(ItemGroup itemGroup, boolean hasSurcharge) {
        return hasSurcharge && this.hasNoItems(itemGroup) && this.hasTopupVoucherTxn(itemGroup);
    }

    public boolean shouldRemoveUnorderableItem(ItemGroup itemGroup) {
        return this.hasUnorderableItem(itemGroup) && (this.hasOrderableItem(itemGroup) || !this.hasTopupVoucherTxn(itemGroup));
    }

    public boolean hasTopupVoucherTxn(ItemGroup group) {
        boolean hasTopupVoucher = false;
        String topUpName = GiftVoucherTransaction.VoucherTransactionType.TOPUP.getName();
        List<GiftVoucherTransaction> voucherTxns = group.getActiveVoucherTxns();
        for (GiftVoucherTransaction txn : voucherTxns) {
            if (!topUpName.equals(txn.getVoucherTransactionType())) continue;
            hasTopupVoucher = true;
            break;
        }
        return hasTopupVoucher;
    }

    public boolean hasNoItems(ItemGroup group) {
        return group.getItems().isEmpty();
    }

    public boolean hasSurcharge(FinanceUnit unit) {
        return unit.getSurcharge() > 0.0;
    }

    public boolean hasUnorderableItem(ItemGroup group) {
        List<SalesItem> items = group.getItemHelper().getSalesItems();
        for (SalesItem item : items) {
            if (!item.getLabel().contains("!Unorderable Item!")) continue;
            return true;
        }
        return false;
    }

    public boolean hasOrderableItem(ItemGroup group) {
        List<SalesLineItem> items = ItemFilter.filterItems(group.getItems(), new OrderableItemFilter());
        return !items.isEmpty();
    }

    public SalesItem getUnorderableItem(ItemGroup group) {
        List<SalesItem> items = group.getItemHelper().getSalesItems();
        for (SalesItem item : items) {
            if (!item.getLabel().contains("!Unorderable Item!")) continue;
            return item;
        }
        return null;
    }
}

