/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance.transactions;

import au.com.ordermate.util.Price;
import java.util.List;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Transient;
import ordermate.database.finance.Shift;
import ordermate.database.finance.transactions.EftposTransaction;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.users.User;
import org.hibernate.annotations.AccessType;

@Entity
@DiscriminatorValue(value="DEBIT")
@AccessType(value="property")
public class DebitTransaction
extends EftposTransaction {
    public static final Props Properties = new Props();
    public static final String TYPE = "DEBIT";

    @Override
    @Transient
    public String getType() {
        return TYPE;
    }

    public DebitTransaction() {
    }

    public DebitTransaction(User user, Terminal creator, Price paid, Price tip, Price cashOut, CashDrawer drawer, FinanceUnit type, Shift newShift) {
        super(user, creator, paid, tip, cashOut, drawer, type, newShift);
    }

    @Override
    @Transient
    public String getLabel() {
        if (this.getCashOut() != null && this.getCashOut().doubleValue() > 0.0) {
            String label = "<html>";
            if (this.getPaid() != null && this.getTip() != null && this.getCashOut() != null) {
                label = label + new Price(this.getPaid().doubleValue() + this.getTip().doubleValue() + this.getCashOut().doubleValue(), 0.01);
            } else if (this.getPaid() != null) {
                label = this.getPaid().toString();
            }
            if (this.getTip() != null && this.getTip().doubleValue() != 0.0) {
                label = label + " (" + this.getTip() + " tip )";
            }
            if (this.getCashOut() != null) {
                label = label + ", Cash out:<font color=\"green\"> " + this.getCashOut().toString() + "</font>";
            }
            label = label + "</html>";
            return label;
        }
        return super.getLabel();
    }

    @Override
    @Transient
    public String getIcon() {
        return "/waitermate/images/dcard_small.png";
    }

    @Override
    public boolean canDelete() {
        return true;
    }

    public static List<FinanceUnit> getDebitUnitTypes() {
        return FinanceUnit.getUnitsFor(TYPE);
    }

    @Override
    public DebitTransaction createReverseTransaction() {
        DebitTransaction reversal = new DebitTransaction(this.getUser(), this.getTerminal(), this.getPaid().negate(), this.getTip().negate(), Price.ZERO_DOLLAR, this.getCashDrawer(), this.getSubType(), this.getShift());
        reversal.setSurcharge(this.getSurcharge().negate());
        return reversal;
    }

    @Override
    public DebitTransaction copyTransaction() {
        DebitTransaction reversal = new DebitTransaction(this.getUser(), this.getTerminal(), this.getPaid(), this.getTip(), this.getCashOut(), this.getCashDrawer(), this.getSubType(), this.getShift());
        reversal.setSurcharge(this.getSurcharge());
        return reversal;
    }

    @Override
    protected FinanceTransaction makeNew() {
        return new DebitTransaction();
    }

    public static class Props
    extends EftposTransaction.Props {
    }
}

