/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance.transactions;

import au.com.ordermate.util.Price;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Transient;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.finance.transactions.FinanceTransactionContext;
import ordermate.database.finance.transactions.FinanceUnit;
import org.hibernate.annotations.AccessType;

@Entity
@DiscriminatorValue(value="ACCOUNT")
@AccessType(value="property")
public class DebtorAdjustmentTransaction
extends FinanceTransaction {
    public static final Props Properties = new Props();
    public static final String TYPE = "ACCOUNT";

    public DebtorAdjustmentTransaction() {
    }

    private DebtorAdjustmentTransaction(FinanceTransactionContext context, Price adjustmentAmount, boolean isDiscount) {
        super(context.getUser(), context.getTerminal(), context.getCashDrawer(), DebtorAdjustmentTransaction.getFinanceUnit(), context.getShift());
        Price amount = adjustmentAmount;
        if (!isDiscount) {
            amount = new Price(adjustmentAmount.doubleValue() * -1.0, 0.01);
        }
        this.setTendered(amount);
        this.setPaid(amount);
        this.setTip(new Price(0.0, 0.01));
    }

    @Override
    @Transient
    public String getType() {
        return TYPE;
    }

    public void setAdjustmentAmount(Price newAdjustmentAmount, boolean isDiscount) {
        if (isDiscount) {
            this.setPaid(newAdjustmentAmount);
        } else {
            this.setPaid(newAdjustmentAmount.multiply(-1));
        }
    }

    @Override
    public boolean canDelete() {
        return !this.isPersistent();
    }

    @Override
    public boolean needsOpenCashdrawer() {
        return false;
    }

    @Override
    public boolean usesEftpos() {
        return false;
    }

    public static FinanceTransaction createDebtorDiscountTransaction(FinanceTransactionContext context, Price discountAmount) {
        if (discountAmount.doubleValue() < 0.0) {
            throw new IllegalArgumentException("Discount amount should not be less than zero. Got : " + discountAmount.doubleValue());
        }
        return new DebtorAdjustmentTransaction(context, discountAmount, true);
    }

    public static FinanceTransaction createDebtorSurchargeTransaction(FinanceTransactionContext context, Price surchargeAmount) {
        if (surchargeAmount.doubleValue() < 0.0) {
            throw new IllegalArgumentException("Surcharge amount should not be less than zero. Got: " + surchargeAmount.doubleValue());
        }
        return new DebtorAdjustmentTransaction(context, surchargeAmount, false);
    }

    public static FinanceTransaction createZeroDollarLinkingTransaction(FinanceTransactionContext context) {
        return new DebtorAdjustmentTransaction(context, Price.ZERO_DOLLAR, false);
    }

    public static FinanceUnit getFinanceUnit() {
        return FinanceUnit.getUnitsFor(TYPE).get(1);
    }

    @Override
    protected FinanceTransaction makeNew() {
        return new DebtorAdjustmentTransaction();
    }

    public static class Props
    extends FinanceTransaction.Props {
    }
}

