/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance.transactions;

import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.util.Price;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import ordermate.database.docket.FinanceTransactionDocket;
import ordermate.database.finance.Shift;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.finance.transactions.KickCashdrawer;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.eftpos.EftposType;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.hardware.physical.VirtualEftpos;
import ordermate.database.users.User;
import org.hibernate.annotations.AccessType;

@Entity
@DiscriminatorValue(value="EFTPOS")
@AccessType(value="property")
public abstract class EftposTransaction
extends FinanceTransaction {
    public static final Props Properties = new Props();
    public static final String TYPE = "EFTPOS";
    private TransactionStatus status = TransactionStatus.NOT_PROCESSED;
    private PersistentWriteableList<FinanceTransactionDocket> dockets;
    private Reference<VirtualEftpos> virtualEftpos;
    private String authCode;
    private String tipReference;
    private boolean allowTipAdjustment;

    public EftposTransaction() {
        this.dockets = (PersistentWriteableList)this.createList(EftposTransaction.Properties.DOCKETS);
        this.virtualEftpos = this.createReference(EftposTransaction.Properties.VIRTUAL_EFTPOS);
        this.allowTipAdjustment = true;
    }

    public EftposTransaction(User user, Terminal creator, Price paid, Price tip, Price cashOut, CashDrawer drawer, FinanceUnit type, Shift shift) {
        super(user, creator, drawer, type, shift);
        this.dockets = (PersistentWriteableList)this.createList(EftposTransaction.Properties.DOCKETS);
        this.virtualEftpos = this.createReference(EftposTransaction.Properties.VIRTUAL_EFTPOS);
        this.allowTipAdjustment = true;
        this.setTendered(paid);
        this.setPaid(paid);
        this.setTip(tip);
        this.setCashOut(cashOut);
    }

    public void setTransactionStatus(TransactionStatus value) {
        this.status = value;
    }

    @Transient
    public TransactionStatus getTransactionStatus() {
        return this.status;
    }

    @Override
    public boolean canDelete() {
        return true;
    }

    @Override
    public boolean needsOpenCashdrawer() {
        if (this.getSubType() != null) {
            return KickCashdrawer.Always.equals((Object)this.getSubType().getKickCashdrawer());
        }
        return false;
    }

    @Override
    public boolean usesEftpos() {
        return this.getSubType().isUsesEftpos();
    }

    @Column(name="auth_code")
    public String getAuthCode() {
        return this.authCode;
    }

    public void setAuthCode(String value) {
        this.authCode = value;
    }

    @Column(name="rrn")
    public String getTipReference() {
        return this.tipReference;
    }

    public void setTipReference(String value) {
        this.tipReference = value;
    }

    public boolean hasDockets() {
        return this.dockets.size() > 0;
    }

    @Transient
    public List<FinanceTransactionDocket> getDockets() {
        return this.dockets.getUnmodifiable();
    }

    public void addDocket(FinanceTransactionDocket printableDocket) {
        printableDocket.setFinanceTransaction(this);
        if (printableDocket != null && !this.dockets.contains(printableDocket)) {
            this.dockets.add(printableDocket);
        }
    }

    @Override
    public void saveChild() {
        if (this.getSubType() == null) {
            this.setSubType(FinanceUnit.getDefaultUnitFor(FinanceUnit.DEBIT_TYPE));
        }
        super.saveChild();
        this.dockets.saveChild();
        if (this.virtualEftpos.get() != null && EftposType.getRegister().containsValue(this.virtualEftpos.get().getEftposType())) {
            this.virtualEftpos.saveChild();
        }
    }

    public boolean adjustTipAmount(Price newTipAmount) {
        if (this.mayAdjustTip()) {
            this.setTip(newTipAmount);
            return true;
        }
        return false;
    }

    public boolean mayAdjustTip() {
        return this.tipReference != null && !this.tipReference.isEmpty() && this.authCode != null && !this.authCode.isEmpty();
    }

    public abstract EftposTransaction createReverseTransaction();

    public abstract EftposTransaction copyTransaction();

    @Column(name="allow_tip_adjustment")
    public boolean isAllowTipAdjustment() {
        return this.allowTipAdjustment;
    }

    public void setAllowTipAdjustment(boolean allowTipAdjustment) {
        this.allowTipAdjustment = allowTipAdjustment;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="fk_config_virtual_eftpos")
    public VirtualEftpos getVirtualEftpos() {
        return this.virtualEftpos.get();
    }

    public void setVirtualEftpos(VirtualEftpos virtualEftpos) {
        this.virtualEftpos.set(virtualEftpos);
    }

    @Override
    public FinanceTransaction transfer() {
        EftposTransaction txn = (EftposTransaction)super.transfer();
        txn.status = this.status;
        txn.virtualEftpos.set(this.virtualEftpos.get());
        txn.authCode = this.authCode;
        txn.tipReference = this.tipReference;
        txn.allowTipAdjustment = this.allowTipAdjustment;
        for (FinanceTransactionDocket docket : this.dockets) {
            txn.addDocket(docket);
        }
        return txn;
    }

    @Override
    public FinanceTransaction revertTransfer() {
        FinanceTransaction moved = super.revertTransfer();
        for (FinanceTransactionDocket docket : this.dockets) {
            ((EftposTransaction)moved).addDocket(docket);
        }
        return moved;
    }

    public static enum TransactionStatus {
        NOT_PROCESSED,
        PROCESSED,
        BUSY,
        NOT_CONNECTED,
        FAILED;

    }

    public static class Props
    extends FinanceTransaction.Props {
        public PropertiedObject.Property<FinanceTransactionDocket> DOCKETS;
        public PropertiedObject.Property<String> AUTH_CODE;
        public PropertiedObject.Property<String> TIP_REFERENCE;
        public PropertiedObject.Property<Boolean> ALLOW_TIP_ADJUSTMENT;
        public PropertiedObject.Property<VirtualEftpos> VIRTUAL_EFTPOS;
    }
}

