/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance.transactions;

import au.com.ordermate.util.Price;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Transient;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.finance.transactions.FinanceTransactionContext;
import ordermate.database.finance.transactions.FinanceUnit;
import org.hibernate.annotations.AccessType;

@Entity
@DiscriminatorValue(value="EXPORT")
@AccessType(value="property")
public class ExportTransaction
extends FinanceTransaction {
    public static final Props Properties = new Props();
    public static final String TYPE = "EXPORT";

    @Override
    @Transient
    public String getType() {
        return TYPE;
    }

    public ExportTransaction() {
    }

    public ExportTransaction(Price cost, FinanceTransactionContext context) {
        super(context, FinanceUnit.getDefaultUnitFor(TYPE));
        this.setTendered(cost);
        this.setPaid(cost);
        this.setTip(new Price(0.0, 0.01));
    }

    @Override
    public boolean canDelete() {
        return false;
    }

    @Override
    public boolean needsOpenCashdrawer() {
        return false;
    }

    @Override
    public boolean usesEftpos() {
        return false;
    }

    @Override
    protected FinanceTransaction makeNew() {
        return new ExportTransaction();
    }

    public static class Props
    extends FinanceTransaction.Props {
    }
}

