/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance.transactions;

import au.com.ordermate.persistence.Displayable;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.SaveableChild;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.StringUtils;
import java.awt.Color;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.finance.Shift;
import ordermate.database.finance.debtors.implementation.RoomAccount;
import ordermate.database.finance.debtors.transactions.DebtorPayment;
import ordermate.database.finance.debtors.transactions.DebtorSale;
import ordermate.database.finance.transactions.FinanceTransactionContext;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.finance.transactions.MOTOTransaction;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.TerminalLocation;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.misc.TerminalEventLog;
import ordermate.database.misc.TradingDay;
import ordermate.database.sales.Account;
import ordermate.database.sales.ItemGroup;
import ordermate.database.users.User;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Entity
@Table(name="finance_transaction")
@DiscriminatorColumn(name="type")
@AccessType(value="property")
public abstract class FinanceTransaction
extends PersistentObject
implements SaveableChild,
Displayable {
    public static final Props Properties = new Props();
    private Price tendered;
    private Price paid;
    private Price tip;
    private Price cashOut;
    private Price surcharge = Price.ZERO_DOLLAR;
    private boolean processed;
    private String systemState = "ACTIVE";
    private Date creationTime;
    private Date piggyPaymentTime;
    private Long extTransactionId;
    private String note = "";
    private String transactionReference;
    private String source;
    private Reference<TradingDay> tradingDay;
    private Reference<Shift> shift;
    private Reference<User> user;
    private Reference<Account> account;
    private Reference<Terminal> terminal;
    private Reference<CashDrawer> cashDrawer;
    private Reference<FinanceUnit> subType;
    private PersistentWriteableList<DebtorPayment> debtorPayments;
    private Reference<FinanceTransaction> movedTransaction;
    private Reference<TerminalLocation> location;
    private Reference<SalesLocation> salesLocation;
    private Long reversedTransactionId;
    private transient EventContext currentSaveContext;
    private Price roundingAmt;
    private boolean revertable;
    private String refundTxnRef;
    private String bankDesc;
    private String maskedCardNumber;

    @Transient
    public abstract String getType();

    public FinanceTransaction() {
        this.tradingDay = this.createReference(FinanceTransaction.Properties.TRADING_DAY);
        this.shift = this.createReference(FinanceTransaction.Properties.SHIFT);
        this.user = this.createReference(FinanceTransaction.Properties.USER);
        this.account = this.createReference(FinanceTransaction.Properties.ACCOUNT);
        this.terminal = this.createReference(FinanceTransaction.Properties.TERMINAL);
        this.cashDrawer = this.createReference(FinanceTransaction.Properties.CASH_DRAWER);
        this.subType = this.createReference(FinanceTransaction.Properties.SUB_TYPE);
        this.movedTransaction = this.createReference(FinanceTransaction.Properties.MOVED_TRANSACTION);
        this.location = this.createReference(FinanceTransaction.Properties.LOCATION);
        this.salesLocation = this.createReference(FinanceTransaction.Properties.SALES_LOCATION);
        this.roundingAmt = Price.ZERO_NO_ROUND;
        this.revertable = true;
        this.debtorPayments = this.createWriteableList(FinanceTransaction.Properties.DEBTOR_PAYMENTS);
    }

    FinanceTransaction(FinanceTransactionContext context, FinanceUnit subTypeUnit) {
        this(context.getUser(), context.getTerminal(), context.getCashDrawer(), subTypeUnit, context.getShift());
    }

    FinanceTransaction(User createUser, Terminal creator, CashDrawer drawer, FinanceUnit subTypeUnit, Shift newShift) {
        this();
        this.creationTime = new Date();
        this.cashOut = Price.ZERO_DOLLAR;
        this.setUser(createUser);
        this.setTerminal(creator);
        this.setLocation(creator.getLocation());
        this.setSalesLocation(creator.getSalesLocation());
        this.setCashDrawer(drawer);
        this.setSubType(subTypeUnit);
        this.setShift(newShift);
        this.setTradingDay(newShift.getTradingDay());
    }

    public FinanceTransaction transfer() {
        if (!"ACTIVE".equals(this.getSystemState())) {
            OrderMate.LOG.error("Cannot transfer a FinanceTransaction that has already been transferred:" + this.getID());
            throw new IllegalStateException("Cannot transfer a FinanceTransaction that has already been transferred:" + this.getID());
        }
        if (this.currentSaveContext == null) {
            this.currentSaveContext = new EventContext(this.getTerminal(), this.getUser());
        }
        Terminal currentTerminal = this.currentSaveContext.getTerminal();
        User currentUser = this.currentSaveContext.getUser();
        FinanceTransaction newTxn = this.makeNew();
        newTxn.tendered = this.tendered;
        newTxn.paid = this.paid;
        newTxn.tip = this.tip;
        newTxn.cashOut = this.cashOut;
        newTxn.processed = this.processed;
        newTxn.systemState = "ACTIVE";
        newTxn.creationTime = new Date();
        newTxn.note = this.note;
        newTxn.tradingDay.set(this.currentSaveContext.getTradingDay());
        newTxn.shift.set(this.currentSaveContext.getShift());
        newTxn.user.set(currentUser);
        newTxn.account.set(this.account.get());
        newTxn.terminal.set(currentTerminal);
        newTxn.location.set(currentTerminal.getLocation());
        newTxn.salesLocation.set(currentTerminal.getSalesLocation());
        newTxn.cashDrawer.set(currentTerminal.getAssignedCashDrawer(currentUser));
        newTxn.subType.set(this.subType.get());
        newTxn.roundingAmt = this.roundingAmt;
        newTxn.surcharge = this.surcharge;
        newTxn.transactionReference = this.transactionReference;
        newTxn.source = this.source;
        newTxn.maskedCardNumber = this.maskedCardNumber;
        this.setSystemState("MOVED");
        newTxn.setMovedTransaction(this);
        return newTxn;
    }

    public FinanceTransaction nonRevertableTransfer() {
        if (!"ACTIVE".equals(this.getSystemState())) {
            OrderMate.LOG.error("Cannot transfer a FinanceTransaction that has already been transferred:" + this.getID());
            throw new IllegalStateException("Cannot transfer a FinanceTransaction that has already been transferred:" + this.getID());
        }
        FinanceTransaction newTxn = this.makeNew();
        newTxn.tendered = this.tendered;
        newTxn.paid = this.paid;
        newTxn.tip = this.tip;
        newTxn.cashOut = this.cashOut;
        newTxn.processed = this.processed;
        newTxn.systemState = "ACTIVE";
        newTxn.creationTime = this.creationTime;
        newTxn.note = this.note;
        newTxn.tradingDay.set(this.tradingDay.get());
        newTxn.shift.set(this.shift.get());
        newTxn.user.set(this.user.get());
        newTxn.account.set(this.account.get());
        newTxn.terminal.set(this.terminal.get());
        newTxn.location.set(this.location.get());
        newTxn.salesLocation.set(this.salesLocation.get());
        newTxn.cashDrawer.set(this.cashDrawer.get());
        newTxn.subType.set(this.subType.get());
        newTxn.roundingAmt = this.roundingAmt;
        newTxn.surcharge = this.surcharge;
        newTxn.maskedCardNumber = this.maskedCardNumber;
        newTxn.setRevertable(false);
        this.setSystemState("DELETED");
        return newTxn;
    }

    @Transient
    public boolean isRevertable() {
        return this.revertable;
    }

    private void setRevertable(boolean revert) {
        this.revertable = revert;
    }

    public FinanceTransaction revertTransfer() {
        FinanceTransaction movedTxn = this.getMovedTransaction();
        if (movedTxn == null) {
            throw new IllegalStateException("Cannot revert a transfer for transaction:" + this.getID() + " - not a transfer");
        }
        movedTxn.setSystemState("ACTIVE");
        this.setSystemState("DELETED");
        return movedTxn;
    }

    protected abstract FinanceTransaction makeNew();

    public abstract boolean needsOpenCashdrawer();

    public abstract boolean usesEftpos();

    public abstract boolean canDelete();

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0.01")})
    @Column(name="amount_paid")
    public Price getPaid() {
        return this.paid;
    }

    @Override
    @Transient
    public String getLabel() {
        String label = null;
        label = this.getTip() != null && Math.abs(this.getTip().doubleValue()) > 0.001 ? new Price(this.getPaid().doubleValue() + this.getTip().doubleValue(), 0.01) + " (" + this.getTip() + " tip)" : (this.getPaid() != null ? this.getPaid().toString() : "No Payments");
        return label;
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0.01")})
    @Column(name="tendered")
    public Price getTendered() {
        return this.tendered;
    }

    @Column(name="tip")
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0.01")})
    public Price getTip() {
        return this.tip;
    }

    @Column(name="surcharge")
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0.01")})
    public Price getSurcharge() {
        return this.surcharge;
    }

    public void setSurcharge(Price value) {
        if (value != null) {
            this.surcharge = value;
        }
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0.01")})
    @Column(name="cash_out")
    public Price getCashOut() {
        return this.cashOut;
    }

    @Column(name="timestamp")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getCreationTime() {
        return this.creationTime;
    }

    @Column(name="piggy_payment_time")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getPiggyPaymentTime() {
        return this.piggyPaymentTime;
    }

    public void setPiggyPaymentTime(Date piggyPaymentTime) {
        this.piggyPaymentTime = piggyPaymentTime;
    }

    @Column(name="ext_transaction_id")
    public Long getExtTransactionId() {
        return this.extTransactionId;
    }

    public void setExtTransactionId(Long extTxnId) {
        this.extTransactionId = extTxnId;
    }

    @ManyToOne
    @JoinColumn(name="FK_finance_unit")
    public FinanceUnit getSubType() {
        return this.subType.get();
    }

    protected void setSubType(FinanceUnit subTypeUnit) {
        this.subType.set(subTypeUnit);
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="FK_finance_trading_day")
    public TradingDay getTradingDay() {
        return this.tradingDay.get();
    }

    protected void setTradingDay(TradingDay day) {
        this.tradingDay.set(day);
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="FK_finance_shift")
    public Shift getShift() {
        return this.shift.get();
    }

    protected void setShift(Shift newShift) {
        this.shift.set(newShift);
    }

    private void setUser(User creationUser) {
        this.user.set(creationUser);
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="FK_config_user")
    public User getUser() {
        return this.user.get();
    }

    private void setTerminal(Terminal creationTerm) {
        this.terminal.set(creationTerm);
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="FK_config_terminal")
    public Terminal getTerminal() {
        return this.terminal.get();
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="FK_config_cashdrawer")
    public CashDrawer getCashDrawer() {
        return this.cashDrawer.get();
    }

    private void setCashDrawer(CashDrawer drawer) {
        this.cashDrawer.set(drawer);
    }

    public void setCashOut(Price price) {
        this.cashOut = price;
    }

    public void setPaid(Price price) {
        this.paid = price;
    }

    public void setTendered(Price price) {
        this.tendered = price;
    }

    public void setTip(Price price) {
        this.tip = price;
    }

    @Column(name="transaction_reference")
    public String getTransactionReference() {
        return this.transactionReference;
    }

    public void setTransactionReference(String reference) {
        this.transactionReference = reference;
    }

    @Column(name="system_state")
    public String getSystemState() {
        return this.systemState;
    }

    public void setSystemState(String state) {
        this.systemState = state;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="FK_config_terminal_location")
    public TerminalLocation getLocation() {
        if (this.location.get() == null) {
            if (this.getTerminal() == null) {
                this.location.set(TerminalLocation.getDefaultLocation());
            } else {
                this.location.set(this.getTerminal().getLocation());
            }
        }
        return this.location.get();
    }

    public void setLocation(TerminalLocation value) {
        if (value == null) {
            if (this.getTerminal() == null) {
                this.location.set(TerminalLocation.getDefaultLocation());
            } else {
                this.location.set(this.getTerminal().getLocation());
            }
        } else {
            this.location.set(value);
        }
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="FK_config_sales_location")
    public SalesLocation getSalesLocation() {
        if (this.salesLocation.get() == null) {
            if (this.getTerminal() == null) {
                this.salesLocation.set(SalesLocation.getDefaultSalesLocation());
            } else {
                this.salesLocation.set(this.getTerminal().getSalesLocation());
            }
        }
        return this.salesLocation.get();
    }

    public void setSalesLocation(SalesLocation value) {
        if (value == null) {
            if (this.getTerminal() == null) {
                this.salesLocation.set(SalesLocation.getDefaultSalesLocation());
            } else {
                this.salesLocation.set(this.getTerminal().getSalesLocation());
            }
        } else {
            this.salesLocation.set(value);
        }
    }

    @Transient
    public Price getChange() {
        return Price.ZERO_DOLLAR;
    }

    public void setTransactionProcessed(boolean newProcessed) {
        this.processed = newProcessed;
    }

    @Transient
    public boolean isTransactionProcessed() {
        return this.processed;
    }

    @Transient
    public ItemGroup getPayoffGroup() {
        return this.account.get();
    }

    @ManyToOne
    @JoinColumn(name="FK_payoff_account")
    public Account getAccount() {
        return this.account.get();
    }

    @Transient
    public RoomAccount getTabPaidTo() {
        return new RoomAccount();
    }

    @Override
    public void prepareForSave(SaveContext context) {
        this.currentSaveContext = (EventContext)context;
    }

    @Transient
    public EventContext getCurrentSaveContext() {
        return this.currentSaveContext;
    }

    @Override
    public void saveChild() {
        boolean logPayment = false;
        if (!this.isPersistent()) {
            if (this.getPayoffGroup() != null) {
                logPayment = true;
            }
            if (this.creationTime == null) {
                this.setCreationTime(new Date());
            }
        }
        if (this instanceof MOTOTransaction && "DELETED".equals(this.getSystemState())) {
            return;
        }
        PersistenceManager.saveChild(this);
        if (logPayment) {
            TerminalEventLog.logPayment(this, this.getPayoffGroup().getItemHelper().getItemsForTransaction(this));
        }
    }

    @Override
    public void deleteChild() {
        if (this.currentSaveContext == null) {
            this.currentSaveContext = new EventContext(this.getTerminal(), this.getUser());
        }
        if (this.getPayoffGroup() != null) {
            TerminalEventLog.logPaymentDeleted(this.currentSaveContext, this);
        }
        this.systemState = "DELETED";
        PersistenceManager.saveChild(this);
    }

    @Override
    public boolean hasChildChanged() {
        return PersistenceManager.hasChildChanged(this);
    }

    @Override
    @Transient
    public Color getBackgroundColor() {
        return null;
    }

    @Override
    @Transient
    public Color getForegroundColor() {
        return null;
    }

    @Override
    @Transient
    public String getIcon() {
        return "";
    }

    @Override
    public String toString() {
        return this.getLabel();
    }

    @OneToMany(mappedBy="financeTransaction", targetEntity=DebtorPayment.class, fetch=FetchType.LAZY)
    public List<DebtorPayment> getDebtorPayments() {
        return this.debtorPayments.getUnmodifiable();
    }

    @Transient
    public List<DebtorSale> getDebtorSales() {
        ArrayList<DebtorSale> retValue = new ArrayList<DebtorSale>();
        for (DebtorPayment payment : this.getDebtorPayments()) {
            if (payment == null) continue;
            retValue.add(payment.getSale());
        }
        return retValue;
    }

    @Transient
    public boolean isRefundedDebtorPayment() {
        for (DebtorPayment payment : this.getDebtorPayments()) {
            if (!payment.isRefunded()) continue;
            return true;
        }
        return false;
    }

    public void registerDebtorPayment(DebtorPayment toAdd) {
        this.debtorPayments.add(toAdd);
    }

    public void deregisterDebtorPayment(DebtorPayment toRemove) {
        this.debtorPayments.remove(toRemove);
    }

    protected void setAccount(Account acc) {
        this.account.set(acc);
    }

    public void applyAccount(Account acc) {
        if (this.account.get() == null) {
            this.account.set(acc);
        }
    }

    protected void setCreationTime(Date time) {
        this.creationTime = time;
    }

    @Column(name="processed")
    protected boolean isProcessed() {
        return this.processed;
    }

    protected void setProcessed(boolean isProcessed) {
        this.processed = isProcessed;
    }

    protected void setDebtorPayments(List<DebtorPayment> payments) {
        this.debtorPayments = this.debtorPayments.clone();
        this.debtorPayments.set(payments);
    }

    @Column(name="note")
    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    @Column(name="source")
    public String getSource() {
        return this.source;
    }

    public void setSource(String value) {
        this.source = value;
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0.01")})
    @Column(name="rounding_amt")
    public Price getRoundingAmt() {
        return this.roundingAmt;
    }

    public void setRoundingAmt(Price roundingAmt) {
        this.roundingAmt = roundingAmt;
    }

    @Transient
    public boolean isActive() {
        return "ACTIVE".equalsIgnoreCase(this.systemState);
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="FK_finance_transaction")
    public FinanceTransaction getMovedTransaction() {
        return this.movedTransaction.get();
    }

    protected void setMovedTransaction(FinanceTransaction txn) {
        this.movedTransaction.set(txn);
    }

    @Transient
    public Long getReversedTransactionId() {
        return this.reversedTransactionId;
    }

    @Transient
    public boolean isPartialRefund() {
        if (this.reversedTransactionId == null) {
            return false;
        }
        FinanceTransaction reversedTransaction = PersistenceManager.getByID(this.reversedTransactionId, FinanceTransaction.class);
        BigDecimal amount = reversedTransaction.getPaid().toBigDecimal().add(this.getPaid().toBigDecimal());
        return amount.compareTo(BigDecimal.ZERO) > 0;
    }

    @Transient
    public boolean isFullyRefund() {
        if (this.reversedTransactionId == null) {
            return false;
        }
        FinanceTransaction reversedTransaction = PersistenceManager.getByID(this.reversedTransactionId, FinanceTransaction.class);
        BigDecimal amount = reversedTransaction.getPaid().toBigDecimal().add(this.getPaid().toBigDecimal());
        return amount.compareTo(BigDecimal.ZERO) <= 0;
    }

    public void setReversedTransactionId(Long reversedTransactionId) {
        this.reversedTransactionId = reversedTransactionId;
    }

    @Transient
    public String getRefundTxnRef() {
        return this.refundTxnRef;
    }

    public void setRefundTxnRef(String refundTxnRef) {
        this.refundTxnRef = refundTxnRef;
    }

    @Transient
    public String getBankDesc() {
        return this.bankDesc;
    }

    public void setBankDesc(String bankDesc) {
        this.bankDesc = bankDesc;
    }

    @Transient
    public Price getPaidExSurchExTip() {
        Price tally = this.getPaid();
        if (this.surcharge != null && !Price.ZERO_DOLLAR.equals(this.surcharge)) {
            tally = tally.subtract(this.surcharge);
        }
        return tally;
    }

    @Transient
    public Price getPaidExSurchIncTip() {
        Price tally = this.getPaid();
        if (this.tip != null && !Price.ZERO_DOLLAR.equals(this.tip)) {
            tally = tally.add(this.tip);
        }
        if (this.surcharge != null && !Price.ZERO_DOLLAR.equals(this.surcharge)) {
            tally = tally.subtract(this.surcharge);
        }
        return tally;
    }

    @Transient
    public Price getPaidTotal() {
        Price tally = this.getPaid();
        if (this.tip != null && !Price.ZERO_DOLLAR.equals(this.tip)) {
            tally = tally.add(this.tip);
        }
        if (this.cashOut != null && !Price.ZERO_DOLLAR.equals(this.cashOut)) {
            tally = tally.add(this.cashOut);
        }
        return tally;
    }

    @Transient
    public String getTrimmedRef() {
        int index;
        if (!StringUtils.isEmpty(this.transactionReference) && (index = this.transactionReference.lastIndexOf(".")) > 1) {
            return this.transactionReference.substring(index + 1);
        }
        return this.transactionReference;
    }

    public String getMaskedCardNumber() {
        return this.maskedCardNumber;
    }

    public void setMaskedCardNumber(String maskedCardNumber) {
        this.maskedCardNumber = maskedCardNumber;
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property PAID;
        public PropertiedObject.Property TENDERED;
        public PropertiedObject.Property TIP;
        public PropertiedObject.Property CASH_OUT;
        public PropertiedObject.Property SURCHARGE;
        public PropertiedObject.Property<Account> ACCOUNT;
        public PropertiedObject.Property<TradingDay> TRADING_DAY;
        public PropertiedObject.Property<Shift> SHIFT;
        public PropertiedObject.Property<User> USER;
        public PropertiedObject.Property<Terminal> TERMINAL;
        public PropertiedObject.Property PROCESSED;
        public PropertiedObject.Property<CashDrawer> CASH_DRAWER;
        public PropertiedObject.Property<FinanceUnit> SUB_TYPE;
        public PropertiedObject.Property<String> SYSTEM_STATE;
        public PropertiedObject.Property<Date> CREATION_TIME;
        public PropertiedObject.Property<Date> PIGGY_PAYMENT_TIME;
        public PropertiedObject.Property<String> NOTE;
        public PropertiedObject.Property<DebtorPayment> DEBTOR_PAYMENTS;
        public PropertiedObject.Property<Price> ROUNDING_AMT;
        public PropertiedObject.Property<FinanceTransaction> MOVED_TRANSACTION;
        public PropertiedObject.Property<TerminalLocation> LOCATION;
        public PropertiedObject.Property<SalesLocation> SALES_LOCATION;
        public PropertiedObject.Property<String> TRANSACTION_REFERENCE;
        public PropertiedObject.Property<String> SOURCE;
        public PropertiedObject.Property<String> REFUND_TXN_REF;
        public PropertiedObject.Property<Long> REVERSED_TRANSACTION_ID;
        public PropertiedObject.Property<Long> EXT_TRANSACTION_ID;
        public PropertiedObject.Property<String> BANK_DESC;
        public PropertiedObject.Property<String> MASKED_CARD_NUMBER;
        public PersistentObject.DerivedProperty<Price> PAID_EX_SURCH_EX_TIP = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)FinanceTransaction.class), "paidExSurchExTip");
        public PersistentObject.DerivedProperty<Price> PAID_EX_SURCH_INC_TIP = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)FinanceTransaction.class), "paidExSurchIncTip");
        public PersistentObject.DerivedProperty<Price> PAID_TOTAL = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)FinanceTransaction.class), "paidTotal");
        public PersistentObject.DerivedProperty<String> TRIMMED_REF = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)FinanceTransaction.class), "trimmedRef");
    }
}

