/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance.transactions;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.Price;
import java.util.List;
import ordermate.database.finance.transactions.FinanceTransaction;

public class FinanceTransactionHelper {
    private static FinanceTransactionHelper helper;

    public static FinanceTransactionHelper getInstance() {
        if (helper == null) {
            helper = new FinanceTransactionHelper();
        }
        return helper;
    }

    public Price getAmountNotRefunded(FinanceTransaction txn) {
        Price amt = txn.getPaid();
        if (txn.getID() == null) {
            return amt;
        }
        List<FinanceTransaction> txnList = PersistenceManager.getObjectList(FinanceTransaction.class, Query.select(FinanceTransaction.class).active(FinanceTransaction.class).equals(FinanceTransaction.Properties.REVERSED_TRANSACTION_ID, txn.getID()).toString());
        for (FinanceTransaction refTxn : txnList) {
            amt = amt.add(refTxn.getPaid());
        }
        return amt;
    }

    public Price getAmountRefunded(FinanceTransaction txn) {
        Price amt = Price.ZERO_DOLLAR;
        if (txn.getID() == null) {
            return Price.ZERO_DOLLAR;
        }
        List<FinanceTransaction> txnList = PersistenceManager.getObjectList(FinanceTransaction.class, Query.select(FinanceTransaction.class).active(FinanceTransaction.class).equals(FinanceTransaction.Properties.REVERSED_TRANSACTION_ID, txn.getID()).toString());
        for (FinanceTransaction refTxn : txnList) {
            amt = amt.add(refTxn.getPaid().abs());
        }
        return amt;
    }

    public boolean isTransactionFullyRefunded(FinanceTransaction txn) {
        if (!txn.isPersistent()) {
            return false;
        }
        ObjectQuery query = Query.select(FinanceTransaction.class).active(FinanceTransaction.class).equals(FinanceTransaction.Properties.REVERSED_TRANSACTION_ID, txn.getID()).limit(1);
        FinanceTransaction refundTxn = PersistenceManager.getObject(FinanceTransaction.class, query.toString());
        return refundTxn != null && refundTxn.getPaid().add(txn.getPaid()).doubleValue() <= 0.0;
    }

    public boolean hasPartRefunds(FinanceTransaction txn) {
        if (txn.getID() == null) {
            return false;
        }
        List<FinanceTransaction> txnList = PersistenceManager.getObjectList(FinanceTransaction.class, Query.select(FinanceTransaction.class).active(FinanceTransaction.class).equals(FinanceTransaction.Properties.REVERSED_TRANSACTION_ID, txn.getID()).toString());
        return txnList != null && !txnList.isEmpty();
    }
}

