/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance.transactions;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.Price;
import java.util.List;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.finance.transactions.FinanceTransactionItem;
import ordermate.database.sales.SalesLineItem;

public class FinanceTransactionItemHelper {
    private static FinanceTransactionItemHelper helper;

    public static FinanceTransactionItemHelper getInstance() {
        if (helper == null) {
            helper = new FinanceTransactionItemHelper();
        }
        return helper;
    }

    public boolean getItemIsPaidOff(SalesLineItem item) {
        List<FinanceTransactionItem> txnList = PersistenceManager.getObjectList(FinanceTransactionItem.class, Query.select(FinanceTransactionItem.class).equals(FinanceTransactionItem.Properties.SALES_ITEM, item.getID()).toString());
        for (FinanceTransactionItem i : txnList) {
            if (!i.isPaidOffInFull()) continue;
            return true;
        }
        if (item.hasFinanceTransactions()) {
            for (FinanceTransaction txn : item.getFinanceTransactions()) {
                List<FinanceTransactionItem> txnItemList = PersistenceManager.getObjectList(FinanceTransactionItem.class, Query.select(FinanceTransactionItem.class).equals(FinanceTransactionItem.Properties.FINANCE_TRANSACTION, txn.getID()).toString());
                List<SalesLineItem> items = item.getAccount().getItems();
                Price total = Price.ZERO_DOLLAR;
                for (FinanceTransactionItem i : txnItemList) {
                    for (int j = 0; j < items.size(); ++j) {
                        if (!items.get(j).getID().equals(i.getSalesItem().getID())) continue;
                        total = total.add(items.get(j).getPrice());
                    }
                }
                if (!txn.getPaid().approximatelyEquals(total)) continue;
                return true;
            }
        }
        return false;
    }

    public void setItemIsPaidOff(SalesLineItem item) {
        FinanceTransactionItem txnItem = PersistenceManager.getObject(FinanceTransactionItem.class, Query.select(FinanceTransactionItem.class).equals(FinanceTransactionItem.Properties.SALES_ITEM, item.getID()).orderBy(FinanceTransactionItem.Properties.ID, true).toString());
        if (txnItem != null) {
            txnItem.setPaidOffInFull(true);
            txnItem.saveChild();
        }
    }
}

