/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance.transactions;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentDisplayableObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.persistence.reference.QueryReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import ordermate.database.finance.FinanceAccountingGroup;
import ordermate.database.finance.transactions.KickCashdrawer;
import ordermate.database.queries.finance.transactions.FinanceUnitQueries;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@Table(name="finance_unit")
@AccessType(value="property")
@Cache(usage=CacheConcurrencyStrategy.READ_ONLY)
public class FinanceUnit
extends PersistentDisplayableObject
implements Saveable {
    private static final String PAPER_CHEQUE_NAME = "Paper Cheque";
    private static final String DEFAULTTYPE = "WEB";
    public static final Props Properties = new Props();
    public static final FinanceUnitType CREDIT_TYPE = new FinanceUnitType("CREDIT");
    public static final FinanceUnitType DEBIT_TYPE = new FinanceUnitType("DEBIT");
    public static final FinanceUnitType MOTO_TYPE = new FinanceUnitType("MOTO");
    public static final FinanceUnitType CASH_TYPE = new FinanceUnitType("CASH");
    public static final FinanceUnitType WEB_TYPE = new FinanceUnitType("WEB");
    public static final FinanceUnitType VOUCHER_TYPE = new FinanceUnitType("VOUCHER");
    public static final FinanceUnitType LOYALTY_TYPE = new FinanceUnitType("LOYALTY");
    private static final Reference<FinanceUnit> paperChequeType = new QueryReference<FinanceUnit>(FinanceUnit.class, Query.select(FinanceUnit.class).equals(FinanceUnit.Properties.TYPE, CREDIT_TYPE).equals(FinanceUnit.Properties.LABEL, "Paper Cheque").active(FinanceUnit.class));
    public static final Map<String, FinanceUnitType> financeUnitTypeMap = new HashMap<String, FinanceUnitType>();
    private String type;
    private boolean skimmable;
    private Reference<FinanceAccountingGroup> accountingGroup;
    private String systemState;
    private boolean usesEftpos;
    private double surcharge;
    private KickCashdrawer kickCashdrawer;
    private boolean modifiable;
    private boolean userdefined;
    public static List<String> userDefinedTypes = new ArrayList<String>();

    public static FinanceUnit getPaperChequeType() {
        return paperChequeType.get();
    }

    @Deprecated
    public FinanceUnit() {
        financeUnitTypeMap.put("giftcard", VOUCHER_TYPE);
        financeUnitTypeMap.put("loyalty", LOYALTY_TYPE);
        financeUnitTypeMap.put("credit", CREDIT_TYPE);
        financeUnitTypeMap.put("moto", CREDIT_TYPE);
        this.type = DEFAULTTYPE;
        this.accountingGroup = this.createReference(FinanceUnit.Properties.ACCOUNTING_GROUP);
        this.systemState = "ACTIVE";
        this.kickCashdrawer = KickCashdrawer.Always;
        this.modifiable = true;
        this.userdefined = true;
        userDefinedTypes.add("CREDIT");
        userDefinedTypes.add("DEBIT");
        userDefinedTypes.add(DEFAULTTYPE);
        userDefinedTypes.add("VOUCHER");
    }

    public FinanceUnit(String label, FinanceUnitType type, boolean usesEftpos) {
        financeUnitTypeMap.put("giftcard", VOUCHER_TYPE);
        financeUnitTypeMap.put("loyalty", LOYALTY_TYPE);
        financeUnitTypeMap.put("credit", CREDIT_TYPE);
        financeUnitTypeMap.put("moto", CREDIT_TYPE);
        this.type = DEFAULTTYPE;
        this.accountingGroup = this.createReference(FinanceUnit.Properties.ACCOUNTING_GROUP);
        this.systemState = "ACTIVE";
        this.kickCashdrawer = KickCashdrawer.Always;
        this.modifiable = true;
        this.userdefined = true;
        userDefinedTypes.add("CREDIT");
        userDefinedTypes.add("DEBIT");
        userDefinedTypes.add(DEFAULTTYPE);
        userDefinedTypes.add("VOUCHER");
        this.setLabel(label);
        this.setType(type.typeName);
        this.setUsesEftpos(usesEftpos);
        this.systemState = "ACTIVE";
    }

    public FinanceUnit(String label, FinanceUnitType type, boolean usesEftpos, boolean modifiable) {
        financeUnitTypeMap.put("giftcard", VOUCHER_TYPE);
        financeUnitTypeMap.put("loyalty", LOYALTY_TYPE);
        financeUnitTypeMap.put("credit", CREDIT_TYPE);
        financeUnitTypeMap.put("moto", CREDIT_TYPE);
        this.type = DEFAULTTYPE;
        this.accountingGroup = this.createReference(FinanceUnit.Properties.ACCOUNTING_GROUP);
        this.systemState = "ACTIVE";
        this.kickCashdrawer = KickCashdrawer.Always;
        this.modifiable = true;
        this.userdefined = true;
        userDefinedTypes.add("CREDIT");
        userDefinedTypes.add("DEBIT");
        userDefinedTypes.add(DEFAULTTYPE);
        userDefinedTypes.add("VOUCHER");
        this.setLabel(label);
        this.setType(type.typeName);
        this.setUsesEftpos(usesEftpos);
        this.setModifiable(modifiable);
        this.systemState = "ACTIVE";
    }

    @ManyToOne
    @JoinColumn(name="FK_finance_accounting_group")
    public FinanceAccountingGroup getAccountingGroup() {
        return this.accountingGroup.get();
    }

    @Column(name="unit_type")
    public String getType() {
        return this.type;
    }

    @Column(name="skimmable")
    public boolean isSkimmable() {
        return this.skimmable;
    }

    @Column(name="system_state")
    public String getSystemState() {
        return this.systemState;
    }

    public static FinanceUnit getDefaultUnitFor(String type) {
        return FinanceUnit.getUnitsFor(type).get(0);
    }

    public static FinanceUnit getDefaultUnitFor(FinanceUnitType type) {
        return FinanceUnit.getDefaultUnitFor(type.toString());
    }

    @Column(name="uses_eftpos")
    public boolean isUsesEftpos() {
        return this.usesEftpos;
    }

    public void setUsesEftpos(boolean value) {
        this.usesEftpos = value;
    }

    @Column(name="surcharge")
    public double getSurcharge() {
        return this.surcharge;
    }

    public void setSurcharge(double value) {
        this.surcharge = value > 0.2 ? value / 100.0 : value;
    }

    @Column(name="kick_cashdrawer")
    @Enumerated(value=EnumType.STRING)
    public KickCashdrawer getKickCashdrawer() {
        return this.kickCashdrawer;
    }

    public void setKickCashdrawer(KickCashdrawer yourDrawer) {
        this.kickCashdrawer = yourDrawer;
    }

    static List<FinanceUnit> getUnitsFor(String type) {
        String sql = Query.select(FinanceUnit.class).equals(FinanceUnit.Properties.TYPE, type).toString();
        return PersistenceManager.getObjectList(FinanceUnit.class, sql, new Object[0]);
    }

    public static List<FinanceUnit> getAllUnits() {
        String sql = Query.select(FinanceUnit.class).toString();
        return PersistenceManager.getObjectList(FinanceUnit.class, sql, new Object[0]);
    }

    public static Set getAllUnitTypes() {
        String sql = Query.select(FinanceUnit.class).toString();
        List<FinanceUnit> ofFinanceUnits = PersistenceManager.getObjectList(FinanceUnit.class, sql, new Object[0]);
        LinkedHashSet<String> allUnitTypes = new LinkedHashSet<String>();
        for (FinanceUnit fu : ofFinanceUnits) {
            allUnitTypes.add(fu.getType());
        }
        return allUnitTypes;
    }

    public static List<String> getAllUnitTypesWithoutCash() {
        String sql = Query.select(FinanceUnit.class).toString();
        List<FinanceUnit> ofFinanceUnits = PersistenceManager.getObjectList(FinanceUnit.class, sql, new Object[0]);
        ArrayList<String> allUnitTypes = new ArrayList<String>();
        for (FinanceUnit fu : ofFinanceUnits) {
            if (fu.getType() == null || fu.getType().contains("CASH") || allUnitTypes.contains(fu.getType())) continue;
            allUnitTypes.add(fu.getType());
        }
        return allUnitTypes;
    }

    public static List<FinanceUnit> getElectronicUnits() {
        String sql = Query.select(FinanceUnit.class).wherePropertyIn(FinanceUnit.Properties.TYPE, Arrays.asList(CREDIT_TYPE, DEBIT_TYPE)).active(FinanceUnit.class).orderBy(FinanceUnit.Properties.TYPE).orderBy(FinanceUnit.Properties.LABEL).toString();
        return PersistenceManager.getObjectList(FinanceUnit.class, sql, new Object[0]);
    }

    public static List<FinanceUnit> getCardPayableUnits() {
        String sql = Query.select(FinanceUnit.class).wherePropertyIn(FinanceUnit.Properties.TYPE, Arrays.asList(CREDIT_TYPE, DEBIT_TYPE)).equals(FinanceUnit.Properties.USES_EFTPOS, "1").active(FinanceUnit.class).orderBy(FinanceUnit.Properties.TYPE).orderBy(FinanceUnit.Properties.LABEL).toString();
        return PersistenceManager.getObjectList(FinanceUnit.class, sql, new Object[0]);
    }

    public static List<FinanceUnit> getWebUnits() {
        ObjectQuery query = Query.select(FinanceUnit.class).equals(FinanceUnit.Properties.TYPE, DEFAULTTYPE).active(FinanceUnit.class);
        return PersistenceManager.getObjectList(FinanceUnit.class, query.toString());
    }

    public static FinanceUnit getPayPalUnit() {
        FinanceUnit paypalUnit = null;
        for (FinanceUnit nextUnit : FinanceUnit.getWebUnits()) {
            if (!"PayPal".equals(nextUnit.getLabel())) continue;
            paypalUnit = nextUnit;
            break;
        }
        return paypalUnit;
    }

    public static List<FinanceUnit> getTipableUnits() {
        List<FinanceUnit> list = FinanceUnit.getElectronicUnits();
        list.add(FinanceUnit.getDefaultUnitFor(CASH_TYPE));
        list.remove(FinanceUnit.getPaperChequeType());
        return list;
    }

    public static FinanceUnit getUnitForName(String label) {
        if (label == null) {
            return null;
        }
        ObjectQuery query = Query.select(FinanceUnit.class).equals(FinanceUnit.Properties.LABEL, label).active(FinanceUnit.class).limit(1);
        return PersistenceManager.getObject(FinanceUnit.class, query.toString(), null);
    }

    public static FinanceUnit getUnitForUnitType(String unitType) {
        if (unitType == null) {
            return null;
        }
        ObjectQuery query = Query.select(FinanceUnit.class).equals(FinanceUnit.Properties.TYPE, unitType).active(FinanceUnit.class).limit(1);
        return PersistenceManager.getObject(FinanceUnit.class, query.toString(), null);
    }

    public static FinanceUnit getUnitForNameIgnoreSystemState(String label) {
        if (label == null) {
            return null;
        }
        ObjectQuery query = Query.select(FinanceUnit.class).equals(FinanceUnit.Properties.LABEL, label).limit(1);
        return PersistenceManager.getObject(FinanceUnit.class, query.toString(), null);
    }

    public static final List<FinanceUnit> getAllEftposUnits() {
        ObjectQuery query = Query.select(FinanceUnit.class).equals(FinanceUnit.Properties.USES_EFTPOS, 1.0).active(FinanceUnit.class).orderBy(FinanceUnit.Properties.TYPE).orderBy(FinanceUnit.Properties.LABEL);
        return PersistenceManager.getObjectList(FinanceUnit.class, query.toString(), null);
    }

    public void setSkimmable(boolean skimmableValue) {
        this.skimmable = skimmableValue;
    }

    public void setAccountingGroup(FinanceAccountingGroup newAccountingGroup) {
        this.accountingGroup.set(newAccountingGroup);
    }

    public void setType(String newType) {
        this.type = newType;
    }

    public void setSystemState(String newSystemState) {
        this.systemState = newSystemState;
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    public static List<FinanceUnit> getVoucherUnits() {
        return FinanceUnit.getUnitsFor(VOUCHER_TYPE.toString());
    }

    public static List<FinanceUnit> getActiveDebitUnits() {
        return FinanceUnit.getActiveFinanceUnits(DEBIT_TYPE.toString());
    }

    public static List<FinanceUnit> getActiveMOTOUnits() {
        return FinanceUnit.getActiveFinanceUnits(MOTO_TYPE.toString());
    }

    public static List<FinanceUnit> getActiveCreditUnits() {
        return FinanceUnit.getActiveFinanceUnits(CREDIT_TYPE.toString());
    }

    private static List<FinanceUnit> getActiveFinanceUnits(String type) {
        return PersistenceManager.getObjectList(FinanceUnit.class, FinanceUnitQueries.getActiveFinanceUnits(type).toString());
    }

    public static List<FinanceUnit> getActiveTipsFinanceUnits() {
        ArrayList<String> types = new ArrayList<String>();
        types.add("CASH");
        types.add("CREDIT");
        types.add("DEBIT");
        types.add("MOTO");
        types.add(DEFAULTTYPE);
        ObjectQuery query = Query.select(FinanceUnit.class).active(FinanceUnit.class).wherePropertyIn(FinanceUnit.Properties.TYPE, types).orderBy(FinanceUnit.Properties.LABEL);
        return PersistenceManager.getObjectList(FinanceUnit.class, query.toString(), null);
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
    }

    @Override
    public void delete() {
        this.systemState = "DELETED";
        PersistenceManager.save(this);
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    public static FinanceUnit createUnit(FinanceUnitType theType, String unitName, boolean usesEftpos) {
        FinanceUnit unit = new FinanceUnit(unitName, theType, usesEftpos);
        FinanceUnit defUnit = FinanceUnit.getDefaultUnitFor(theType);
        if (defUnit != null) {
            unit.setAccountingGroup(defUnit.getAccountingGroup());
            unit.setModifiable(defUnit.isModifiable());
            unit.setKickCashdrawer(defUnit.kickCashdrawer);
        }
        unit.save();
        return unit;
    }

    public static FinanceUnit createUnit(FinanceUnitType theType, String unitName, boolean usesEftpos, boolean modifiable) {
        FinanceUnit unit = new FinanceUnit(unitName, theType, usesEftpos, modifiable);
        FinanceUnit defUnit = FinanceUnit.getDefaultUnitFor(theType);
        if (defUnit != null) {
            unit.setAccountingGroup(defUnit.getAccountingGroup());
            unit.setKickCashdrawer(defUnit.kickCashdrawer);
        }
        unit.save();
        return unit;
    }

    @Column(name="modifiable")
    public boolean isModifiable() {
        return this.modifiable;
    }

    public void setModifiable(boolean modifiable) {
        this.modifiable = modifiable;
    }

    @Column(name="userdefined")
    public boolean isUserdefined() {
        return this.userdefined;
    }

    public void setUserdefined(boolean userdefined) {
        this.userdefined = userdefined;
    }

    public static class FinanceUnitType {
        private String typeName;

        public String toString() {
            return this.typeName;
        }

        private FinanceUnitType(String name) {
            this.typeName = name;
        }
    }

    public static enum EftposUnitType {
        VISA("Visa"),
        MASTERCARD("Mastercard"),
        BANKCARD("Bankcard"),
        SAVINGS_ACC("Savings Acc"),
        CHEQUE_ACC("Cheque Acc");

        private String unitName;

        private EftposUnitType(String name) {
            this.unitName = name;
        }

        public String getUnitName() {
            return this.unitName;
        }
    }

    public static class Props
    extends PersistentDisplayableObject.Props {
        public PropertiedObject.Property<String> TYPE;
        public PropertiedObject.Property SYSTEM_STATE;
        public PropertiedObject.Property<FinanceAccountingGroup> ACCOUNTING_GROUP;
        public PropertiedObject.Property SKIMMABLE;
        public PropertiedObject.Property USES_EFTPOS;
        public PropertiedObject.Property SURCHARGE;
        public PropertiedObject.Property KICK_CASHDRAWER;
        public PropertiedObject.Property MODIFIABLE;
        public PropertiedObject.Property USERDEFINED;
    }
}

