/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance.transactions;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.util.Price;
import java.util.Date;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.finance.PreauthType;
import ordermate.database.finance.Shift;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.finance.transactions.FinanceTransactionContext;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.eftpos.EftposStatus;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.sales.Account;
import ordermate.database.users.User;

public class PreauthTransaction
extends PersistentObject
implements Saveable {
    public static final Props Properties = new Props();
    private Price amount;
    private String identifier;
    private String txnReference;
    private String authCode;
    private String rrn;
    private String completionRef;
    private String cardType;
    private String reason;
    private String additionalData;
    private Date created;
    private EftposStatus status;
    private SystemState systemState = SystemState.ACTIVE_STATE;
    private PreauthType type;
    private Reference<FinanceTransaction> realTxn;
    private Reference<Terminal> terminal;
    private Reference<CashDrawer> cashDrawer;
    private Reference<User> user;
    private Reference<Shift> shift;
    private Reference<Account> account;
    private Reference<PreauthTransaction> referredTxn;

    @Deprecated
    public PreauthTransaction() {
        this.realTxn = this.createReference(PreauthTransaction.Properties.REAL_TXN);
        this.terminal = this.createReference(PreauthTransaction.Properties.TERMINAL);
        this.cashDrawer = this.createReference(PreauthTransaction.Properties.CASH_DRAWER);
        this.user = this.createReference(PreauthTransaction.Properties.USER);
        this.shift = this.createReference(PreauthTransaction.Properties.SHIFT);
        this.account = this.createReference(PreauthTransaction.Properties.ACCOUNT);
        this.referredTxn = this.createReference(PreauthTransaction.Properties.REFERRED_TXN);
    }

    public PreauthTransaction(String identifier, Price amount, PreauthType type, FinanceTransactionContext context) {
        this.realTxn = this.createReference(PreauthTransaction.Properties.REAL_TXN);
        this.terminal = this.createReference(PreauthTransaction.Properties.TERMINAL);
        this.cashDrawer = this.createReference(PreauthTransaction.Properties.CASH_DRAWER);
        this.user = this.createReference(PreauthTransaction.Properties.USER);
        this.shift = this.createReference(PreauthTransaction.Properties.SHIFT);
        this.account = this.createReference(PreauthTransaction.Properties.ACCOUNT);
        this.referredTxn = this.createReference(PreauthTransaction.Properties.REFERRED_TXN);
        if (type == null) {
            throw new IllegalArgumentException("Cannot create a preauth transaction without a type");
        }
        this.identifier = identifier;
        this.amount = amount;
        this.type = type;
        this.setTerminal(context.getTerminal());
        this.setShift(context.getShift());
        this.setUser(context.getUser());
        this.setCashDrawer(context.getCashDrawer());
        this.status = EftposStatus.UNKNOWN;
        if (this.getTerminal() == null || this.getShift() == null || this.getUser() == null || this.getCashDrawer() == null) {
            throw new IllegalStateException("Cannot make a preauth without proper context:" + this.getTerminal() + " " + this.getShift() + " " + this.getUser() + " " + this.getCashDrawer());
        }
    }

    public Price getAmount() {
        return this.amount;
    }

    public void setAmount(Price amount) {
        this.amount = amount;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public SystemState getSystemState() {
        return this.systemState;
    }

    public void setSystemState(SystemState systemState) {
        this.systemState = systemState;
    }

    public String getTxnReference() {
        return this.txnReference;
    }

    public void setTxnReference(String value) {
        this.txnReference = value;
    }

    public Date getCreated() {
        return this.created;
    }

    protected void setCreated(Date value) {
        this.created = value;
    }

    public PreauthType getType() {
        return this.type;
    }

    protected void setType(PreauthType value) {
        this.type = value;
    }

    public EftposStatus getStatus() {
        return this.status;
    }

    public void setStatus(EftposStatus value) {
        this.status = value;
    }

    public FinanceTransaction getRealTxn() {
        return this.realTxn.get();
    }

    public void setRealTxn(FinanceTransaction txn) {
        this.realTxn.set(txn);
    }

    public Terminal getTerminal() {
        return this.terminal.get();
    }

    public void setTerminal(Terminal terminal) {
        this.terminal.set(terminal);
    }

    public User getUser() {
        return this.user.get();
    }

    protected void setUser(User user) {
        this.user.set(user);
    }

    public CashDrawer getCashDrawer() {
        return this.cashDrawer.get();
    }

    public void setCashDrawer(CashDrawer value) {
        this.cashDrawer.set(value);
    }

    public Shift getShift() {
        return this.shift.get();
    }

    public void setShift(Shift shift) {
        this.shift.set(shift);
    }

    public Account getAccount() {
        return this.account.get();
    }

    public void setAccount(Account value) {
        this.account.set(value);
    }

    public PreauthTransaction getReferredTxn() {
        return this.referredTxn.get();
    }

    public void setReferredTxn(PreauthTransaction value) {
        this.referredTxn.set(value);
    }

    public String getAuthCode() {
        return this.authCode;
    }

    public void setAuthCode(String authCode) {
        this.authCode = authCode;
    }

    public String getRrn() {
        return this.rrn;
    }

    public void setRrn(String rrn) {
        this.rrn = rrn;
    }

    public String getCardType() {
        return this.cardType;
    }

    public void setCardType(String value) {
        this.cardType = value;
    }

    public String getCompletionRef() {
        return this.completionRef;
    }

    public void setCompletionRef(String completionRef) {
        this.completionRef = completionRef;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String value) {
        this.reason = value;
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
    }

    @Override
    public void delete() {
        this.setSystemState(SystemState.DELETED_STATE);
        PersistenceManager.save(this);
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    public static ObjectQuery getExisting(Account account) {
        return Query.select(PreauthTransaction.class).equals(PreauthTransaction.Properties.ACCOUNT, account).equals(PreauthTransaction.Properties.SYSTEM_STATE, SystemState.ACTIVE_STATE).equals(PreauthTransaction.Properties.TYPE, (Object)PreauthType.ALLOCATION).not().isNull(PreauthTransaction.Properties.COMPLETION_REF);
    }

    public String getAdditionalData() {
        return this.additionalData;
    }

    public void setAdditionalData(String additionalData) {
        this.additionalData = additionalData;
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<Price> AMOUNT;
        public PropertiedObject.Property<String> IDENTIFIER;
        public PropertiedObject.Property<String> TXN_REFERENCE;
        public PropertiedObject.Property<Date> CREATED;
        public PropertiedObject.Property<SystemState> SYSTEM_STATE;
        public PropertiedObject.Property<EftposStatus> STATUS;
        public PropertiedObject.Property<PreauthType> TYPE;
        public PropertiedObject.Property<FinanceTransaction> REAL_TXN;
        public PropertiedObject.Property<CashDrawer> CASH_DRAWER;
        public PropertiedObject.Property<Terminal> TERMINAL;
        public PropertiedObject.Property<User> USER;
        public PropertiedObject.Property<Shift> SHIFT;
        public PropertiedObject.Property<Account> ACCOUNT;
        public PropertiedObject.Property<PreauthTransaction> REFERRED_TXN;
        public PropertiedObject.Property<String> AUTH_CODE;
        public PropertiedObject.Property<String> RRN;
        public PropertiedObject.Property<String> COMPLETION_REF;
        public PropertiedObject.Property<String> CARD_TYPE;
        public PropertiedObject.Property<String> REASON;
        public PropertiedObject.Property<String> ADDITIONAL_DATA;
    }
}

