/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance.transactions;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.Price;
import java.util.List;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.finance.PreauthType;
import ordermate.database.finance.transactions.PreauthTransaction;

public class PreauthTransactionHelper {
    private static PreauthTransactionHelper helper;

    public static PreauthTransactionHelper getInstance() {
        if (helper == null) {
            helper = new PreauthTransactionHelper();
        }
        return helper;
    }

    public Price getTotalPreAuth(PreauthTransaction txn) {
        Price verify = txn.getAmount();
        List<PreauthTransaction> txnList = PersistenceManager.getObjectList(PreauthTransaction.class, Query.select(PreauthTransaction.class).equals(PreauthTransaction.Properties.IDENTIFIER, txn.getIdentifier()).not().equals(PreauthTransaction.Properties.TYPE, (Object)PreauthType.ALLOCATION).equals(PreauthTransaction.Properties.SYSTEM_STATE, SystemState.ACTIVE_STATE).toString());
        for (PreauthTransaction p : txnList) {
            if (!p.getType().equals((Object)PreauthType.TOPUP)) continue;
            verify = verify.add(p.getAmount());
        }
        return verify;
    }

    public void setAllTxnsAsInactive(PreauthTransaction txn) {
        List<PreauthTransaction> txnList = PersistenceManager.getObjectList(PreauthTransaction.class, Query.select(PreauthTransaction.class).equals(PreauthTransaction.Properties.IDENTIFIER, txn.getIdentifier()).not().equals(PreauthTransaction.Properties.TYPE, (Object)PreauthType.ALLOCATION).equals(PreauthTransaction.Properties.SYSTEM_STATE, SystemState.ACTIVE_STATE).toString());
        for (PreauthTransaction p : txnList) {
            p.setSystemState(SystemState.INACTIVE_STATE);
            p.save();
        }
    }
}

