/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance.transactions;

import au.com.ordermate.persistence.PersistenceManager;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.finance.giftvoucher.GiftVoucherTransaction;
import ordermate.database.finance.giftvoucher.VoucherAdministrator;
import ordermate.database.finance.giftvoucher.VoucherResponse;
import ordermate.database.sales.Account;
import ordermate.integration.voucher.VoucherAdministratorRMI;

public class VoucherTopupReversalHelper {
    private final List<GiftVoucherTransaction> transactionsToReverse;
    private VoucherAdministrator administrator;
    private final VoucherAdministrator defaultAdmin = VoucherAdministratorRMI.getInstance();

    public VoucherTopupReversalHelper(VoucherAdministrator admin) {
        this();
        this.administrator = admin == null ? this.defaultAdmin : admin;
    }

    public VoucherTopupReversalHelper() {
        this.transactionsToReverse = new ArrayList<GiftVoucherTransaction>();
        this.administrator = this.defaultAdmin;
    }

    public void markForReversal(GiftVoucherTransaction toReverse) {
        if (toReverse != null && !this.transactionsToReverse.contains(toReverse)) {
            this.transactionsToReverse.add(toReverse);
        }
    }

    public void cancelReversal(GiftVoucherTransaction toNotReverse) {
        if (toNotReverse != null) {
            this.transactionsToReverse.remove(toNotReverse);
        }
    }

    public List<VoucherResponse> reverseAll(Account account, EventContext context) {
        ArrayList<VoucherResponse> toReturn = this.transactionsToReverse.isEmpty() ? null : new ArrayList<VoucherResponse>();
        for (GiftVoucherTransaction transaction : this.transactionsToReverse) {
            VoucherResponse response = this.doReversal(transaction = (GiftVoucherTransaction)PersistenceManager.reacquire(transaction), context);
            if (response != null && response.isApproved()) {
                account.addVoucherTransaction(response.getTxn());
                continue;
            }
            if (response == null) {
                response = new VoucherResponse(null, false, null);
                response.setDescription("Servermate could not be contacted.");
            }
            toReturn.add(response);
        }
        this.transactionsToReverse.clear();
        return toReturn;
    }

    private VoucherResponse doReversal(GiftVoucherTransaction txn, EventContext context) {
        if (this.administrator instanceof VoucherAdministratorRMI) {
            return ((VoucherAdministratorRMI)this.administrator).reverseTransaction(txn, context);
        }
        try {
            return this.administrator.reverseTransaction(txn, context);
        }
        catch (RemoteException e) {
            OrderMate.LOG.error("Failed to reverse transaction via VoucherAdministrator!", (Throwable)e);
            return null;
        }
    }

    public boolean hasReversals() {
        return !this.transactionsToReverse.isEmpty();
    }

    public void clear() {
        this.transactionsToReverse.clear();
    }
}

