/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance.transactions;

import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.util.Price;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Transient;
import ordermate.database.finance.Shift;
import ordermate.database.finance.giftvoucher.GiftVoucherTransaction;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.users.User;
import org.hibernate.annotations.AccessType;

@Entity
@DiscriminatorValue(value="VOUCHER")
@AccessType(value="property")
public class VoucherTransaction
extends FinanceTransaction {
    public static final Props Properties = new Props();
    public static final String TYPE = "VOUCHER";
    private String authCode;
    private Reference<GiftVoucherTransaction> giftVoucherTxn;
    private String remainingBalanceNote;

    @Deprecated
    public VoucherTransaction() {
        this.giftVoucherTxn = this.createReference(VoucherTransaction.Properties.GIFT_VOUCHER_TXN);
    }

    public VoucherTransaction(User createUser, Terminal creator, CashDrawer drawer, Shift newShift, GiftVoucherTransaction yourTxn) {
        super(createUser, creator, drawer, FinanceUnit.getUnitsFor(TYPE).get(0), newShift);
        this.giftVoucherTxn = this.createReference(VoucherTransaction.Properties.GIFT_VOUCHER_TXN);
        if (yourTxn == null) {
            throw new IllegalArgumentException("Cannot have a null gift voucher txn for a finance voucher txn");
        }
        if (Price.ZERO_DOLLAR.lessThan(yourTxn.getAmount()) && !yourTxn.isReversal()) {
            throw new IllegalArgumentException("Cannot consume a positive amount.");
        }
        this.setGiftVoucherTxn(yourTxn);
        this.setAuthCode(yourTxn.getAuthId());
        this.setPaid(yourTxn.getAmount().negate());
        this.setTendered(yourTxn.getAmount().negate());
        this.setCashOut(Price.ZERO_DOLLAR);
        this.setTip(Price.ZERO_DOLLAR);
    }

    public VoucherTransaction(VoucherTransaction toCopy) {
        this(toCopy.getUser(), toCopy.getTerminal(), toCopy.getCashDrawer(), toCopy.getShift(), toCopy.getGiftVoucherTxn());
    }

    @Transient
    public GiftVoucherTransaction getGiftVoucherTxn() {
        return this.giftVoucherTxn.get();
    }

    protected void setGiftVoucherTxn(GiftVoucherTransaction value) {
        this.giftVoucherTxn.set(value);
    }

    @Transient
    public GiftVoucherTransaction reaquireAndGetGiftTransaction(Long currentObjectID) {
        this.giftVoucherTxn.setObjectID(currentObjectID);
        return this.getGiftVoucherTxn();
    }

    @Column(name="auth_code")
    public String getAuthCode() {
        return this.authCode;
    }

    public void setAuthCode(String value) {
        this.authCode = value;
    }

    @Override
    @Transient
    public String getType() {
        return TYPE;
    }

    @Override
    protected FinanceTransaction makeNew() {
        return new VoucherTransaction();
    }

    @Override
    public boolean needsOpenCashdrawer() {
        return false;
    }

    @Override
    public boolean usesEftpos() {
        return false;
    }

    @Override
    public boolean canDelete() {
        if (this.getGiftVoucherTxn() != null) {
            return !this.getGiftVoucherTxn().isReversal() && !this.getGiftVoucherTxn().isReversed();
        }
        return false;
    }

    public void setRemainingBalanceNote(String note) {
        this.remainingBalanceNote = note;
    }

    @Transient
    public String getRemainingBalanceNote() {
        return this.remainingBalanceNote;
    }

    public static class Props
    extends FinanceTransaction.Props {
        public PropertiedObject.Property<GiftVoucherTransaction> GIFT_VOUCHER_TXN;
        public PropertiedObject.Property<String> AUTH_CODE;
    }
}

