/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance.transactions;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.Price;
import java.util.Calendar;
import java.util.Date;
import ordermate.database.config.report.ReportGroup;
import ordermate.database.config.report.ReportProperty;
import ordermate.database.finance.giftvoucher.GiftVoucher;
import ordermate.database.finance.giftvoucher.GiftVoucherTransaction;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.finance.transactions.VoucherTransaction;
import ordermate.database.sales.Account;
import ordermate.integration.voucher.VoucherAdministratorRMI;
import ordermate.internationalization.Internationalization;

public class VoucherTransactionHelper {
    private static VoucherTransactionHelper helper;

    public static VoucherTransactionHelper getInstance() {
        if (helper == null) {
            helper = new VoucherTransactionHelper();
        }
        return helper;
    }

    private VoucherTransactionHelper() {
    }

    public Price getRemainingBalance(FinanceTransaction transaction) {
        GiftVoucher voucher;
        VoucherTransaction txn;
        if (transaction instanceof VoucherTransaction && (txn = (VoucherTransaction)transaction).getGiftVoucherTxn() != null && (voucher = txn.getGiftVoucherTxn().getGiftVoucher()) != null) {
            if (voucher.hasChanged()) {
                voucher = (GiftVoucher)PersistenceManager.reacquire(voucher);
            }
            return voucher.getCachedValue();
        }
        return null;
    }

    public String getRemainingBalanceString(FinanceTransaction transaction) {
        String remaining = null;
        if (transaction instanceof VoucherTransaction) {
            Price balance = this.getRemainingBalance(transaction);
            remaining = Internationalization.getLiteralFor("REMAINING_BALANCE") + ": " + balance;
        }
        return remaining;
    }

    public GiftVoucher getLastValidRedeemVoucher(Account account) {
        GiftVoucher voucherRedeemed = null;
        if (account.getVoucherTxns() != null && !account.getVoucherTxns().isEmpty()) {
            for (GiftVoucherTransaction txn : account.getVoucherTxns()) {
                if (txn.getGiftVoucher() == null || !txn.isActive() || !txn.isAuthorised() || !txn.getAmount().lessThan(Price.ZERO_NO_ROUND)) continue;
                voucherRedeemed = txn.getGiftVoucher();
            }
        }
        if (voucherRedeemed != null) {
            voucherRedeemed = (GiftVoucher)PersistenceManager.reacquire(voucherRedeemed);
        }
        return voucherRedeemed;
    }

    public Date returnExpiryDateTime(Integer expiryPeriod, Date creationDateTime) {
        if (expiryPeriod == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        if (creationDateTime != null) {
            cal.setTime(creationDateTime);
        }
        cal.add(5, expiryPeriod);
        return cal.getTime();
    }

    public Date returnExpiryDateForVoucher(GiftVoucher voucher) throws IllegalStateException {
        Integer defaultPeriod = VoucherAdministratorRMI.getInstance().getVoucherDefaultExpiryPeriod(voucher.getUniqueId());
        if ("1".equals(ReportProperty.find(ReportGroup.General, "One More Day for Expiry").getValue())) {
            defaultPeriod = defaultPeriod + 1;
        }
        return this.returnExpiryDateTime(defaultPeriod, new Date());
    }
}

