/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance.transactions;

import au.com.ordermate.util.Price;
import java.util.List;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Transient;
import ordermate.database.finance.Shift;
import ordermate.database.finance.transactions.EftposTransaction;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.users.User;
import org.hibernate.annotations.AccessType;

@Entity
@DiscriminatorValue(value="WEB")
@AccessType(value="property")
public class WebTransaction
extends EftposTransaction {
    public static final Props Properties = new Props();
    public static final String TYPE = "WEB";

    @Deprecated
    public WebTransaction() {
    }

    public WebTransaction(User user, Terminal terminal, Price paid, Price tip, CashDrawer drawer, FinanceUnit type, Shift newShift) {
        super(user, terminal, paid, tip, Price.ZERO_DOLLAR, drawer, type, newShift);
    }

    @Override
    public WebTransaction createReverseTransaction() {
        WebTransaction copy = new WebTransaction(this.getUser(), this.getTerminal(), this.getPaid().negate(), this.getTip().negate(), this.getCashDrawer(), this.getSubType(), this.getShift());
        return copy;
    }

    @Override
    public EftposTransaction copyTransaction() {
        WebTransaction txn = new WebTransaction(this.getUser(), this.getTerminal(), this.getPaid(), this.getTip(), this.getCashDrawer(), this.getSubType(), this.getShift());
        txn.setSurcharge(this.getSurcharge());
        return txn;
    }

    @Override
    @Transient
    public String getType() {
        return TYPE;
    }

    @Override
    public boolean canDelete() {
        return true;
    }

    public static List<FinanceUnit> getWebUnitTypes() {
        return FinanceUnit.getUnitsFor(TYPE);
    }

    @Override
    protected FinanceTransaction makeNew() {
        return new WebTransaction();
    }

    public static class Props
    extends EftposTransaction.Props {
    }
}

