/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.gui;

import au.com.ordermate.persistence.Displayable;
import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;

public class DisplayableComboListCellRenderer
extends DefaultListCellRenderer {
    private static final int DEFAULT_MAX_CHARS = 12;
    private int maxChars;

    public DisplayableComboListCellRenderer() {
        this(12);
    }

    public DisplayableComboListCellRenderer(int maximumCharacters) {
        this.maxChars = maximumCharacters;
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel comp = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        Displayable group = (Displayable)value;
        if (group != null) {
            comp.setBackground(group.getBackgroundColor());
            comp.setForeground(group.getForegroundColor());
            String text = group.getLabel();
            if (text.length() > this.maxChars) {
                text = text.substring(0, this.maxChars);
            }
            comp.setText(text);
        }
        return comp;
    }
}

