/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.gui;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import java.util.List;
import ordermate.database.gui.FavouritesEntry;
import ordermate.database.users.User;

public class FavouriteEntryHelper {
    public static List<FavouritesEntry> getFavourites(User user, boolean orderById) {
        ObjectQuery query = Query.select(FavouritesEntry.class).equals(FavouritesEntry.Properties.USER, user);
        if (orderById) {
            query.orderBy(FavouritesEntry.Properties.ID);
        }
        return PersistenceManager.getObjectList(FavouritesEntry.class, query.toString(), PersistenceManager.EMPTY_OBJECT_ARRAY);
    }

    public static List<FavouritesEntry> getFavourites(User user) {
        return FavouriteEntryHelper.getFavourites(user, false);
    }

    public static List<FavouritesEntry> getRecentFavourites(User user, int favouriteCount) {
        List<FavouritesEntry> allEntries = FavouriteEntryHelper.getFavourites(user, true);
        int maxEntries = favouriteCount;
        if (allEntries.size() > maxEntries) {
            return allEntries.subList(allEntries.size() - favouriteCount, allEntries.size());
        }
        return allEntries;
    }

    public static void createDefaultFavouritesForUser(User user) {
        String[] defaultFavourites = new String[]{"officemate.screens.reports.dailysummary.DailySummaryReportState", "officemate.screens.reports.itemssold.substates.adhocreport.AdhocItemSoldReportState", "Closed Accounts", "officemate.screens.reports.dailysummary.DailySummaryByAccountTypeReportState"};
        List<FavouritesEntry> existingFavourites = FavouriteEntryHelper.getFavourites(user);
        if (existingFavourites.size() == 0) {
            for (String favKey : defaultFavourites) {
                FavouritesEntry favouritesEntry = new FavouritesEntry(favKey, user);
                PersistenceManager.save(favouritesEntry);
            }
        }
    }
}

