/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.gui;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import ordermate.database.users.User;
import org.hibernate.annotations.AccessType;

@Entity
@Table(name="gui_officemate_favourites")
@AccessType(value="property")
public class FavouritesEntry
extends PersistentObject
implements Saveable {
    public static final Props Properties = new Props();
    private String favouriteID;
    private Reference<User> user;

    public FavouritesEntry() {
        this.user = this.createReference(FavouritesEntry.Properties.USER);
    }

    public FavouritesEntry(String favouriteStateKey, User currentUser) {
        this.user = this.createReference(FavouritesEntry.Properties.USER);
        if (favouriteStateKey == null) {
            throw new IllegalArgumentException("Favourite state identifier should not be null");
        }
        if (currentUser == null) {
            throw new IllegalArgumentException("Current user should not be null");
        }
        this.favouriteID = favouriteStateKey;
        this.user.set(currentUser);
    }

    @ManyToOne
    @JoinColumn(name="fk_config_user")
    public User getUser() {
        return this.user.get();
    }

    @Transient
    public String getFavouritesID() {
        return this.favouriteID;
    }

    @Override
    public void delete() {
        PersistenceManager.delete(this);
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        if (this.getUser() == null) {
            throw new IllegalStateException("Cannot save null user");
        }
        if (this.favouriteID == null) {
            throw new IllegalStateException("Cannot save null state");
        }
        PersistenceManager.save(this);
    }

    @Column(name="officemate_favourites_state")
    protected String getFavouriteID() {
        return this.favouriteID;
    }

    protected void setFavouriteID(String newFavouriteID) {
        this.favouriteID = newFavouriteID;
    }

    protected void setUser(User newUser) {
        this.user.set(newUser);
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property FAVOURITE_ID;
        public PropertiedObject.Property USER;
    }
}

