/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.gui;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.SaveableChild;
import java.awt.Color;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.font.TextAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import org.apache.commons.collections.list.UnmodifiableList;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Type;

@Entity
@Table(name="config_font_attribute")
@AccessType(value="property")
public class FontAttributes
extends PersistentObject
implements SaveableChild {
    public static final Props Properties = new Props();
    private int pointSize;
    private Color colour;
    private String fontFamily;
    private boolean bold;
    private boolean italic;
    private Map<TextAttribute, Object> attributeMap = new HashMap<TextAttribute, Object>();
    private transient Font cachedFont = null;
    private static List<String> allFonts;
    private static final String DEFAULT_FONT = "SansSerif";
    private static final int DEFAULT_SIZE = 16;

    public FontAttributes() {
        this(16, null, false, false);
    }

    public FontAttributes(int size, Color theColour) {
        this(size, theColour, false, false);
    }

    public FontAttributes(int size, Color theColour, boolean bold, boolean italic) {
        this.setColour(theColour);
        this.setPointSize(size);
        this.setBold(bold);
        this.setItalic(italic);
        this.setFontFamily(DEFAULT_FONT);
    }

    @Column(name="point_size")
    public int getPointSize() {
        return this.pointSize;
    }

    public void setPointSize(int value) {
        this.pointSize = value;
        this.cachedFont = null;
    }

    @Column(name="colour")
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.ColorMapping")
    public Color getColour() {
        return this.colour;
    }

    public void setColour(Color newColour) {
        this.colour = newColour;
        this.cachedFont = null;
    }

    @Column(name="bold")
    public boolean isBold() {
        return this.bold;
    }

    public void setBold(boolean value) {
        this.bold = value;
        this.cachedFont = null;
    }

    @Column(name="italic")
    public boolean isItalic() {
        return this.italic;
    }

    public void setItalic(boolean value) {
        this.italic = value;
        this.cachedFont = null;
    }

    @Column(name="font_family")
    public String getFontFamily() {
        return this.fontFamily;
    }

    public void setFontFamily(String value) {
        this.fontFamily = value;
        this.cachedFont = null;
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void deleteChild() {
        PersistenceManager.deleteChild(this);
    }

    @Override
    public boolean hasChildChanged() {
        return PersistenceManager.hasChildChanged(this);
    }

    @Override
    public void saveChild() {
        PersistenceManager.saveChild(this);
    }

    public Font generateFont() {
        if (this.cachedFont == null) {
            this.attributeMap.put(TextAttribute.FAMILY, this.fontFamily);
            this.attributeMap.put(TextAttribute.FOREGROUND, this.colour);
            this.attributeMap.put(TextAttribute.SIZE, this.pointSize);
            if (this.bold) {
                this.attributeMap.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
            } else {
                this.attributeMap.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_REGULAR);
            }
            if (this.italic) {
                this.attributeMap.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
            } else {
                this.attributeMap.put(TextAttribute.POSTURE, TextAttribute.POSTURE_REGULAR);
            }
            this.cachedFont = Font.getFont(this.attributeMap);
        }
        return this.cachedFont;
    }

    public static List<String> getAvailableFontFamilies() {
        if (allFonts == null) {
            ArrayList<String> families = new ArrayList<String>();
            for (String nextFamily : GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()) {
                families.add(nextFamily);
            }
            allFonts = UnmodifiableList.decorate(families);
        }
        return allFonts;
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property POINT_SIZE;
        public PropertiedObject.Property<Color> COLOUR;
        public PropertiedObject.Property<String> FONT_FAMILY;
        public PropertiedObject.Property BOLD;
        public PropertiedObject.Property ITALIC;
    }
}

