/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.gui;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.SaveableChild;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import ordermate.database.gui.GuiConfigSet;
import org.hibernate.annotations.AccessType;

@Entity
@Table(name="config_gui")
@AccessType(value="property")
public class GuiConfig
extends PersistentObject
implements SaveableChild {
    public static final Props Properties = new Props();
    private String component;
    private String property;
    private String value;
    private Reference<GuiConfigSet> guiConfigSet;

    public GuiConfig() {
        this.guiConfigSet = this.createReference(GuiConfig.Properties.GUI_CONFIG_SET);
    }

    public GuiConfig(String compLabel, String propName, String propValue) {
        this.guiConfigSet = this.createReference(GuiConfig.Properties.GUI_CONFIG_SET);
        this.component = compLabel;
        this.property = propName;
        this.value = propValue;
    }

    public GuiConfig(GuiConfig config) {
        this.guiConfigSet = this.createReference(GuiConfig.Properties.GUI_CONFIG_SET);
        this.component = config.getComponent();
        this.property = config.getProperty();
        this.value = config.getValue();
        this.setGuiConfigSet(config.getGuiConfigSet());
    }

    @Column(name="component")
    public String getComponent() {
        return this.component;
    }

    public void setComponent(String component) {
        this.component = component;
    }

    @Column(name="property")
    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    @Column(name="value")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @JoinColumn(name="fk_config_gui_set")
    @ManyToOne
    public GuiConfigSet getGuiConfigSet() {
        return this.guiConfigSet.get();
    }

    public void setGuiConfigSet(GuiConfigSet guiConfigSet) {
        this.guiConfigSet.set(guiConfigSet);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void saveChild() {
        PersistenceManager.saveChild(this);
    }

    @Override
    public void deleteChild() {
        PersistenceManager.deleteChild(this);
    }

    @Override
    public boolean hasChildChanged() {
        return false;
    }

    public static GuiConfig getGuiConfig(String component, String property) {
        ObjectQuery oQuery = new ObjectQuery();
        oQuery.select(GuiConfig.class).equals(GuiConfig.Properties.COMPONENT, component).equals(GuiConfig.Properties.PROPERTY, property);
        GuiConfig toReturn = PersistenceManager.getObject(GuiConfig.class, oQuery.toString(), null);
        return toReturn;
    }

    public static List<GuiConfig> getGuiConfigs() {
        ObjectQuery oQuery = new ObjectQuery();
        oQuery.select(GuiConfig.class);
        List<GuiConfig> toReturn = PersistenceManager.getObjectList(GuiConfig.class, oQuery.toString());
        return toReturn;
    }

    @Override
    public String toString() {
        return "" + this.component + "_" + this.property + "=" + this.value;
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property COMPONENT;
        public PropertiedObject.Property PROPERTY;
        public PropertiedObject.Property VALUE;
        public PropertiedObject.Property<GuiConfigSet> GUI_CONFIG_SET;
    }
}

