/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.gui;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.SaveableChild;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import ordermate.database.gui.GuiConfig;
import ordermate.database.gui.TerminalTypes;
import ordermate.database.hardware.Terminal;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@Table(name="config_gui_set")
@AccessType(value="property")
public class GuiConfigSet
extends PersistentObject
implements SaveableChild {
    public static final Props Properties = new Props();
    private String label;
    private TerminalTypes terminalType = TerminalTypes.WaiterMate;
    private PersistentWriteableList<Terminal> terminals;
    private PersistentWriteableList<GuiConfig> guiConfigs;

    public GuiConfigSet() {
        this.terminals = (PersistentWriteableList)this.createList(GuiConfigSet.Properties.TERMINALS);
        this.guiConfigs = (PersistentWriteableList)this.createList(GuiConfigSet.Properties.GUI_CONFIGS);
    }

    @Column(name="label")
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @Column(name="terminal_type")
    @Enumerated(value=EnumType.STRING)
    public TerminalTypes getTerminalType() {
        return this.terminalType;
    }

    public void setTerminalType(TerminalTypes terminalType) {
        if (terminalType != null) {
            this.terminalType = terminalType;
        }
    }

    @OneToMany(mappedBy="screenLayoutSet", targetEntity=Terminal.class, fetch=FetchType.LAZY)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public List<Terminal> getTerminals() {
        return this.terminals.getUnmodifiable();
    }

    void setTerminals(List<Terminal> terms) {
        this.terminals = this.terminals.clone();
        this.terminals.set(terms);
    }

    @OneToMany(mappedBy="guiConfigSet", targetEntity=GuiConfig.class, fetch=FetchType.LAZY)
    public List<GuiConfig> getGuiConfigs() {
        return this.guiConfigs != null ? this.guiConfigs.getUnmodifiable() : Collections.emptyList();
    }

    public void setGuiConfigs(List<GuiConfig> configs) {
        this.guiConfigs = this.guiConfigs.clone();
        this.guiConfigs.set(configs);
    }

    public GuiConfig getGuiConfig(String comp, String prop) {
        for (GuiConfig toCheck : this.guiConfigs) {
            if (!toCheck.getComponent().equalsIgnoreCase(comp) || !toCheck.getProperty().equalsIgnoreCase(prop)) continue;
            return toCheck;
        }
        return null;
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void saveChild() {
        PersistenceManager.saveChild(this);
        this.guiConfigs.saveChild();
    }

    @Override
    public void deleteChild() {
        PersistenceManager.deleteChild(this);
        for (GuiConfig fig : this.guiConfigs) {
            fig.deleteChild();
        }
    }

    @Override
    public boolean hasChildChanged() {
        return false;
    }

    public static GuiConfigSet getDefaultSet(TerminalTypes terminalType) {
        List<GuiConfigSet> allTypes = GuiConfigSet.getAllSets(terminalType);
        if (allTypes.size() < 1) {
            return null;
        }
        return allTypes.get(0);
    }

    public static List<GuiConfigSet> getAllSets(TerminalTypes terminalType) {
        ObjectQuery oQuery = new ObjectQuery();
        oQuery.select(GuiConfigSet.class).equals(GuiConfigSet.Properties.TERMINAL_TYPE, (Object)terminalType);
        List<GuiConfigSet> allTypes = PersistenceManager.getObjectList(GuiConfigSet.class, oQuery.toString(), null);
        Collections.sort(allTypes, new Comparator<GuiConfigSet>(){

            @Override
            public int compare(GuiConfigSet o1, GuiConfigSet o2) {
                return o1.getID().compareTo(o2.getID());
            }
        });
        return allTypes;
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property LABEL;
        public PropertiedObject.Property<TerminalTypes> TERMINAL_TYPE;
        public PropertiedObject.Property<Terminal> TERMINALS;
        public PropertiedObject.Property<GuiConfig> GUI_CONFIGS;
    }
}

