/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.gui.configmanager;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.persistence.PersistenceManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import ordermate.database.gui.GuiConfig;
import ordermate.database.gui.GuiConfigSet;
import ordermate.database.gui.GuiConfigSummary;
import ordermate.database.gui.TerminalTypes;
import ordermate.database.gui.configmanager.ComponentKey;
import ordermate.database.gui.configmanager.CourseComponentKey;
import ordermate.database.misc.Course;
import org.apache.commons.collections.map.MultiKeyMap;

public abstract class GuiConfigManager {
    private static final MultiKeyMap defaultValues = new MultiKeyMap();
    private List<GuiConfig> givenConfigs = new ArrayList<GuiConfig>();
    private List<GuiConfigSummary> summaries = new ArrayList<GuiConfigSummary>();

    public List<GuiConfig> buildGuiConfigList(List<GuiConfigSummary> toSet) {
        this.setGuiConfigSummaryList(toSet);
        this.buildGuiConfigs();
        return this.getGuiConfigList();
    }

    public List<GuiConfigSummary> buildGuiConfigSummaryList(List<GuiConfig> toSet) {
        this.setGuiConfigList(toSet);
        this.buildSummaries();
        return this.getGuiConfigSummaryList();
    }

    private void buildGuiConfigs() {
        ArrayList<GuiConfig> allNewConfigs = new ArrayList<GuiConfig>();
        for (GuiConfigSummary summary : this.summaries) {
            allNewConfigs.addAll(this.buildEachProperty(summary));
        }
        this.setGuiConfigList(allNewConfigs);
    }

    private void buildSummaries() {
        ArrayList<GuiConfigSummary> newSummaries = new ArrayList<GuiConfigSummary>();
        for (ComponentKey component : this.getComponents()) {
            GuiConfigSummary summary = new GuiConfigSummary();
            summary.setComponent(component);
            this.setDefaultValues(summary);
            this.setProperties(summary);
            newSummaries.add(summary);
        }
        this.setGuiConfigSummaryList(newSummaries);
    }

    private void setDefaultValues(GuiConfigSummary summary) {
        for (PropStrings prop : PropStrings.values()) {
            Integer defVal = GuiConfigManager.getDefaultValue(summary.getComponent().getDefaultValueKey(), prop);
            if (defVal == null) continue;
            if (prop.equals((Object)PropStrings.ROWS)) {
                summary.setRows(defVal);
                continue;
            }
            if (!prop.equals((Object)PropStrings.COLUMNS)) continue;
            summary.setColumns(defVal);
        }
    }

    public static Integer getDefaultValue(String defaultKey, PropStrings prop) {
        return (Integer)defaultValues.get((Object)defaultKey, (Object)prop);
    }

    private List<GuiConfig> buildEachProperty(GuiConfigSummary summaryToBuild) {
        ArrayList<GuiConfig> newConfigs = new ArrayList<GuiConfig>();
        if (summaryToBuild.getRowConfig() != null) {
            newConfigs.add(summaryToBuild.getRowConfig());
        } else if (summaryToBuild.getRows() != null) {
            newConfigs.add(new GuiConfig(summaryToBuild.getComponent().getKey(), PropStrings.ROWS.toString(), summaryToBuild.getRows().toString()));
        }
        if (summaryToBuild.getColumnConfig() != null) {
            newConfigs.add(summaryToBuild.getColumnConfig());
        } else if (summaryToBuild.getColumns() != null) {
            newConfigs.add(new GuiConfig(summaryToBuild.getComponent().getKey(), PropStrings.COLUMNS.toString(), summaryToBuild.getColumns().toString()));
        }
        return newConfigs;
    }

    private void setProperties(GuiConfigSummary summary) {
        ArrayList<GuiConfig> componentConfigs = new ArrayList<GuiConfig>();
        for (GuiConfig guiConfig : this.givenConfigs) {
            if (!guiConfig.getComponent().equalsIgnoreCase(summary.getComponent().getKey())) continue;
            componentConfigs.add(guiConfig);
        }
        for (GuiConfig compConfig : componentConfigs) {
            if (compConfig.getProperty().equalsIgnoreCase(PropStrings.ROWS.toString())) {
                summary.setRowConfig(compConfig);
                continue;
            }
            if (!compConfig.getProperty().equalsIgnoreCase(PropStrings.COLUMNS.toString())) continue;
            summary.setColumnConfig(compConfig);
        }
    }

    protected abstract Set<ComponentKey> getComponents();

    public List<GuiConfigSummary> getGuiConfigSummaryList() {
        return this.summaries;
    }

    public List<GuiConfig> getGuiConfigList() {
        return this.givenConfigs;
    }

    public void setGuiConfigSummaryList(List<GuiConfigSummary> newList) {
        this.summaries = newList;
    }

    public void setGuiConfigList(List<GuiConfig> toSet) {
        this.givenConfigs = toSet;
    }

    public static void renameCourseGuiConfigs(Course updatedCourse) {
        CompStrings[] courseComponentStrings;
        Course oldCourse = (Course)PersistenceManager.reacquire(updatedCourse);
        if (oldCourse == null) {
            return;
        }
        String oldName = oldCourse.getName();
        String newName = updatedCourse.getName();
        for (CompStrings courseComp : courseComponentStrings = new CompStrings[]{CompStrings.ORDERED_ITEMS_COURSE, CompStrings.SPLIT_ITEMS_COURSE}) {
            String toQuery = String.format(courseComp.toString(), oldName);
            String toReplaceWith = String.format(courseComp.toString(), newName);
            List<GuiConfig> courseConfigs = PersistenceManager.getObjectList(GuiConfig.class, new ObjectQuery().select(GuiConfig.class).equals(GuiConfig.Properties.COMPONENT, toQuery).toString(), null);
            for (GuiConfig figs : courseConfigs) {
                figs.setComponent(toReplaceWith);
                figs.saveChild();
            }
        }
    }

    public static Course addCourseGuiConfigs(Course newCourse) {
        for (GuiConfigSet set : GuiConfigSet.getAllSets(TerminalTypes.WaiterMate)) {
            ArrayList<GuiConfig> existingGuiConfigs = new ArrayList<GuiConfig>(set.getGuiConfigs());
            for (CompStrings compStr : Arrays.asList(CompStrings.ORDERED_ITEMS_COURSE, CompStrings.SPLIT_ITEMS_COURSE)) {
                CourseComponentKey newCourseCompKey = new CourseComponentKey(newCourse.getName(), compStr.displayable(), compStr.toString());
                for (PropStrings prop : PropStrings.values()) {
                    existingGuiConfigs.add(new GuiConfig(newCourseCompKey.getKey(), prop.toString(), GuiConfigManager.getDefaultValue(newCourseCompKey.getDefaultValueKey(), prop).toString()));
                }
            }
            set.setGuiConfigs(existingGuiConfigs);
            set.saveChild();
        }
        newCourse.save();
        return newCourse;
    }

    public static Course deleteCourseGuiConfigs(Course deletedObject) {
        CompStrings[] courseComponentStrings;
        for (CompStrings courseComp : courseComponentStrings = new CompStrings[]{CompStrings.ORDERED_ITEMS_COURSE, CompStrings.SPLIT_ITEMS_COURSE}) {
            String toQuery = String.format(courseComp.toString(), deletedObject.getName());
            List<GuiConfig> courseConfigs = PersistenceManager.getObjectList(GuiConfig.class, new ObjectQuery().select(GuiConfig.class).equals(GuiConfig.Properties.COMPONENT, toQuery).toString(), null);
            for (GuiConfig figs : courseConfigs) {
                figs.deleteChild();
            }
        }
        return deletedObject;
    }

    public static int getIntegerProperty(GuiConfigSet set, CompStrings compStr, PropStrings propStr) {
        int toReturn = 0;
        if (set == null) {
            return toReturn;
        }
        GuiConfig config = set.getGuiConfig(compStr.toString(), propStr.toString());
        if (config != null) {
            toReturn = Integer.parseInt(config.getValue());
        }
        return toReturn;
    }

    static {
        defaultValues.put((Object)CompStrings.MENU_SECTIONS.toString(), (Object)PropStrings.ROWS, (Object)new Integer(10));
        defaultValues.put((Object)CompStrings.MENU_SECTIONS.toString(), (Object)PropStrings.COLUMNS, (Object)new Integer(1));
        defaultValues.put((Object)CompStrings.MENU_ITEMS.toString(), (Object)PropStrings.ROWS, (Object)new Integer(5));
        defaultValues.put((Object)CompStrings.MENU_ITEMS.toString(), (Object)PropStrings.COLUMNS, (Object)new Integer(3));
        defaultValues.put((Object)CompStrings.ITEM_OPTIONS.toString(), (Object)PropStrings.ROWS, (Object)new Integer(5));
        defaultValues.put((Object)CompStrings.ITEM_OPTIONS.toString(), (Object)PropStrings.COLUMNS, (Object)new Integer(3));
        defaultValues.put((Object)CompStrings.ITEM_PLUSSES.toString(), (Object)PropStrings.ROWS, (Object)new Integer(5));
        defaultValues.put((Object)CompStrings.ITEM_PLUSSES.toString(), (Object)PropStrings.COLUMNS, (Object)new Integer(4));
        defaultValues.put((Object)CompStrings.ITEM_MINUSES.toString(), (Object)PropStrings.ROWS, (Object)new Integer(5));
        defaultValues.put((Object)CompStrings.ITEM_MINUSES.toString(), (Object)PropStrings.COLUMNS, (Object)new Integer(3));
        defaultValues.put((Object)CompStrings.ITEM_PORTIONS.toString(), (Object)PropStrings.ROWS, (Object)new Integer(2));
        defaultValues.put((Object)CompStrings.ITEM_PORTIONS.toString(), (Object)PropStrings.COLUMNS, (Object)new Integer(3));
        defaultValues.put((Object)CompStrings.ITEM_SIZES.toString(), (Object)PropStrings.ROWS, (Object)new Integer(2));
        defaultValues.put((Object)CompStrings.ITEM_SIZES.toString(), (Object)PropStrings.COLUMNS, (Object)new Integer(3));
        defaultValues.put((Object)CompStrings.ORDERED_ITEMS_QUICKSALE.toString(), (Object)PropStrings.ROWS, (Object)new Integer(6));
        defaultValues.put((Object)CompStrings.ORDERED_ITEMS_QUICKSALE.toString(), (Object)PropStrings.COLUMNS, (Object)new Integer(1));
        defaultValues.put((Object)CompStrings.ORDERED_ITEMS_COURSE.toString(), (Object)PropStrings.ROWS, (Object)new Integer(5));
        defaultValues.put((Object)CompStrings.ORDERED_ITEMS_COURSE.toString(), (Object)PropStrings.COLUMNS, (Object)new Integer(1));
        defaultValues.put((Object)CompStrings.SPLIT_ITEMS_COURSE.toString(), (Object)PropStrings.ROWS, (Object)new Integer(5));
        defaultValues.put((Object)CompStrings.SPLIT_ITEMS_COURSE.toString(), (Object)PropStrings.COLUMNS, (Object)new Integer(3));
        defaultValues.put((Object)CompStrings.DEBTORS.toString(), (Object)PropStrings.ROWS, (Object)new Integer(6));
        defaultValues.put((Object)CompStrings.DEBTORS.toString(), (Object)PropStrings.COLUMNS, (Object)new Integer(3));
        defaultValues.put((Object)CompStrings.DEBTOR_TRANSACTIONS.toString(), (Object)PropStrings.ROWS, (Object)new Integer(8));
        defaultValues.put((Object)CompStrings.DEBTOR_TRANSACTIONS.toString(), (Object)PropStrings.COLUMNS, (Object)new Integer(1));
        defaultValues.put((Object)CompStrings.SELECT_COMBO_ITEMS.toString(), (Object)PropStrings.ROWS, (Object)new Integer(4));
        defaultValues.put((Object)CompStrings.SELECT_COMBO_ITEMS.toString(), (Object)PropStrings.COLUMNS, (Object)new Integer(4));
        defaultValues.put((Object)CompStrings.SELECT_BAR_TAB.toString(), (Object)PropStrings.ROWS, (Object)new Integer(5));
        defaultValues.put((Object)CompStrings.SELECT_BAR_TAB.toString(), (Object)PropStrings.COLUMNS, (Object)new Integer(3));
        defaultValues.put((Object)CompStrings.PM_TABLE.toString(), (Object)PropStrings.ROWS, (Object)new Integer(7));
        defaultValues.put((Object)CompStrings.PM_TABLE.toString(), (Object)PropStrings.COLUMNS, (Object)new Integer(2));
        defaultValues.put((Object)CompStrings.PM_MENU_ITEMS.toString(), (Object)PropStrings.ROWS, (Object)new Integer(6));
        defaultValues.put((Object)CompStrings.PM_MENU_ITEMS.toString(), (Object)PropStrings.COLUMNS, (Object)new Integer(3));
        defaultValues.put((Object)CompStrings.PM_ITEM_MODS.toString(), (Object)PropStrings.ROWS, (Object)new Integer(6));
        defaultValues.put((Object)CompStrings.PM_ITEM_MODS.toString(), (Object)PropStrings.COLUMNS, (Object)new Integer(3));
        defaultValues.put((Object)CompStrings.PM_PLUS_MINUS.toString(), (Object)PropStrings.ROWS, (Object)new Integer(6));
        defaultValues.put((Object)CompStrings.PM_PLUS_MINUS.toString(), (Object)PropStrings.COLUMNS, (Object)new Integer(3));
        defaultValues.put((Object)CompStrings.PM_OPTIONS.toString(), (Object)PropStrings.ROWS, (Object)new Integer(6));
        defaultValues.put((Object)CompStrings.PM_OPTIONS.toString(), (Object)PropStrings.COLUMNS, (Object)new Integer(3));
        defaultValues.put((Object)CompStrings.PM_ITEMS.toString(), (Object)PropStrings.ROWS, (Object)new Integer(5));
        defaultValues.put((Object)CompStrings.PM_ITEMS.toString(), (Object)PropStrings.COLUMNS, (Object)new Integer(1));
        defaultValues.put((Object)CompStrings.PM_SELECT_COMBO_ITEMS.toString(), (Object)PropStrings.ROWS, (Object)new Integer(5));
        defaultValues.put((Object)CompStrings.PM_SELECT_COMBO_ITEMS.toString(), (Object)PropStrings.COLUMNS, (Object)new Integer(3));
    }

    public static enum PropStrings {
        ROWS("rowsPerPage"),
        COLUMNS("columns");

        private final String name;

        private PropStrings(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum CompStrings {
        MENU_SECTIONS("menuGroups", "Menu Sections"),
        MENU_ITEMS("ItemScreen", "Menu Items"),
        ITEM_OPTIONS("itemOptions", "Item Options"),
        ITEM_PLUSSES("pluses", "Item Plusses"),
        ITEM_MINUSES("minuses", "Item Minuses"),
        ITEM_PORTIONS("portions", "Item Portions"),
        ITEM_SIZES("sizes", "Item Sizes"),
        ORDERED_ITEMS_QUICKSALE("fastBarItemsPane", "Ordered Items (Quicksale)"),
        ORDERED_ITEMS_COURSE("%scourse", "Ordered Items (%s Course)"),
        SPLIT_ITEMS_COURSE("Split%scourse", "Split Items (%s Course)"),
        ORDERED_ITEMS_FIRST_COURSE("Firstcourse", "Ordered Items (First Course)"),
        ORDERED_ITEMS_SECOND_COURSE("Secondcourse", "Ordered Items (Second Course)"),
        ORDERED_ITEMS_THIRD_COURSE("Thirdcourse", "Ordered Items (Third Course)"),
        SPLIT_ITEMS_FIRST_COURSE("SplitFirstcourse", "Split Items (First Course)"),
        SPLIT_ITEMS_SECOND_COURSE("SplitSecondcourse", "Split Items (Second Course)"),
        SPLIT_ITEMS_THIRD_COURSE("SplitThirdcourse", "Split Items (Third Course)"),
        SELECT_BAR_TAB("BarTabScrollPane", "Bar Tab Selection"),
        DEBTORS("debtorSelect", "Debtors"),
        DEBTOR_TRANSACTIONS("debtorTran", "Debtor Transactions"),
        SELECT_COMBO_ITEMS("selectComboItems", "Select Combo Items"),
        PM_TABLE("pmTable", "Tables"),
        PM_MENU_ITEMS("pmMenuItems", "Menu Items"),
        PM_ITEM_MODS("pmItemMods", "Item Modifications"),
        PM_PLUS_MINUS("pmPlusMinus", "Plus/Minus"),
        PM_OPTIONS("pmOptions", "Options"),
        PM_ITEMS("pmOrderedItems", "Items Ordered"),
        PM_SELECT_COMBO_ITEMS("pmSelectComboItems", "Select Combo Items");

        private final String name;
        private final String display;

        private CompStrings(String name, String displayable) {
            this.name = name;
            this.display = displayable;
        }

        public String toString() {
            return this.name;
        }

        public String displayable() {
            return this.display;
        }
    }
}

