/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.hardware;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import java.util.Iterator;
import java.util.List;
import ordermate.database.Sequenced;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.hardware.Terminal;
import ordermate.database.inventory.triggers.AbstractTrigger;
import ordermate.database.inventory.triggers.TriggerLink;
import ordermate.database.inventory.triggers.activation.TriggerActivated;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.inventory.triggers.activation.TriggerActivationStrategy;

public class OnlineTerminalMap
extends PersistentObject
implements Saveable,
TriggerActivated {
    public static final Props Properties = new Props();
    private String mapName = "";
    private int sequence;
    private TriggerActivationStrategy triggerActivationStrategy = TriggerActivationStrategy.ANY_TRIGGERS;
    private PersistentWriteableList<AbstractTrigger> triggers;
    private Reference<Terminal> terminal;
    private SystemState systemState;

    public OnlineTerminalMap() {
        this.triggers = (PersistentWriteableList)this.createList(OnlineTerminalMap.Properties.TRIGGERS);
        this.terminal = this.createReference(OnlineTerminalMap.Properties.TERMINAL);
        this.systemState = SystemState.ACTIVE_STATE;
        this.systemState = SystemState.ACTIVE_STATE;
        this.sequence = 1;
    }

    public Terminal getTerminal() {
        return this.terminal.get();
    }

    public void setTerminal(Terminal newTerminal) {
        this.terminal.set(newTerminal);
    }

    public static OnlineTerminalMap findTemplate(String name) {
        ObjectQuery query = Query.select(OnlineTerminalMap.class).active(OnlineTerminalMap.class).equalsParam(OnlineTerminalMap.Properties.MAP_NAME);
        return PersistenceManager.getObject(OnlineTerminalMap.class, query.toString(), new Object[]{name});
    }

    public String getMapName() {
        return this.mapName;
    }

    public void setMapName(String name) {
        this.mapName = name;
    }

    @Override
    public void setTriggerActivationStrategy(TriggerActivationStrategy triggerActivation) {
        this.triggerActivationStrategy = triggerActivation;
    }

    @Override
    public List<AbstractTrigger> getTriggers() {
        return this.triggers.getUnmodifiable();
    }

    @Override
    public TriggerLink addTrigger(AbstractTrigger toAdd) {
        this.triggers.add(toAdd);
        return null;
    }

    public void setTriggers(List<AbstractTrigger> triggersToSet) {
        this.triggers.clear();
        Iterator<AbstractTrigger> trigIt = triggersToSet.iterator();
        while (trigIt.hasNext()) {
            this.addTrigger(trigIt.next());
        }
    }

    @Override
    public boolean removeTrigger(AbstractTrigger toRemove) {
        if (!this.triggers.remove(toRemove)) {
            throw new IllegalArgumentException(toRemove + " is not linked with the docket template " + this.getMapName());
        }
        return true;
    }

    public void removeAllTriggers() {
        this.triggers.clear();
    }

    @Override
    public int getSequence() {
        return this.sequence;
    }

    public void setSequence(int newsequence) {
        this.sequence = newsequence;
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
        this.triggers.saveChild();
    }

    @Override
    public void delete() {
        this.systemState = SystemState.DELETED_STATE;
        this.triggers.deleteChild();
        this.save();
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public String toString() {
        return this.getMapName();
    }

    @Override
    public TriggerActivationStrategy getTriggerActivationStrategy() {
        return this.triggerActivationStrategy;
    }

    @Override
    public boolean isActive(TriggerActivationContext context) {
        return this.triggerActivationStrategy.isActive(this, context);
    }

    public int compareTo(Object arg0) {
        return Sequenced.SequenceComparator.getInst().compare(this, arg0);
    }

    public SystemState getSystemState() {
        return this.systemState;
    }

    public void setSystemState(SystemState newState) {
        this.systemState = newState;
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property MAP_NAME;
        public PropertiedObject.Property SEQUENCE;
        public PropertiedObject.Property TRIGGER_ACTIVATION_STRATEGY;
        public PropertiedObject.Property<AbstractTrigger> TRIGGERS;
        public PropertiedObject.Property<Terminal> TERMINAL;
        public PropertiedObject.Property<SystemState> SYSTEM_STATE;
    }
}

