/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.hardware;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.VirtualPrinter;

@Entity
@Table(name="config_payoff_printer")
public class PayoffPrinter
extends PersistentObject
implements Saveable {
    public static final Props Properties = new Props();
    private Reference<Terminal> terminal;
    private Reference<VirtualPrinter> virtualPrinter;
    private String docketLocation;
    private String unitType;

    public PayoffPrinter() {
        this.terminal = this.createReference(PayoffPrinter.Properties.TERMINAL);
        this.virtualPrinter = this.createReference(PayoffPrinter.Properties.VIRTUAL_PRINTER);
        this.unitType = "ALL";
    }

    @ManyToOne
    @JoinColumn(name="FK_config_terminal")
    public Terminal getTerminal() {
        return this.terminal.get();
    }

    public void setTerminal(Terminal newTerminal) {
        this.terminal.set(newTerminal);
    }

    @ManyToOne
    @JoinColumn(name="FK_config_printer_virtual")
    public VirtualPrinter getVirtualPrinter() {
        return this.virtualPrinter.get();
    }

    public void setVirtualPrinter(VirtualPrinter newVirtualPrinter) {
        this.virtualPrinter.set(newVirtualPrinter);
    }

    @Column(name="payoff_docket_location")
    public String getDocketLocation() {
        return this.docketLocation;
    }

    public void setDocketLocation(String docketLocation) {
        this.docketLocation = docketLocation;
    }

    @Column(name="unit_type")
    public String getUnitType() {
        return this.unitType;
    }

    public void setUnitType(String unitType) {
        this.unitType = unitType;
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
    }

    @Override
    public void delete() {
        PersistenceManager.delete(this);
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<Terminal> TERMINAL;
        public PropertiedObject.Property<VirtualPrinter> VIRTUAL_PRINTER;
        public PropertiedObject.Property<String> DOCKET_LOCATION;
        public PropertiedObject.Property<String> UNIT_TYPE;
    }
}

