/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.hardware;

import au.com.ordermate.persistence.Auditable;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import ordermate.database.hardware.PrinterGroup;
import ordermate.database.hardware.TerminalLocation;
import ordermate.database.hardware.VirtualPrinter;
import ordermate.database.sales.AccountType;

@Entity
@Table(name="config_printer_location")
public class PrinterLocation
extends PersistentObject
implements Saveable,
Auditable {
    public static final Props Properties = new Props();
    private Reference<PrinterGroup> printerGroup;
    private Reference<TerminalLocation> terminalLocation;
    private Reference<VirtualPrinter> virtualPrinter;
    private String accountType;

    public PrinterLocation() {
        this.printerGroup = this.createReference(PrinterLocation.Properties.PRINTER_GROUP);
        this.terminalLocation = this.createReference(PrinterLocation.Properties.TERMINAL_LOCATION);
        this.virtualPrinter = this.createReference(PrinterLocation.Properties.VIRTUAL_PRINTER);
        this.accountType = AccountType.allType.getType();
    }

    @Override
    @Transient
    public String getLogDetail() {
        StringBuilder sb = new StringBuilder();
        sb.append("PrinterGroup(").append(this.getPrinterGroup()).append("),").append("virtualPrinter(").append(this.getVirtualPrinter()).append("),").append("AccountType(").append(this.getAccountType()).append("),").append("TerminalLocation(").append(this.getTerminalLocation()).append(")");
        return sb.toString();
    }

    @ManyToOne
    @JoinColumn(name="FK_config_printer_group")
    public PrinterGroup getPrinterGroup() {
        return this.printerGroup.get();
    }

    public void setPrinterGroup(PrinterGroup newPrinterGroup) {
        this.printerGroup.set(newPrinterGroup);
    }

    @ManyToOne
    @JoinColumn(name="FK_config_terminal_location")
    public TerminalLocation getTerminalLocation() {
        return this.terminalLocation.get();
    }

    public void setTerminalLocation(TerminalLocation newTerminalLocation) {
        this.terminalLocation.set(newTerminalLocation);
    }

    @ManyToOne
    @JoinColumn(name="FK_config_printer_virtual")
    public VirtualPrinter getVirtualPrinter() {
        return this.virtualPrinter.get();
    }

    public void setVirtualPrinter(VirtualPrinter newVirtualPrinter) {
        this.virtualPrinter.set(newVirtualPrinter);
    }

    @Column(name="account_type")
    public String getAccountType() {
        return this.accountType;
    }

    @Override
    public String toString() {
        StringBuilder SB = new StringBuilder("Printer Location:");
        SB.append(this.getAccountType()).append(" for ").append(this.getVirtualPrinter());
        return SB.toString();
    }

    public void setAccountType(String accountType) {
        this.accountType = accountType;
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
    }

    @Override
    public void delete() {
        PersistenceManager.delete(this);
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Override
    @Transient
    public String getAuditName() {
        return "Printer Location";
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<PrinterGroup> PRINTER_GROUP;
        public PropertiedObject.Property<TerminalLocation> TERMINAL_LOCATION;
        public PropertiedObject.Property<VirtualPrinter> VIRTUAL_PRINTER;
        public PropertiedObject.Property<String> ACCOUNT_TYPE;
    }
}

