/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.hardware;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import ordermate.database.hardware.VirtualPrinter;

@Entity
@Table(name="config_printer_summary")
public class PrinterSummary
extends PersistentObject
implements Saveable {
    public static final Props Properties = new Props();
    private Reference<VirtualPrinter> virtualPrinter;
    private String accountType;

    public PrinterSummary() {
        this.virtualPrinter = this.createReference(PrinterSummary.Properties.VIRTUAL_PRINTER);
    }

    public static List<PrinterSummary> getAllPrinterSummaries() {
        String sql = Query.select(PrinterSummary.class).orderBy(PrinterSummary.Properties.ID).toString();
        List<PrinterSummary> sums = PersistenceManager.getObjectList(PrinterSummary.class, sql, null);
        return sums;
    }

    @Column(name="account_type")
    public String getAccountType() {
        return this.accountType;
    }

    public void setAccountType(String newAccType) {
        this.accountType = newAccType;
    }

    @ManyToOne
    @JoinColumn(name="FK_config_printer_virtual")
    public VirtualPrinter getVirtualPrinter() {
        return this.virtualPrinter.get();
    }

    public void setVirtualPrinter(VirtualPrinter newVirtualPrinter) {
        this.virtualPrinter.set(newVirtualPrinter);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public String toString() {
        return this.getAccountType() == null ? "No Account" : this.getAccountType();
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
    }

    @Override
    public void delete() {
        PersistenceManager.delete(this);
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<VirtualPrinter> VIRTUAL_PRINTER;
        public PropertiedObject.Property<String> ACCOUNT_TYPE;
    }
}

