/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.hardware;

import ordermate.database.hardware.Terminal;

public enum QuickSaleButtonId {
    ShowOrder,
    PrintOrder{

        @Override
        public boolean isEnabled(Terminal term) {
            return term.getManuallyPrintPrep();
        }
    }
    ,
    Pay(true),
    fastCash(true),
    ticketData{

        @Override
        public boolean isEnabled(Terminal terminal) {
            return terminal.ticketDataRequired();
        }
    }
    ,
    discount{

        @Override
        public boolean isEnabled(Terminal terminal) {
            return terminal.getQuickDiscount();
        }
    }
    ,
    tabDebtor(true){

        @Override
        public boolean isEnabled(Terminal terminal) {
            return terminal.getPayTabDebtor() && (terminal.hasBarTabsMode() || terminal.hasDebtorsMode());
        }
    }
    ,
    SetCustomer{

        @Override
        public boolean isEnabled(Terminal terminal) {
            return terminal.getQuickCustomer();
        }
    }
    ,
    cashdrawer(true),
    findItem,
    previousSales{

        @Override
        public boolean isEnabled(Terminal terminal) {
            return terminal.isPreviousSalesQuickSale();
        }
    }
    ,
    makeCombo,
    printReceipt,
    configButton,
    adminButton,
    logoutButton,
    quickTransfer{

        @Override
        public boolean isEnabled(Terminal terminal) {
            return terminal.isQuickSaleQuickTransfer() && terminal.hasQuickSale() && (terminal.hasTableMode() || terminal.hasTakeawayMode() || terminal.hasPhoneMode());
        }
    }
    ,
    eftposPay(true),
    visaPay(true),
    mastercardPay(true),
    amexPay(true),
    dinersPay(true),
    quickEftpos(true),
    payPal,
    voucherPay,
    payToCard,
    priceLevel,
    loyalty,
    customerMessage,
    dineInSaleBtn,
    takeawaySaleBtn,
    specificPriceLevel,
    quickDebtorPayment,
    purchaseVoucher(true);

    private final boolean cashDrawerRequired;

    private QuickSaleButtonId() {
        this(false);
    }

    private QuickSaleButtonId(boolean mustHaveCashdrawer) {
        this.cashDrawerRequired = mustHaveCashdrawer;
    }

    public boolean isEnabled(Terminal term) {
        return true;
    }

    public boolean isCashdrawerRequired() {
        return this.cashDrawerRequired;
    }
}

