/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.hardware;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentDisplayableObject;
import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import ordermate.database.hardware.ButtonWidth;
import ordermate.database.hardware.QuickSaleButtonId;
import ordermate.database.hardware.QuickSaleNavInfo;
import ordermate.database.hardware.Terminal;
import ordermate.database.inventory.PriceLevel;
import ordermate.database.misc.license.LicenseType;
import ordermate.database.misc.license.PersistentLicenseManager;

@Entity
@Table(name="config_gui_quicksale_nav")
public class QuickSaleNavConfig
extends PersistentDisplayableObject
implements Saveable {
    public static final Props Properties = new Props();
    private int rowsPerPage = 1;
    private int numColumns = 8;
    private int numPages = 2;
    private ButtonWidth buttonWidth = ButtonWidth.NORMAL;
    private PersistentWriteableList<Terminal> terminals;
    private PersistentWriteableList<QuickSaleNavInfo> navButtons;

    public QuickSaleNavConfig() {
        this.terminals = this.createWriteableList(QuickSaleNavConfig.Properties.TERMINALS);
        this.navButtons = this.createWriteableList(QuickSaleNavConfig.Properties.NAV_BUTTONS);
    }

    @Column(name="button_width")
    @Enumerated(value=EnumType.STRING)
    public ButtonWidth getButtonWidth() {
        return this.buttonWidth;
    }

    public void setButtonWidth(ButtonWidth buttonWidth) {
        this.buttonWidth = buttonWidth;
    }

    @Column(name="rows_per_page")
    public int getRowsPerPage() {
        return this.rowsPerPage;
    }

    public void setRowsPerPage(int rows) {
        if (rows < 1 || rows > 2) {
            throw new IllegalArgumentException("Invalid num of rows, can only have 1 to 2 rows");
        }
        this.rowsPerPage = rows;
    }

    @Column(name="num_pages")
    public int getNumPages() {
        return this.numPages;
    }

    public void setNumPages(int pages) {
        if (pages < 1 || pages > 3) {
            throw new IllegalArgumentException("Invalid num of pages, can only have 1 to 3 pages");
        }
        this.numPages = pages;
    }

    public void addTerminal(Terminal term) {
        if (!this.terminals.contains(term)) {
            this.terminals.add(term);
        }
    }

    public void removeTerminal(Terminal term) {
        this.terminals.remove(term);
    }

    @OneToMany(mappedBy="quickSaleNavConfig", targetEntity=Terminal.class)
    public List<Terminal> getTerminals() {
        return this.terminals.getUnmodifiable();
    }

    protected void setTerminals(List<Terminal> values) {
        this.terminals = this.terminals.clone();
        this.terminals.set(values);
    }

    @OneToMany(mappedBy="config", targetEntity=QuickSaleNavInfo.class)
    public List<QuickSaleNavInfo> getNavButtons() {
        return this.navButtons.getUnmodifiable();
    }

    protected void setNavButtons(List<QuickSaleNavInfo> value) {
        this.navButtons = this.navButtons.clone();
        this.navButtons.set(value);
    }

    protected void addNavButton(QuickSaleNavInfo button) {
        this.navButtons.add(button);
    }

    protected void remoteNavButton(QuickSaleNavInfo button) {
        this.navButtons.remove(button);
    }

    @Column(name="num_columns")
    public int getNumColumns() {
        return this.numColumns;
    }

    public void setNumColumns(int cols) {
        this.numColumns = cols;
    }

    public static QuickSaleNavConfig create() {
        QuickSaleNavConfig config = new QuickSaleNavConfig();
        config.addNavButton(new QuickSaleNavInfo("Show Order", QuickSaleButtonId.ShowOrder, 1, 2));
        config.addNavButton(new QuickSaleNavInfo("Print Order", QuickSaleButtonId.PrintOrder, 1, 1));
        config.addNavButton(new QuickSaleNavInfo("Quick Pay", QuickSaleButtonId.fastCash, 1, 3));
        config.addNavButton(new QuickSaleNavInfo("Pay", QuickSaleButtonId.Pay, 1, 4));
        config.addNavButton(new QuickSaleNavInfo("Order Info", QuickSaleButtonId.ticketData, 1, 5));
        config.addNavButton(new QuickSaleNavInfo("Discount", QuickSaleButtonId.discount, 1, 8));
        config.addNavButton(new QuickSaleNavInfo("Tab/Debtor", QuickSaleButtonId.tabDebtor, 1, 6));
        config.addNavButton(new QuickSaleNavInfo("Set Customer", QuickSaleButtonId.SetCustomer, 1, 9));
        config.addNavButton(new QuickSaleNavInfo("No Sale", QuickSaleButtonId.cashdrawer, 1, 7));
        config.addNavButton(new QuickSaleNavInfo("Find Item", QuickSaleButtonId.findItem, 2, 0));
        config.addNavButton(new QuickSaleNavInfo("Previous Sales", QuickSaleButtonId.previousSales, 2, 0));
        config.addNavButton(new QuickSaleNavInfo("Make Combo", QuickSaleButtonId.makeCombo, 2, 0));
        config.addNavButton(new QuickSaleNavInfo("Print Last", QuickSaleButtonId.printReceipt, 2, 1));
        config.addNavButton(new QuickSaleNavInfo("Account Admin", QuickSaleButtonId.configButton, 2, 2));
        config.addNavButton(new QuickSaleNavInfo("System Admin", QuickSaleButtonId.adminButton, 2, 3));
        config.addNavButton(new QuickSaleNavInfo("Logout", QuickSaleButtonId.logoutButton, 2, 4));
        config.addNavButton(new QuickSaleNavInfo("Quick Transfer", QuickSaleButtonId.quickTransfer, 2, 5));
        config.addNavButton(new QuickSaleNavInfo("Purchase Voucher", QuickSaleButtonId.purchaseVoucher, 2, 6));
        config.addNavButton(new QuickSaleNavInfo("Pay To Card", QuickSaleButtonId.payToCard, 1, 0));
        config.addNavButton(new QuickSaleNavInfo("Loyalty", QuickSaleButtonId.loyalty, 1, 10));
        config.addNavButton(new QuickSaleNavInfo("Customer Message", QuickSaleButtonId.customerMessage, 1, 1));
        config.addNavButton(new QuickSaleNavInfo("Dine In", QuickSaleButtonId.dineInSaleBtn, 1, 1));
        config.addNavButton(new QuickSaleNavInfo("Takeaway", QuickSaleButtonId.takeawaySaleBtn, 1, 1));
        config.addNavButton(new QuickSaleNavInfo("PayPal", QuickSaleButtonId.payPal, 1, 1));
        if (PersistentLicenseManager.getInstance().getBoolean(LicenseType.EftposIntegrationEnabled)) {
            config.addNavButton(new QuickSaleNavInfo("Quick Eftpos", QuickSaleButtonId.quickEftpos, 3, 1));
        } else {
            config.addNavButton(new QuickSaleNavInfo("Visa", QuickSaleButtonId.visaPay, 3, 1));
            config.addNavButton(new QuickSaleNavInfo("Mastcard", QuickSaleButtonId.mastercardPay, 3, 2));
            config.addNavButton(new QuickSaleNavInfo("Amex", QuickSaleButtonId.amexPay, 3, 3));
            config.addNavButton(new QuickSaleNavInfo("Diners", QuickSaleButtonId.dinersPay, 3, 4));
            config.addNavButton(new QuickSaleNavInfo("Eftpos", QuickSaleButtonId.eftposPay, 3, 5));
        }
        config.checkPriceLevelButtons();
        return config;
    }

    @Override
    public void delete() {
        PersistenceManager.delete(this);
        this.navButtons.deleteChild();
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
        this.terminals.saveChild();
        this.navButtons.saveChild();
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    public void checkPriceLevelButtons() {
        ArrayList<PriceLevel> allPriceLevels = new ArrayList<PriceLevel>(PriceLevel.getAllPriceLevels());
        ArrayList<QuickSaleNavInfo> buttonsToDelete = new ArrayList<QuickSaleNavInfo>();
        for (QuickSaleNavInfo navInfo : this.getNavButtons()) {
            if (!QuickSaleButtonId.specificPriceLevel.equals((Object)navInfo.getButtonIdentifier())) continue;
            if (navInfo.getPriceLevel() == null || !allPriceLevels.contains(navInfo.getPriceLevel())) {
                buttonsToDelete.add(navInfo);
                continue;
            }
            if (!allPriceLevels.contains(navInfo.getPriceLevel())) continue;
            allPriceLevels.remove(navInfo.getPriceLevel());
        }
        for (QuickSaleNavInfo navInfo : buttonsToDelete) {
            this.remoteNavButton(navInfo);
            navInfo.delete();
        }
        for (PriceLevel priceLevel : allPriceLevels) {
            QuickSaleNavInfo newNavInfo = new QuickSaleNavInfo(priceLevel.getLabel() + " - Price Level", QuickSaleButtonId.specificPriceLevel, 3, 0);
            newNavInfo.setPriceLevel(priceLevel);
            this.addNavButton(newNavInfo);
        }
    }

    public static class Props
    extends PersistentDisplayableObject.Props {
        public PropertiedObject.Property<Terminal> TERMINALS;
        public PropertiedObject.Property ROWS_PER_PAGE;
        public PropertiedObject.Property NUM_COLUMNS;
        public PropertiedObject.Property NUM_PAGES;
        public PropertiedObject.Property<QuickSaleNavInfo> NAV_BUTTONS;
        public PropertiedObject.Property BUTTON_WIDTH;
    }
}

