/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.hardware;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import java.awt.Color;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import ordermate.database.hardware.QuickSaleButtonId;
import ordermate.database.hardware.QuickSaleNavConfig;
import ordermate.database.inventory.PriceLevel;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Type;

@Entity
@Table(name="config_terminal_quick_sale_nav_info")
@AccessType(value="property")
public class QuickSaleNavInfo
extends PersistentObject
implements Saveable {
    private static final String DEFAULT_BUTTON_NAME = "No Name";
    public static final Props Properties = new Props();
    private Reference<QuickSaleNavConfig> config;
    private String buttonName;
    private QuickSaleButtonId buttonIdentifier;
    private int sequence;
    private int pageNumber;
    private boolean active;
    private Color bgColor;
    private Reference<PriceLevel> priceLevel;

    public QuickSaleNavInfo() {
        this.config = this.createReference(QuickSaleNavInfo.Properties.CONFIG);
        this.buttonName = DEFAULT_BUTTON_NAME;
        this.priceLevel = this.createReference(QuickSaleNavInfo.Properties.PRICE_LEVEL);
    }

    protected QuickSaleNavInfo(String newButtonName, QuickSaleButtonId newButtonIdentifier, int newPageNumber, int newSequence) {
        this.config = this.createReference(QuickSaleNavInfo.Properties.CONFIG);
        this.buttonName = DEFAULT_BUTTON_NAME;
        this.priceLevel = this.createReference(QuickSaleNavInfo.Properties.PRICE_LEVEL);
        this.setButtonName(newButtonName);
        this.buttonIdentifier = newButtonIdentifier;
        this.sequence = newSequence;
        this.pageNumber = newPageNumber;
    }

    @Column(name="button_name")
    public String getButtonName() {
        return this.buttonName;
    }

    public void setButtonName(String newButtonName) {
        this.buttonName = newButtonName != null ? newButtonName : DEFAULT_BUTTON_NAME;
    }

    @Column(name="sequence")
    public int getSequence() {
        return this.sequence;
    }

    public void setSequence(int newSequence) {
        this.sequence = newSequence;
    }

    @Column(name="page_number")
    public int getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(int newPageNumber) {
        this.pageNumber = newPageNumber;
    }

    @ManyToOne(targetEntity=QuickSaleNavConfig.class, fetch=FetchType.LAZY)
    @JoinColumn(name="fk_config_gui_quicksale_nav", referencedColumnName="ID")
    public QuickSaleNavConfig getConfig() {
        return this.config.get();
    }

    public void setConfig(QuickSaleNavConfig parent) {
        this.config.set(parent);
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
    }

    @Override
    public void delete() {
        PersistenceManager.delete(this);
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Column(name="button_identifier")
    @Enumerated(value=EnumType.STRING)
    public QuickSaleButtonId getButtonIdentifier() {
        return this.buttonIdentifier;
    }

    protected void setButtonIdentifier(QuickSaleButtonId newButtonIdentifier) {
        this.buttonIdentifier = newButtonIdentifier;
    }

    @Column(name="bg_color")
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.ColorMapping")
    public Color getBgColor() {
        return this.bgColor;
    }

    public void setBgColor(Color color) {
        this.bgColor = color;
    }

    @Column(name="active")
    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean isActive) {
        this.active = isActive;
    }

    @Override
    public String toString() {
        return this.buttonName;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="FK_inventory_price_level")
    public PriceLevel getPriceLevel() {
        return this.priceLevel.get();
    }

    public void setPriceLevel(PriceLevel priceLevel) {
        this.priceLevel.set(priceLevel);
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property BUTTON_NAME;
        public PropertiedObject.Property BUTTON_IDENTIFIER;
        public PropertiedObject.Property SEQUENCE;
        public PropertiedObject.Property PAGE_NUMBER;
        public PropertiedObject.Property<QuickSaleNavConfig> CONFIG;
        public PropertiedObject.Property BG_COLOR;
        public PropertiedObject.Property ACTIVE;
        public PropertiedObject.Property<PriceLevel> PRICE_LEVEL;
    }
}

