/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.hardware;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentDisplayableObject;
import au.com.ordermate.persistence.PersistentList;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.persistence.cache.LocalCacheListManager;
import au.com.ordermate.persistence.cache.LocalCachedReference;
import au.com.ordermate.persistence.reference.QueryReference;
import au.com.ordermate.util.IPAddressUtils;
import au.com.ordermate.util.ListUtils;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.image.ColourWheel;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.persistence.AttributeOverride;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import ordermate.OrderMate;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.finance.Shift;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.gui.GuiConfigSet;
import ordermate.database.hardware.GTL;
import ordermate.database.hardware.QuickSaleNavConfig;
import ordermate.database.hardware.QuickSaleNavInfo;
import ordermate.database.hardware.TerminalLocation;
import ordermate.database.hardware.TerminalMode;
import ordermate.database.hardware.TicketDataConfig;
import ordermate.database.hardware.VirtualPrinter;
import ordermate.database.hardware.physical.Camera;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.hardware.physical.PhysicalPrintDevice;
import ordermate.database.hardware.physical.PhysicalPrinter;
import ordermate.database.hardware.physical.PoleDisplay;
import ordermate.database.hardware.physical.ProximityReader;
import ordermate.database.hardware.physical.callerid.CallerIDUnit;
import ordermate.database.hardware.physical.reboot.WindowsRebootable;
import ordermate.database.inventory.InventoryProfileHelper;
import ordermate.database.misc.SystemCurrentInfo;
import ordermate.database.misc.license.PersistentLicenseManager;
import ordermate.database.sales.AccountType;
import ordermate.database.sales.BarTabAccount;
import ordermate.database.sales.DriveThruAccount;
import ordermate.database.sales.PhoneAccount;
import ordermate.database.sales.TableAccount;
import ordermate.database.sales.TakeawayAccount;
import ordermate.database.stock.DecrementStockArea;
import ordermate.database.stock.StockArea;
import ordermate.database.users.User;
import ordermate.misc.ServerMateRestClient;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Entity
@Table(name="config_terminal")
@AccessType(value="property")
@AttributeOverride(name="label", column=@Column(name="Name"))
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class Terminal
extends PersistentDisplayableObject
implements Saveable,
WindowsRebootable {
    public static final Props Properties = new Props();
    public static final PropertiedObject.Property[] COMMON_PROPS = new PropertiedObject.Property[]{Terminal.Properties.TERMINAL_TYPE, Terminal.Properties.LABEL, Terminal.Properties.ADDRESS};
    public static final PropertiedObject.Property[] COMMON_ORDERING_PROPS = new PropertiedObject.Property[]{Terminal.Properties.SEAT_NUMS, Terminal.Properties.LOCATION, Terminal.Properties.DEFAULT_LOCATION, Terminal.Properties.MENU_CACHING, Terminal.Properties.STICKY_MENU, Terminal.Properties.AVAILABLE_RECEIPT_PRINTERS, Terminal.Properties.HAS_ASSIGNED_CASHDRAWERS, Terminal.Properties.STOCK_AREA, Terminal.Properties.AUTO_PRINT_ON_DELETE, Terminal.Properties.AUTO_PRINT_ON_ADJUSTMENT};
    public static final PropertiedObject.Property[] WAITERMATE_PROPS = new PropertiedObject.Property[]{Terminal.Properties.QUICK_LOGOUT, Terminal.Properties.SHOW_PIN, Terminal.Properties.SAVE_BUTTON_ENABLED, Terminal.Properties.GTL, Terminal.Properties.HAS_AUTO_MENU_SELECT, Terminal.Properties.BISTRO_MODE, Terminal.Properties.BISTRO_KEEP_OPEN, Terminal.Properties.HAS_BARCODES, Terminal.Properties.HAS_MENU_KEYPAD, Terminal.Properties.QUICK_DISCOUNT, Terminal.Properties.MANUALLY_PRINT_PREP, Terminal.Properties.QUICK_SEAT_SELECT, Terminal.Properties.QUICK_CUSTOMER, Terminal.Properties.SKIMMING, Terminal.Properties.TABBED_MENU_ORDERING, Terminal.Properties.FORCED_OPTIONS, Terminal.Properties.PRINT_PREP_AS_ORDERING, Terminal.Properties.QUICK_SALE_MENU_WIDTH, Terminal.Properties.STICKY_PLUS_MINUS, Terminal.Properties.QUICK_SALE_SINGLE_SCREEN_ORDERING, Terminal.Properties.QUICKSALE_QTY_KEYPAD, Terminal.Properties.SHOW_QUANTITY_KEYPAD, Terminal.Properties.PAY_TAB_DEBTOR, Terminal.Properties.SINGLE_SCREEN_ORDERING, Terminal.Properties.SHOW_QUICK_ORDER_INFO_BUTTON, Terminal.Properties.AUTO_LOGOUT_COUNT_DOWN, Terminal.Properties.AUTO_LOGOUT_DELAY, Terminal.Properties.AUTO_SAVE_PAID_ACC_COUNT_DOWN, Terminal.Properties.AUTO_SAVE_PAID_ACC_DELAY, Terminal.Properties.SHOW_QUANTITY, Terminal.Properties.QUICK_SALE_SHOW_QUANTITY, Terminal.Properties.PROMPT_FOR_CUSTOM_DISCOUNT_REASON, Terminal.Properties.SHOW_MAKE_COMBO_IN_NAV, Terminal.Properties.DARK_LOGO, Terminal.Properties.GENERAL_MANUAL_PRINT_PREP, Terminal.Properties.UNALLOCATED_TABLE_ALLOWED, Terminal.Properties.DEFER_UNALLOCATED_TABLE_PREP_DOCKETS, Terminal.Properties.FINGERPRINT_SCANNER, Terminal.Properties.USE_ONSCREEN_KEYBOARD, Terminal.Properties.POSIFLEX_READER_ENABLED, Terminal.Properties.BARTAB_PREAUTH, Terminal.Properties.QUICKSALE_TAKEAWAY_STAND_NAME, Terminal.Properties.QUICKSALE_TAKEAWAY_STAND_NUM};
    public static final PropertiedObject.Property[] SERVERMATE_PROPS = new PropertiedObject.Property[0];
    public static final PropertiedObject.Property[] POCKETMATE_PROPS = new PropertiedObject.Property[]{Terminal.Properties.USERNAME};
    public static final String WAITERMATE_TERMINAL = "WaiterMate";
    public static final String SERVERMATE_TERMINAL = "ServerMate";
    public static final String INTEGRATION_TERMINAL = "Integration";
    private static LocalCacheListManager<Terminal> allTerminalsExceptServermateCache;
    private static LocalCacheListManager<Terminal> allWaitermateTerminalsCache;
    private LocalCacheListManager<Terminal> thisTerminalCache;
    private String address;
    private String terminalType;
    private String systemState = "ACTIVE";
    private boolean hasMenuKeypad;
    private boolean stickyMenu;
    private boolean hasOrdatronicsIntegration;
    private boolean hasBarcodes;
    private boolean bistroMode;
    private boolean bistroKeepOpen;
    private boolean hasAssignedCashdrawers;
    private boolean hasAutoMenuSelect;
    private GTL gtl;
    private ColourWheel.Palette palette;
    private boolean seatNums;
    private boolean menuCaching;
    private boolean saveButtonEnabled;
    private boolean showPin;
    private boolean quickLogout;
    private boolean quicksaleTakeawayStandName;
    private boolean quicksaleTakeawayStandNum;
    private boolean quicksaleDineinStandName;
    private boolean quicksaleDineinStandNum;
    private boolean takeawayStandName;
    private boolean takeawayStandNum;
    private boolean autoPromptTA;
    private boolean autoPromptQS;
    private boolean quickDiscount;
    private boolean manuallyPrintPrep;
    private boolean quickSeatSelect;
    private boolean quickCustomer;
    private boolean quicksaleBistroMode;
    private boolean skimming;
    private boolean tabbedMenuOrdering;
    private boolean forcedOptions;
    private boolean printPrepAsOrdering;
    private int quickSaleMenuWidth = 25;
    private boolean stickyPlusMinus;
    private boolean quickSaleSingleScreenOrdering;
    private boolean quickSaleTabbedMenuOrdering;
    private boolean quickSaleQtyKeyPad;
    private boolean showQuantityKeypad;
    private boolean payTabDebtor;
    private boolean singleScreenOrdering;
    private boolean showQuickOrderInfoButton;
    private boolean showQuantity;
    private boolean quickSaleShowQuantity;
    private boolean quickSaleOneTouch;
    private boolean promptForCustomDiscountReason;
    private boolean showMakeComboInNav;
    private boolean quickSaleQuickTransfer;
    private boolean darkLogo;
    private boolean generalManualPrintPrep;
    private boolean unallocatedTableAllowed;
    private boolean deferUnallocatedTablePrepDockets;
    private boolean useOnscreenKeyboard;
    private int autoLogoutDelay;
    private int backToIdleTimeout;
    private int autoLogoutCountDown;
    private int autoSavePaidAccDelay;
    private int autoSavePaidAccCountDown;
    private boolean tableTicketDataName;
    private boolean holdTable;
    private boolean holdTakeaway;
    private String lookAndFeelClassName;
    private int guiFontSize;
    private boolean previousSalesQuickSale;
    private boolean previousSalesTable;
    private boolean previousSalesPhone;
    private boolean previousSalesTakeaway;
    private boolean previousSalesOnline;
    private boolean bartabPreauth;
    private String cameraLayout;
    private Reference<GuiConfigSet> screenLayoutSet;
    private String username;
    private PersistentList<VirtualPrinter> availableReceiptPrinters;
    private PersistentList<PoleDisplay> availablePoleDisplays;
    private PersistentList<CallerIDUnit> availableCallerIDUnits;
    private PersistentList<ProximityReader> availableProximityReaders;
    private PersistentList<CashDrawer> availableLogicallyConnectedCashDrawers;
    private PersistentList<PhysicalPrinter> connectedPrinters;
    private PersistentList<CashDrawer> connectedCashDrawers;
    private PersistentList<Camera> availableCamera;
    private Reference<QuickSaleNavConfig> quickSaleNavConfig;
    private PersistentWriteableList<TerminalMode> terminalModes;
    private PersistentList<DecrementStockArea> decrementStockAreas;
    private Reference<StockArea> stockArea;
    private Reference<TerminalLocation> location;
    private Reference<TerminalLocation> defaultLocation;
    private Reference<SalesLocation> salesLocation;
    private Reference<SalesLocation> defaultSalesLocation;
    private Reference<Shift> shift;
    private Reference<VirtualPrinter> autoPrintOnAdjustment;
    private Reference<VirtualPrinter> autoPrintOnDelete;
    private TerminalLocation loadedLocation;
    private static Reference myTerminal;
    private static String localTerminalType;
    private static String localUsername;
    private static Terminal servermateTerminal;
    private static Set<Terminal> servermateTerminals;
    private transient InetAddress inetAddressCache;
    private Price minimumDeliveryOrder;
    private boolean fingerprintScanner;
    private Integer rmiPort;
    private boolean posiflexReaderEnabled;
    private boolean showOnline;
    private Integer customButtonFlashTime;
    private boolean loginAnimating;
    private TicketDataConfig ticketDataConfig;

    public Terminal() {
        this.screenLayoutSet = this.createReference(Terminal.Properties.SCREEN_LAYOUT_SET);
        this.availableReceiptPrinters = this.createList(Terminal.Properties.AVAILABLE_RECEIPT_PRINTERS);
        this.availablePoleDisplays = this.createList(Terminal.Properties.AVAILABLE_POLE_DISPLAYS);
        this.availableCallerIDUnits = this.createList(Terminal.Properties.AVAILABLE_CALLER_ID_UNITS);
        this.availableProximityReaders = this.createList(Terminal.Properties.AVAILABLE_PROXIMITY_READERS);
        this.availableLogicallyConnectedCashDrawers = this.createList(Terminal.Properties.AVAILABLE_LOGICALLY_CONNECTED_CASHDRAWERS);
        this.connectedPrinters = this.createList(Terminal.Properties.CONNECTED_PRINTERS);
        this.connectedCashDrawers = this.createList(Terminal.Properties.CONNECTED_CASHDRAWERS);
        this.availableCamera = this.createList(Terminal.Properties.AVAILABLE_CAMERA);
        this.quickSaleNavConfig = this.createReference(Terminal.Properties.QUICK_SALE_NAV_CONFIG);
        this.terminalModes = (PersistentWriteableList)this.createList(Terminal.Properties.TERMINAL_MODES);
        this.decrementStockAreas = this.createList(Terminal.Properties.DECREMENT_STOCK_AREAS);
        this.stockArea = this.createReference(Terminal.Properties.STOCK_AREA);
        this.location = this.createReference(Terminal.Properties.LOCATION);
        this.defaultLocation = this.createReference(Terminal.Properties.DEFAULT_LOCATION);
        this.salesLocation = this.createReference(Terminal.Properties.SALES_LOCATION);
        this.defaultSalesLocation = this.createReference(Terminal.Properties.DEFAULT_SALES_LOCATION);
        this.shift = this.createReference(Terminal.Properties.SHIFT);
        this.autoPrintOnAdjustment = this.createReference(Terminal.Properties.AUTO_PRINT_ON_ADJUSTMENT);
        this.autoPrintOnDelete = this.createReference(Terminal.Properties.AUTO_PRINT_ON_DELETE);
        this.inetAddressCache = null;
        this.minimumDeliveryOrder = Price.ZERO_DOLLAR;
        this.fingerprintScanner = false;
        this.posiflexReaderEnabled = false;
        this.showOnline = false;
        this.customButtonFlashTime = 0;
        this.ticketDataConfig = TicketDataConfig.NoAccountTypePrompt;
    }

    public Terminal copy() {
        Terminal newTerminal = new Terminal(null, this.getTerminalType());
        for (PropertiedObject.Property prop : Properties) {
            try {
                if (prop.isList() || prop.equals(Terminal.Properties.SHIFT)) continue;
                newTerminal.setPropertyValue(prop, this.getPropertyValue(prop));
            }
            catch (Exception e) {
                OrderMate.LOG.warn("Could not copy terminal property " + prop);
            }
        }
        for (TerminalMode mode : this.getTerminalModes()) {
            newTerminal.addTerminalMode(mode.copy());
        }
        newTerminal.setShift(this.getShift());
        newTerminal.setIPAddress("255.255.255.255");
        return newTerminal;
    }

    public Terminal(InetAddress ipaddress, String type) {
        this.screenLayoutSet = this.createReference(Terminal.Properties.SCREEN_LAYOUT_SET);
        this.availableReceiptPrinters = this.createList(Terminal.Properties.AVAILABLE_RECEIPT_PRINTERS);
        this.availablePoleDisplays = this.createList(Terminal.Properties.AVAILABLE_POLE_DISPLAYS);
        this.availableCallerIDUnits = this.createList(Terminal.Properties.AVAILABLE_CALLER_ID_UNITS);
        this.availableProximityReaders = this.createList(Terminal.Properties.AVAILABLE_PROXIMITY_READERS);
        this.availableLogicallyConnectedCashDrawers = this.createList(Terminal.Properties.AVAILABLE_LOGICALLY_CONNECTED_CASHDRAWERS);
        this.connectedPrinters = this.createList(Terminal.Properties.CONNECTED_PRINTERS);
        this.connectedCashDrawers = this.createList(Terminal.Properties.CONNECTED_CASHDRAWERS);
        this.availableCamera = this.createList(Terminal.Properties.AVAILABLE_CAMERA);
        this.quickSaleNavConfig = this.createReference(Terminal.Properties.QUICK_SALE_NAV_CONFIG);
        this.terminalModes = (PersistentWriteableList)this.createList(Terminal.Properties.TERMINAL_MODES);
        this.decrementStockAreas = this.createList(Terminal.Properties.DECREMENT_STOCK_AREAS);
        this.stockArea = this.createReference(Terminal.Properties.STOCK_AREA);
        this.location = this.createReference(Terminal.Properties.LOCATION);
        this.defaultLocation = this.createReference(Terminal.Properties.DEFAULT_LOCATION);
        this.salesLocation = this.createReference(Terminal.Properties.SALES_LOCATION);
        this.defaultSalesLocation = this.createReference(Terminal.Properties.DEFAULT_SALES_LOCATION);
        this.shift = this.createReference(Terminal.Properties.SHIFT);
        this.autoPrintOnAdjustment = this.createReference(Terminal.Properties.AUTO_PRINT_ON_ADJUSTMENT);
        this.autoPrintOnDelete = this.createReference(Terminal.Properties.AUTO_PRINT_ON_DELETE);
        this.inetAddressCache = null;
        this.minimumDeliveryOrder = Price.ZERO_DOLLAR;
        this.fingerprintScanner = false;
        this.posiflexReaderEnabled = false;
        this.showOnline = false;
        this.customButtonFlashTime = 0;
        this.ticketDataConfig = TicketDataConfig.NoAccountTypePrompt;
        if (ipaddress != null) {
            this.address = ipaddress.getHostAddress();
        }
        this.inetAddressCache = ipaddress;
        this.setLabel("new terminal");
        this.setTerminalType(type);
        this.systemState = "ACTIVE";
        TerminalLocation aLocation = TerminalLocation.getDefaultLocation();
        this.defaultLocation.set(aLocation);
        this.location.set(aLocation);
        this.shift.set(Terminal.getServerMateTerminal().getShift());
        if (!StockArea.getStockAreas().isEmpty()) {
            this.stockArea.set((StockArea)((PersistentObjectI)StockArea.getStockAreas().get(0)));
        }
        SalesLocation tempSalesLocation = SalesLocation.getDefaultSalesLocation();
        this.defaultSalesLocation.set(tempSalesLocation);
        this.salesLocation.set(tempSalesLocation);
        this.showPin = true;
        this.gtl = GTL.Linked;
        this.palette = ColourWheel.Palette.Ocean;
        this.saveButtonEnabled = true;
        this.menuCaching = true;
        this.stickyMenu = true;
        this.bartabPreauth = false;
        this.createQuickSaleNavConfigIfNecessary();
    }

    private void createQuickSaleNavConfigIfNecessary() {
        if (this.getQuickSaleNavConfig() == null && WAITERMATE_TERMINAL.equals(this.getTerminalType())) {
            this.setQuickSaleNavConfig(QuickSaleNavConfig.create());
        }
    }

    public void setQuickSaleNavConfig(QuickSaleNavConfig config) {
        this.quickSaleNavConfig.set(config);
    }

    @ManyToOne(targetEntity=QuickSaleNavConfig.class)
    @JoinColumn(name="fk_config_gui_quicksale_nav", referencedColumnName="ID")
    public QuickSaleNavConfig getQuickSaleNavConfig() {
        return this.quickSaleNavConfig.get();
    }

    @Override
    public void init() {
        super.init();
        this.loadedLocation = this.location.get();
    }

    @Column(name="system_state")
    public String getSystemState() {
        return this.systemState;
    }

    @Transient
    public InetAddress getAddress() {
        if (this.inetAddressCache == null && this.address != null) {
            this.inetAddressCache = this.getInetAddress();
        }
        return this.inetAddressCache;
    }

    @Column(name="IPAddress")
    public String getIPAddress() {
        return this.address == null ? null : this.address;
    }

    public void setIPAddress(String ipAdd) {
        this.address = ipAdd;
        this.inetAddressCache = null;
        try {
            this.inetAddressCache = InetAddress.getByName(this.address);
        }
        catch (UnknownHostException ex) {
            OrderMate.LOG.info((Object)ex);
        }
    }

    @Column(name="type")
    public String getTerminalType() {
        return this.terminalType;
    }

    public void setTerminalType(String newType) {
        this.terminalType = newType;
    }

    @Column(name="Log_Off")
    public boolean getQuickLogout() {
        return this.quickLogout;
    }

    public void setQuickLogout(boolean autoLogOut) {
        this.quickLogout = autoLogOut;
    }

    @Column(name="Pin_Login")
    public boolean getShowPin() {
        return this.showPin;
    }

    @Column(name="quick_discount")
    public boolean getQuickDiscount() {
        return this.quickDiscount;
    }

    @Column(name="menu_item_keypad")
    public boolean getHasMenuKeypad() {
        return this.hasMenuKeypad;
    }

    @Column(name="graphical_layout")
    @Enumerated(value=EnumType.STRING)
    public GTL getGtl() {
        return this.gtl;
    }

    @Transient
    public ColourWheel.Palette getPalette() {
        return this.palette;
    }

    public void setPalette(ColourWheel.Palette value) {
        this.palette = value;
    }

    @Column(name="cache_menu")
    public boolean getMenuCaching() {
        return this.menuCaching;
    }

    public void setGtl(GTL newGtl) {
        this.gtl = newGtl;
    }

    @Column(name="seat_nums")
    public boolean getSeatNums() {
        return this.seatNums;
    }

    @Column(name="quick_seat_select")
    public boolean getQuickSeatSelect() {
        return this.quickSeatSelect;
    }

    @Column(name="quick_customer")
    public boolean getQuickCustomer() {
        return this.quickCustomer;
    }

    @Column(name="quicksale_bistro_mode")
    public boolean isQuicksaleBistroMode() {
        return this.quicksaleBistroMode;
    }

    public List<CashDrawer> getAvailableCashDrawers(User theUser) {
        List<CashDrawer> drawers = this.hasAssignedCashdrawers ? CashDrawer.getAvailableCashDrawers(this, theUser) : new ArrayList<CashDrawer>(this.availableLogicallyConnectedCashDrawers);
        return drawers;
    }

    public List<CashDrawer> getPayableCashDrawers(User user) {
        List<CashDrawer> drawers = this.getAvailableCashDrawers(user);
        ArrayList<CashDrawer> toRemove = null;
        for (CashDrawer drawer : drawers) {
            if (drawer.isUserPayable()) continue;
            if (toRemove == null) {
                toRemove = new ArrayList<CashDrawer>();
            }
            toRemove.add(drawer);
        }
        if (toRemove != null) {
            drawers.removeAll(toRemove);
        }
        return drawers;
    }

    public CashDrawer getAssignedCashDrawer(User theUser) {
        List<CashDrawer> drawers = null;
        drawers = SERVERMATE_TERMINAL.equals(this.getTerminalType()) ? this.getAvailableCashDrawers(theUser) : this.getPayableCashDrawers(theUser);
        if (drawers == null || drawers.size() == 0) {
            return null;
        }
        return drawers.get(0);
    }

    @Transient
    public List<VirtualPrinter> getAvailableReceiptPrinters() {
        return this.availableReceiptPrinters;
    }

    @Transient
    public List<VirtualPrinter> getAvaliableWindowsReceiptPrinters() {
        ArrayList<VirtualPrinter> printerList = new ArrayList<VirtualPrinter>();
        for (VirtualPrinter printer : this.availableReceiptPrinters) {
            String portType;
            PhysicalPrintDevice physical = printer.getPrintDevice();
            if (physical == null || !(portType = physical.getPortType()).equals("Gui") && !portType.equals("Windows")) continue;
            printerList.add(printer);
        }
        return printerList;
    }

    @Transient
    public List<VirtualPrinter> getAvaliableReceiptPrintersWindowsFirst() {
        ArrayList<VirtualPrinter> windowsPrinters = new ArrayList<VirtualPrinter>();
        ArrayList<VirtualPrinter> receiptNotWindowsPrinters = new ArrayList<VirtualPrinter>();
        for (VirtualPrinter printer : this.availableReceiptPrinters) {
            PhysicalPrintDevice physical = printer.getPrintDevice();
            if (physical == null) continue;
            String portType = physical.getPortType();
            if (portType.equals("Gui") || portType.equals("Windows")) {
                windowsPrinters.add(printer);
                continue;
            }
            receiptNotWindowsPrinters.add(printer);
        }
        windowsPrinters.addAll(receiptNotWindowsPrinters);
        return windowsPrinters;
    }

    @Transient
    public List getAvailableAccountPayoffPrinters() {
        List<VirtualPrinter> printers = PersistenceManager.getObjectList(VirtualPrinter.class, "SELECT config_printer_virtual.* FROM config_printer_virtual, config_payoff_printer WHERE config_printer_virtual.ID = config_payoff_printer.FK_config_printer_virtual AND config_payoff_printer.FK_config_terminal = ? AND (config_payoff_printer.unit_type = ? OR config_payoff_printer.unit_type = 'All')", new Object[]{this.getID(), "ACCOUNT"});
        return printers;
    }

    public List<VirtualPrinter> getAvailablePayoffPrinters(List financeTransactions) {
        if (financeTransactions == null) {
            throw new IllegalArgumentException("List is null, No finance transaction");
        }
        HashSet<VirtualPrinter> availablePayoffPrinters = new HashSet<VirtualPrinter>();
        List<VirtualPrinter> printers = PersistenceManager.getObjectList(VirtualPrinter.class, "SELECT config_printer_virtual.* FROM config_printer_virtual, config_payoff_printer WHERE config_printer_virtual.ID = config_payoff_printer.FK_config_printer_virtual AND config_payoff_printer.FK_config_terminal = ? AND config_payoff_printer.unit_type = 'ALL' ", new Object[]{this.getID()});
        availablePayoffPrinters.addAll(printers);
        for (FinanceTransaction transaction : financeTransactions) {
            printers = PersistenceManager.getObjectList(VirtualPrinter.class, "SELECT config_printer_virtual.* FROM config_printer_virtual, config_payoff_printer WHERE config_printer_virtual.ID = config_payoff_printer.FK_config_printer_virtual AND config_payoff_printer.FK_config_terminal = ? AND (config_payoff_printer.unit_type = ? OR config_payoff_printer.unit_type = 'All')", new Object[]{this.getID(), transaction.getSubType().getType()});
            availablePayoffPrinters.addAll(printers);
        }
        return new ArrayList<VirtualPrinter>(availablePayoffPrinters);
    }

    @ManyToMany
    @JoinTable(name="config_terminal_pole", joinColumns={@JoinColumn(name="FK_config_terminal", referencedColumnName="ID")}, inverseJoinColumns={@JoinColumn(name="FK_config_pole", referencedColumnName="ID")})
    public List<PoleDisplay> getAvailablePoleDisplays() {
        return this.availablePoleDisplays;
    }

    @Transient
    public CallerIDUnit getAvailableCallerIDUnit() {
        if (this.availableCallerIDUnits.isEmpty()) {
            return null;
        }
        return (CallerIDUnit)this.availableCallerIDUnits.get(0);
    }

    @ManyToMany
    @JoinTable(name="config_terminal_calleridunit", joinColumns={@JoinColumn(name="FK_config_terminal", referencedColumnName="ID")}, inverseJoinColumns={@JoinColumn(name="FK_config_calleridunit", referencedColumnName="ID")})
    protected List<CallerIDUnit> getAvailableCallerIDUnits() {
        return this.availableCallerIDUnits;
    }

    @OneToMany(mappedBy="host", targetEntity=PhysicalPrinter.class)
    public List<PhysicalPrinter> getConnectedPrinters() {
        return this.connectedPrinters.getUnmodifiable();
    }

    @OneToMany(mappedBy="host", targetEntity=CashDrawer.class)
    public List<CashDrawer> getConnectedCashDrawers() {
        return this.connectedCashDrawers;
    }

    @Transient
    public Integer getRmiPort() {
        if (this.rmiPort == null) {
            this.rmiPort = this.getTerminalType().equals(SERVERMATE_TERMINAL) ? Integer.valueOf(11100) : (this.getTerminalType().equals(WAITERMATE_TERMINAL) ? Integer.valueOf(11101) : Integer.valueOf(1099));
        }
        return this.rmiPort;
    }

    public void setRmiPort(Integer newPort) {
        this.rmiPort = newPort;
    }

    public boolean hasQuickSale() {
        boolean hasQuickSale = false;
        Iterator it = this.terminalModes.iterator();
        while (it.hasNext() && !hasQuickSale) {
            TerminalMode mode = (TerminalMode)it.next();
            if (!mode.getMode().equals("Quick Sale")) continue;
            hasQuickSale = true;
        }
        return hasQuickSale;
    }

    @Transient
    public int getNumQuickSale() {
        int numQuickSale = 0;
        for (TerminalMode mode : this.terminalModes) {
            if (!mode.getMode().equals("Quick Sale")) continue;
            ++numQuickSale;
        }
        return numQuickSale;
    }

    @Column(name="manually_print_prep")
    public boolean getManuallyPrintPrep() {
        return this.manuallyPrintPrep;
    }

    public boolean hasPhoneMode() {
        boolean hasPhone = false;
        Iterator it = this.terminalModes.iterator();
        while (it.hasNext() && !hasPhone) {
            TerminalMode mode = (TerminalMode)it.next();
            if (!mode.getMode().equals("Phone") && !mode.getMode().equals("Phone with Delivery")) continue;
            hasPhone = true;
        }
        return hasPhone;
    }

    public boolean hasTableMode() {
        boolean hasTable = false;
        Iterator it = this.terminalModes.iterator();
        while (it.hasNext() && !hasTable) {
            TerminalMode mode = (TerminalMode)it.next();
            if (!mode.getMode().equals("Tables")) continue;
            hasTable = true;
        }
        return hasTable;
    }

    public boolean hasTakeawayMode() {
        boolean hasTakeaway = false;
        Iterator it = this.terminalModes.iterator();
        while (it.hasNext() && !hasTakeaway) {
            TerminalMode mode = (TerminalMode)it.next();
            if (!mode.getMode().equals("Takeaway")) continue;
            hasTakeaway = true;
            break;
        }
        return hasTakeaway;
    }

    @Column(name="sticky_menus")
    public boolean getStickyMenu() {
        return this.stickyMenu;
    }

    public boolean hasDeliveryMode() {
        boolean hasDelivery = false;
        Iterator it = this.terminalModes.iterator();
        while (it.hasNext() && !hasDelivery) {
            TerminalMode mode = (TerminalMode)it.next();
            if (!mode.getMode().equals("Phone with Delivery")) continue;
            hasDelivery = true;
            break;
        }
        if (hasDelivery) {
            boolean isLicensed = PersistentLicenseManager.getInstance().isDeliveryModeAvailable(this);
            if (!isLicensed) {
                OrderMate.LOG.warn("Terminal has delivery mode enabled but could not aquire license." + this.getLabel());
            }
            return hasDelivery && isLicensed;
        }
        return false;
    }

    public boolean hasOrdatronicsIntegration() {
        return this.hasOrdatronicsIntegration;
    }

    @Column(name="barcodes")
    public boolean getHasBarcodes() {
        return this.hasBarcodes;
    }

    @Column(name="auto_select_group")
    public boolean getHasAutoMenuSelect() {
        return this.hasAutoMenuSelect;
    }

    @Column(name="assigned_cashdrawers")
    public boolean getHasAssignedCashdrawers() {
        return this.hasAssignedCashdrawers;
    }

    @Column(name="save_button")
    public boolean isSaveButtonEnabled() {
        return this.saveButtonEnabled;
    }

    @Column(name="prompt_for_custom_discount_reason")
    public boolean isPromptForCustomDiscountReason() {
        return this.promptForCustomDiscountReason;
    }

    public void setPromptForCustomDiscountReason(boolean newValue) {
        this.promptForCustomDiscountReason = newValue;
    }

    public boolean hasBarTabsMode() {
        boolean hasBarTab = false;
        Iterator it = this.terminalModes.iterator();
        while (it.hasNext() && !hasBarTab) {
            TerminalMode mode = (TerminalMode)it.next();
            if (!mode.getMode().equals("Bar Tabs")) continue;
            hasBarTab = true;
        }
        return hasBarTab;
    }

    @Column(name="table_ticket_data_name")
    public boolean getTableTicketDataName() {
        return this.tableTicketDataName;
    }

    public void setTableTicketDataName(boolean value) {
        this.tableTicketDataName = value;
    }

    public boolean ticketDataRequired() {
        TicketDataConfig config = this.getTicketDataConfig();
        return config.equals((Object)TicketDataConfig.TicketDataFirst) || config.equals((Object)TicketDataConfig.AccountTypeFirst) || config.equals((Object)TicketDataConfig.NoAccountTypePrompt) && (this.isQuicksaleDineinStandName() || this.isQuicksaleDineinStandNum() || this.isQuicksaleTakeawayStandName() || this.isQuicksaleTakeawayStandNum() || this.isTakeawayStandName() || this.isTakeawayStandNum());
    }

    @Column(name="skimming")
    public boolean getSkimming() {
        return this.skimming;
    }

    @Transient
    public List<AccountType> getSupportedAccountTypes() {
        ArrayList<AccountType> accountTypes = new ArrayList<AccountType>(4);
        if (this.getTerminalType().equals(WAITERMATE_TERMINAL)) {
            if (this.hasTableMode()) {
                accountTypes.add(TableAccount.TYPE);
            }
            if (this.hasTakeawayMode() || this.hasQuickSale()) {
                accountTypes.add(TakeawayAccount.TYPE);
            }
            if (this.hasPhoneMode()) {
                accountTypes.add(PhoneAccount.TYPE);
            }
            if (this.hasDriveThruMode()) {
                accountTypes.add(DriveThruAccount.TYPE);
            }
            if (this.hasBarTabsMode() && this.hasTableMode()) {
                accountTypes.add(BarTabAccount.TYPE);
            }
        }
        return accountTypes;
    }

    @Transient
    public StockArea getStockArea() {
        return this.stockArea.get();
    }

    public void setStockArea(StockArea area) {
        this.stockArea.set(area);
    }

    public static List<Terminal> getAllTerminalsExceptServer() {
        if (allTerminalsExceptServermateCache == null) {
            allTerminalsExceptServermateCache = new LocalCacheListManager<Terminal>(Query.createQueryList(Terminal.class, "SELECT config_terminal.* FROM config_terminal WHERE config_terminal.system_state = 'ACTIVE' AND type <> 'ServerMate' "));
        }
        return allTerminalsExceptServermateCache.getList();
    }

    @Transient
    private LocalCacheListManager<Terminal> getTerminalCacheListManager() {
        if (this.thisTerminalCache == null) {
            this.thisTerminalCache = new LocalCacheListManager<Terminal>(Query.createQueryList(Terminal.class, Query.select(Terminal.class).not().equals(Terminal.Properties.TERMINAL_TYPE, SERVERMATE_TERMINAL).equals(Terminal.Properties.ID, this.getID()).active(Terminal.class)));
        }
        return this.thisTerminalCache;
    }

    @Transient
    public List<Terminal> getCacheList() {
        return this.getTerminalCacheListManager().getList();
    }

    public static List<Terminal> getAllWaiterMateTerminals() {
        if (allWaitermateTerminalsCache == null) {
            allWaitermateTerminalsCache = new LocalCacheListManager<Terminal>(Query.createQueryList(Terminal.class, Query.select(Terminal.class).equals(Terminal.Properties.TERMINAL_TYPE, WAITERMATE_TERMINAL).active(Terminal.class).orderBy(Terminal.Properties.ID)));
        }
        return allWaitermateTerminalsCache.getList();
    }

    public static List<Terminal> getAllTerminals() {
        String sql = Query.select(Terminal.class).active(Terminal.class).orderBy(Terminal.Properties.ID).toString();
        List<Terminal> terms = PersistenceManager.getObjectList(Terminal.class, sql, null);
        return terms;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @OneToMany(mappedBy="host", targetEntity=ProximityReader.class)
    public List<ProximityReader> getAvailableProximityReaders() {
        return this.availableProximityReaders;
    }

    @Transient
    public List<CashDrawer> getAvailableLogicallyConnectedCashDrawers() {
        return this.availableLogicallyConnectedCashDrawers;
    }

    @ManyToOne
    @JoinColumn(name="FK_config_terminal_location")
    public TerminalLocation getLocation() {
        return this.location.get();
    }

    public void setLocation(TerminalLocation newLocation) {
        this.location.set(newLocation);
    }

    public void changeTerminalLocation(TerminalLocation newLocation) {
        if (newLocation == null) {
            throw new IllegalArgumentException("New Terminal location cannot be null.");
        }
        if (this.getLocation() == null) {
            this.setLocation(newLocation);
            this.save();
        } else if (!this.getLocation().equals(newLocation)) {
            this.setLocation(newLocation);
            this.save();
        }
        InventoryProfileHelper.getInstance().clearCache();
    }

    public void changeSalesLocation(SalesLocation newLocation) {
        if (newLocation == null) {
            throw new IllegalArgumentException("New Sales location cannot be null.");
        }
        if (this.getSalesLocation() == null) {
            this.setSalesLocation(newLocation);
            this.save();
        } else if (!this.getSalesLocation().equals(newLocation)) {
            this.setSalesLocation(newLocation);
            this.save();
        }
    }

    @ManyToOne
    @JoinColumn(name="FK_default_config_terminal_location")
    public TerminalLocation getDefaultLocation() {
        return this.defaultLocation.get();
    }

    public void setDefaultLocation(TerminalLocation newLocation) {
        this.defaultLocation.set(newLocation);
    }

    @ManyToOne
    @JoinColumn(name="FK_config_sales_location")
    public SalesLocation getSalesLocation() {
        if (this.salesLocation.isNull()) {
            return SalesLocation.getDefaultSalesLocation();
        }
        return this.salesLocation.get();
    }

    public void setSalesLocation(SalesLocation newSalesLocation) {
        this.salesLocation.set(newSalesLocation);
    }

    @ManyToOne
    @JoinColumn(name="FK_default_config_sales_location")
    public SalesLocation getDefaultSalesLocation() {
        if (this.defaultSalesLocation.isNull()) {
            return SalesLocation.getDefaultSalesLocation();
        }
        return this.defaultSalesLocation.get();
    }

    public void setDefaultSalesLocation(SalesLocation newSalesLocation) {
        this.defaultSalesLocation.set(newSalesLocation);
    }

    @Transient
    public Camera getCCTVCamera() {
        return this.availableCamera.isEmpty() ? null : (Camera)this.availableCamera.get(0);
    }

    @Transient
    public List<Camera> getConnectedCameras() {
        return PersistenceManager.getObjectList(Camera.class, Query.select(Camera.class).equals(Camera.Properties.HOST, this.getID()).active(Camera.class).toString(), null);
    }

    @ManyToMany
    @JoinTable(name="config_terminal_camera", joinColumns={@JoinColumn(name="FK_config_terminal", referencedColumnName="ID")}, inverseJoinColumns={@JoinColumn(name="FK_config_camera", referencedColumnName="ID")})
    protected List<Camera> getAvailableCamera() {
        return this.availableCamera;
    }

    @ManyToOne
    @JoinColumn(name="FK_finance_shift")
    public Shift getShift() {
        return this.shift.get();
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    public static Terminal getMatchingTerminal(List<InetAddress> addresses, String terminalType) {
        Terminal terminal = null;
        for (InetAddress address : addresses) {
            terminal = Terminal.getTerminalByIp(address.getHostAddress(), terminalType);
            if (terminal == null) continue;
            return terminal;
        }
        return terminal;
    }

    public static void setupServerMate(String address) throws UnknownHostException {
        Terminal serverMate = null;
        if (address.equals("localhost") || address.equals("127.0.0.1")) {
            InetAddress localhost;
            List<InetAddress> localAddresses = IPAddressUtils.getLocalAddresses();
            OrderMate.LOG.info("Local addresses: " + ListUtils.listToString(localAddresses, ", "));
            Iterator<InetAddress> iterator = localAddresses.iterator();
            while (iterator.hasNext() && (serverMate = Terminal.getTerminal(localhost = iterator.next(), SERVERMATE_TERMINAL)) == null) {
            }
        } else {
            InetAddress termIP = InetAddress.getByName(address);
            serverMate = Terminal.getTerminal(termIP, SERVERMATE_TERMINAL);
            if (serverMate == null) {
                String terminalIP;
                Iterator<String> iterator = ServerMateRestClient.getServerMateAddresses(address).iterator();
                while (iterator.hasNext() && (serverMate = Terminal.getTerminalByIp(terminalIP = iterator.next(), SERVERMATE_TERMINAL)) == null) {
                }
            }
        }
        if (serverMate == null) {
            throw new IllegalStateException("Cannot find ServerMate terminal at " + address + "!");
        }
        Terminal.setupServerMate(serverMate);
        Terminal.primeServermateCache();
    }

    public static void setupServerMate(Terminal serverMate) {
        OrderMate.LOG.info("Setting Servermate Terminal:" + serverMate);
        servermateTerminal = serverMate;
    }

    private static void primeServermateCache() {
        OrderMate.LOG.info("Priming Servermate cache");
        if (servermateTerminals.isEmpty()) {
            servermateTerminals.addAll(PersistenceManager.getObjectList(Terminal.class, "SELECT config_terminal.* FROM config_terminal WHERE type = 'ServerMate' AND system_state= 'ACTIVE'", null));
            OrderMate.LOG.info("Added Servers to cache:" + servermateTerminals);
        }
    }

    public static synchronized void setupLocalhost(String type) {
        if (!type.equals(WAITERMATE_TERMINAL) && !type.equals(SERVERMATE_TERMINAL)) {
            throw new IllegalArgumentException("Terminal type must be one of: WaiterMate, ServerMate");
        }
        localTerminalType = type;
        localUsername = System.getProperty("user.name");
        myTerminal = null;
    }

    public static boolean isLocalHostSetup() {
        return localTerminalType != null;
    }

    public static Terminal getLocalHostIfAvailable() {
        if (myTerminal.isExpanded()) {
            return (Terminal)myTerminal.get();
        }
        return null;
    }

    public static void collapseLocalHost() {
        myTerminal.collapse();
    }

    public static synchronized Terminal getLocalHost() {
        Terminal terminal;
        if (myTerminal == null || myTerminal.isNull()) {
            if (localTerminalType == null) {
                throw new IllegalStateException("Cannot call getLocalHost until setupLocalhost has been called");
            }
            try {
                ObjectQuery dummyCheck;
                List<Terminal> terminals;
                OrderMate.LOG.info("Local addressed:" + Arrays.toString(Terminal.returnLocalIpAddress()));
                ObjectQuery query = Query.select(Terminal.class).equals(Terminal.Properties.TERMINAL_TYPE, localTerminalType).active(Terminal.class).wherePropertyIn(Terminal.Properties.ADDRESS, Terminal.returnLocalIpAddress()).orderBy(Terminal.Properties.ID);
                if (localTerminalType.equals(WAITERMATE_TERMINAL) && (terminals = PersistenceManager.getObjectList(Terminal.class, (dummyCheck = query.copy()).toString())).size() > 1) {
                    HashSet<String> usernames = new HashSet<String>();
                    for (Terminal nextTerminal : terminals) {
                        String userName = nextTerminal.getUsername();
                        if (userName == null || userName.trim().isEmpty()) continue;
                        usernames.add(userName.trim().toLowerCase());
                    }
                    if (usernames.size() != terminals.size()) {
                        throw new IllegalStateException("Multiple WaiterMate Terminals for a single IP must have unique, non-empty usernames");
                    }
                    query.equals(Terminal.Properties.USERNAME, localUsername);
                }
                if ((myTerminal = new LocalCachedReference<Terminal>(new QueryReference<Terminal>(Terminal.class, query))).get() == null) {
                    OrderMate.LOG.error("Could not find terminal " + InetAddress.getLocalHost() + " in database");
                }
            }
            catch (UnknownHostException e1) {
                OrderMate.LOG.error("Could not find localhost: \n" + e1, (Throwable)e1);
            }
        }
        if ((terminal = (Terminal)myTerminal.get()) == null) {
            OrderMate.LOG.error("Could not find local host, unknown exception");
        }
        return terminal;
    }

    private static String[] returnLocalIpAddress() throws UnknownHostException {
        ArrayList<String> ips = new ArrayList<String>();
        for (InetAddress ipaddress : IPAddressUtils.getLocalAddresses()) {
            ips.add(ipaddress.getHostAddress());
        }
        return ips.toArray(new String[ips.size()]);
    }

    public static Terminal getServerMateTerminal() {
        if (servermateTerminal == null) {
            OrderMate.LOG.error("Cannot call getServerMateTerminal until setupServerMate has been called");
            throw new IllegalStateException("Servermate cannot be contacted. Please ensure Servermate is running and the necessary ports are open.");
        }
        return servermateTerminal;
    }

    public static void reacquireServerMateTerminal() {
        servermateTerminals.remove(servermateTerminal);
        servermateTerminal = (Terminal)PersistenceManager.reacquire(servermateTerminal);
        servermateTerminals.add(servermateTerminal);
    }

    public static List getTerminalsLinkedToArea(StockArea area) {
        Object[] params = new Object[]{area.getID()};
        return PersistenceManager.getObjectList(Terminal.class, "SELECT config_terminal.* FROM config_terminal WHERE FK_stock_area = ? AND config_terminal.system_state = 'ACTIVE' ", params);
    }

    public static Terminal getTerminal(InetAddress terminalAddress, String type) {
        if (terminalAddress == null) {
            return null;
        }
        if (SERVERMATE_TERMINAL.equals(type)) {
            for (Terminal server : servermateTerminals) {
                if (!terminalAddress.getHostAddress().equals(server.getIPAddress()) && !terminalAddress.getHostName().equals(server.getIPAddress())) continue;
                return server;
            }
            OrderMate.LOG.warn("Couldn't find Servermate Terminal in cache, using Persistence:" + terminalAddress + " " + servermateTerminals);
        }
        return Terminal.getTerminalByIp(terminalAddress.getHostAddress(), type);
    }

    public static Terminal getTerminalByIp(String ipAddress, String type) {
        String sql = "SELECT config_terminal.* FROM config_terminal WHERE ipaddress = ? AND type = ? AND system_state = 'ACTIVE' ORDER BY ID";
        Terminal terminal = PersistenceManager.getObject(Terminal.class, sql, new Object[]{ipAddress, type});
        return terminal;
    }

    public static Terminal getWMT1() {
        String sql = "SELECT config_terminal.* FROM config_terminal WHERE config_terminal.system_state = 'ACTIVE' AND type = 'WaiterMate' AND (name = 'WMT1' OR name = 'ORDERMATE') LIMIT 1 ";
        Terminal WMT1 = PersistenceManager.getObject(Terminal.class, sql, new Object[0]);
        return WMT1;
    }

    @Column(name="tabbed_menu_ordering")
    public boolean isTabbedMenuOrdering() {
        return this.tabbedMenuOrdering;
    }

    @Column(name="quick_sale_tabbed_menu_ordering")
    public boolean isQuickSaleTabbedMenuOrdering() {
        return this.quickSaleTabbedMenuOrdering;
    }

    @Column(name="quick_sale_single_screen_ordering")
    public boolean getQuickSaleSingleScreenOrdering() {
        return this.quickSaleSingleScreenOrdering;
    }

    @Column(name="single_screen_ordering")
    public boolean getSingleScreenOrdering() {
        return this.singleScreenOrdering;
    }

    @Column(name="forced_options")
    public boolean getForcedOptions() {
        return this.forcedOptions;
    }

    @Column(name="print_prep_as_ordering")
    public boolean getPrintPrepAsOrdering() {
        return this.printPrepAsOrdering;
    }

    @Column(name="quick_sale_menu_width")
    public int getQuickSaleMenuWidth() {
        if (this.quickSaleMenuWidth <= 0 || this.quickSaleMenuWidth > 95) {
            this.quickSaleMenuWidth = 25;
        }
        return this.quickSaleMenuWidth;
    }

    public boolean hasDriveThruMode() {
        boolean hasDriveThru = false;
        Iterator it = this.terminalModes.iterator();
        while (it.hasNext() && !hasDriveThru) {
            TerminalMode mode = (TerminalMode)it.next();
            if (!mode.getMode().equals("Drive Thru")) continue;
            hasDriveThru = true;
        }
        return hasDriveThru;
    }

    public boolean hasDebtorsMode() {
        boolean hasDebtors = false;
        Iterator it = this.terminalModes.iterator();
        while (it.hasNext() && !hasDebtors) {
            TerminalMode mode = (TerminalMode)it.next();
            if (!mode.getMode().equals("Debtors")) continue;
            hasDebtors = true;
        }
        return hasDebtors;
    }

    @OneToMany(mappedBy="terminal", targetEntity=TerminalMode.class)
    public List<TerminalMode> getTerminalModes() {
        return this.terminalModes.getUnmodifiable();
    }

    @Column(name="sticky_plus_minus")
    public boolean getStickyPlusMinus() {
        return this.stickyPlusMinus;
    }

    @Override
    public void save() {
        if (this.loadedLocation != null && !this.loadedLocation.equals(this.location.get())) {
            String currentLocationLabel = this.loadedLocation.getLabel();
            OrderMate.LOG.info("Changing terminal location from " + currentLocationLabel + " to " + this.getLocation().getLabel());
            SystemCurrentInfo.setUpdate("Terminal Location Change");
        }
        PersistenceManager.save(this);
        this.loadedLocation = this.location.get();
        this.terminalModes.saveChild();
        this.screenLayoutSet.saveChild();
        if (WAITERMATE_TERMINAL.equals(this.terminalType)) {
            this.createQuickSaleNavConfigIfNecessary();
        } else if (!this.terminalType.equals(WAITERMATE_TERMINAL)) {
            this.quickSaleNavConfig.set(null);
        }
        this.getTerminalCacheListManager().clearCache();
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Override
    public void delete() {
        this.systemState = "DELETED";
        ((PersistentWriteableList)this.decrementStockAreas).deleteChild();
        PersistenceManager.save(this);
    }

    public void setQuickSaleQtyKeyPad(boolean theQuickSaleQtyKeyPad) {
        this.quickSaleQtyKeyPad = theQuickSaleQtyKeyPad;
    }

    @Column(name="quicksale_qty_keypad")
    public boolean getQuickSaleQtyKeyPad() {
        return this.quickSaleQtyKeyPad;
    }

    @Column(name="pay_to_tab_debtor")
    public boolean getPayTabDebtor() {
        return this.payTabDebtor;
    }

    @Transient
    public String getName() {
        return this.getLabel() + " (" + this.getTerminalType() + ")";
    }

    public static final List<String> getTerminalTypes() {
        ArrayList<String> types = new ArrayList<String>();
        types.add(WAITERMATE_TERMINAL);
        types.add(SERVERMATE_TERMINAL);
        types.add(INTEGRATION_TERMINAL);
        return types;
    }

    public void setHasMenuKeypad(boolean menuKeypad) {
        this.hasMenuKeypad = menuKeypad;
    }

    public void setStickyMenu(boolean sticky) {
        this.stickyMenu = sticky;
    }

    public void setHasBarcodes(boolean barcodes) {
        this.hasBarcodes = barcodes;
    }

    public void setBistroMode(boolean newBistroMode) {
        this.bistroMode = newBistroMode;
    }

    public void setHasAssignedCashdrawers(boolean assignedCashdrawers) {
        this.hasAssignedCashdrawers = assignedCashdrawers;
    }

    public void setHasAutoMenuSelect(boolean autoMenuSelect) {
        this.hasAutoMenuSelect = autoMenuSelect;
    }

    public void setSeatNums(boolean seatNumbers) {
        this.seatNums = seatNumbers;
    }

    public void setMenuCaching(boolean caching) {
        this.menuCaching = caching;
    }

    public void setSaveButtonEnabled(boolean saveEnabled) {
        this.saveButtonEnabled = saveEnabled;
    }

    public void setShowPin(boolean pin) {
        this.showPin = pin;
    }

    public void setQuickDiscount(boolean newQuickDiscount) {
        this.quickDiscount = newQuickDiscount;
    }

    public void setManuallyPrintPrep(boolean newManuallyPrintPrep) {
        this.manuallyPrintPrep = newManuallyPrintPrep;
    }

    public void setQuickSeatSelect(boolean newQuickSeatSelect) {
        this.quickSeatSelect = newQuickSeatSelect;
    }

    public void setQuickCustomer(boolean newQuickCustomer) {
        this.quickCustomer = newQuickCustomer;
    }

    public void setQuicksaleBistroMode(boolean quicksaleBistroMode) {
        this.quicksaleBistroMode = quicksaleBistroMode;
    }

    public void setSkimming(boolean newSkimming) {
        this.skimming = newSkimming;
    }

    public void setTabbedMenuOrdering(boolean newTabbedMenuOrdering) {
        this.tabbedMenuOrdering = newTabbedMenuOrdering;
    }

    public void setQuickSaleTabbedMenuOrdering(boolean newQuickSaleTabbedMenuOrdering) {
        this.quickSaleTabbedMenuOrdering = newQuickSaleTabbedMenuOrdering;
    }

    public void setForcedOptions(boolean newForcedOptions) {
        this.forcedOptions = newForcedOptions;
    }

    public void setPrintPrepAsOrdering(boolean newPrintPrepAsOrdering) {
        this.printPrepAsOrdering = newPrintPrepAsOrdering;
    }

    public void setQuickSaleMenuWidth(int newQuickSaleMenuWidth) {
        if (newQuickSaleMenuWidth <= 0 || newQuickSaleMenuWidth > 95) {
            this.quickSaleMenuWidth = 25;
        }
        this.quickSaleMenuWidth = newQuickSaleMenuWidth;
    }

    public void setStickyPlusMinus(boolean newStickyPlusMinus) {
        this.stickyPlusMinus = newStickyPlusMinus;
    }

    public void setQuickSaleSingleScreenOrdering(boolean newQuickSaleSingleScreenOrdering) {
        this.quickSaleSingleScreenOrdering = newQuickSaleSingleScreenOrdering;
    }

    public void setSingleScreenOrdering(boolean newSingleScreenOrdering) {
        this.singleScreenOrdering = newSingleScreenOrdering;
    }

    public void setPayTabDebtor(boolean newPayTabDebtor) {
        this.payTabDebtor = newPayTabDebtor;
    }

    @Column(name="show_quick_order_info_button")
    @Deprecated
    public boolean isShowQuickOrderInfoButton() {
        return this.showQuickOrderInfoButton;
    }

    public boolean showQuickOrderInfoButton() {
        for (QuickSaleNavInfo button : this.getQuickSaleNavConfig().getNavButtons()) {
            if (!"Order Info".equals(button.getButtonName())) continue;
            return button.isActive();
        }
        return false;
    }

    @Deprecated
    public void setShowQuickOrderInfoButton(boolean newShowQuickOrderInfoButton) {
        this.showQuickOrderInfoButton = newShowQuickOrderInfoButton;
    }

    public void setAutoLogoutDelay(int autoLogoutDelaySec) {
        this.autoLogoutDelay = autoLogoutDelaySec;
    }

    @Column(name="auto_logout_delay_sec")
    public int getAutoLogoutDelay() {
        return this.autoLogoutDelay;
    }

    public void setBackToIdleTimeout(int backToIdleTimeout) {
        this.backToIdleTimeout = backToIdleTimeout;
    }

    @Column(name="back_to_idle_sec")
    public int getBackToIdleTimeout() {
        return this.backToIdleTimeout;
    }

    public void setAutoLogoutCountDown(int theAutoLogoutCountDown) {
        this.autoLogoutCountDown = theAutoLogoutCountDown;
    }

    @Column(name="auto_logout_countdown_sec")
    public int getAutoLogoutCountDown() {
        return this.autoLogoutCountDown;
    }

    public void setAutoSavePaidAccDelay(int theAutoSavePaidAccDelay) {
        this.autoSavePaidAccDelay = theAutoSavePaidAccDelay;
    }

    @Column(name="auto_save_account_delay_sec")
    public int getAutoSavePaidAccDelay() {
        return this.autoSavePaidAccDelay;
    }

    public void setAutoSavePaidAccCountDown(int theAutoSavePaidAccCountDown) {
        this.autoSavePaidAccCountDown = theAutoSavePaidAccCountDown;
    }

    @Column(name="auto_save_account_countdown_sec")
    public int getAutoSavePaidAccCountDown() {
        return this.autoSavePaidAccCountDown;
    }

    public void deleteTerminalMode(TerminalMode deletedMode) {
        this.terminalModes.remove(deletedMode);
    }

    public void addTerminalMode(TerminalMode theMode) {
        this.terminalModes.add(theMode);
    }

    public void setTerminalModes(List<TerminalMode> modes) {
        this.terminalModes.clear();
        this.terminalModes.addAll(modes);
    }

    @Column(name="show_quantity")
    public boolean isShowQuantity() {
        return this.showQuantity;
    }

    public void setShowQuantity(boolean theShowQuantity) {
        this.showQuantity = theShowQuantity;
    }

    @Column(name="quick_sale_show_quantity")
    public boolean isQuickSaleShowQuantity() {
        return this.quickSaleShowQuantity;
    }

    public void setQuickSaleShowQuantity(boolean theQuickSaleShowQuantity) {
        this.quickSaleShowQuantity = theQuickSaleShowQuantity;
    }

    @Column(name="quick_sale_one_touch")
    public boolean isQuickSaleOneTouch() {
        return this.quickSaleOneTouch;
    }

    public void setQuickSaleOneTouch(boolean theQuickSaleOneTouch) {
        this.quickSaleOneTouch = theQuickSaleOneTouch;
    }

    @Column(name="show_make_combo_in_nav")
    public boolean isShowMakeComboInNav() {
        return this.showMakeComboInNav;
    }

    public void setShowMakeComboInNav(boolean value) {
        this.showMakeComboInNav = value;
    }

    public void setAutoPrintOnAdjustment(VirtualPrinter printer) {
        this.autoPrintOnAdjustment.set(printer);
    }

    @ManyToOne
    @JoinColumn(name="FK_config_virtual_printer_auto_adjustment")
    public VirtualPrinter getAutoPrintOnAdjustment() {
        return this.autoPrintOnAdjustment.get();
    }

    public void setAutoPrintOnDelete(VirtualPrinter printer) {
        this.autoPrintOnDelete.set(printer);
    }

    @ManyToOne
    @JoinColumn(name="FK_config_virtual_printer_auto_delete")
    public VirtualPrinter getAutoPrintOnDelete() {
        return this.autoPrintOnDelete.get();
    }

    public boolean isShowQuantity(boolean quickSaleMode) {
        if (quickSaleMode) {
            return this.isQuickSaleShowQuantity();
        }
        return this.isShowQuantity();
    }

    public boolean isTabbedMenuOrdering(boolean quickSaleMode) {
        if (quickSaleMode) {
            return this.isQuickSaleTabbedMenuOrdering();
        }
        return this.isTabbedMenuOrdering();
    }

    @Column(name="dark_logo")
    public boolean isDarkLogo() {
        return this.darkLogo;
    }

    public void setDarkLogo(boolean value) {
        this.darkLogo = value;
    }

    @Column(name="show_quantity_keypad")
    public boolean isShowQuantityKeypad() {
        return this.showQuantityKeypad;
    }

    public void setShowQuantityKeypad(boolean value) {
        this.showQuantityKeypad = value;
    }

    public void setQuickSaleQuickTransfer(boolean quickTransfer) {
        this.quickSaleQuickTransfer = quickTransfer;
    }

    @Column(name="quick_sale_quick_transfer")
    public boolean isQuickSaleQuickTransfer() {
        return this.quickSaleQuickTransfer;
    }

    @Transient
    private InetAddress getInetAddress() {
        if (this.address != null) {
            try {
                this.inetAddressCache = InetAddress.getByName(this.address);
                return this.inetAddressCache;
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return null;
    }

    @Column(name="bistro")
    public boolean isBistroMode() {
        return this.bistroMode;
    }

    protected void setShift(Shift newShift) {
        this.shift.set(newShift);
    }

    @Column(name="bistro_keep_open")
    public boolean isBistroKeepOpen() {
        return this.bistroKeepOpen;
    }

    public void setBistroKeepOpen(boolean value) {
        this.bistroKeepOpen = value;
    }

    public void changeShift(Shift newShift) {
        this.shift.set(newShift);
    }

    protected void setAvailablePoleDisplays(List newAvailablePoleDisplays) {
        this.availablePoleDisplays = this.availablePoleDisplays.clone();
        this.availablePoleDisplays.set(newAvailablePoleDisplays);
    }

    protected void setAvailableReceiptPrinters(List newAvailableReceiptPrinters) {
        this.availableReceiptPrinters = this.availableReceiptPrinters.clone();
        this.availableReceiptPrinters.set(newAvailableReceiptPrinters);
    }

    protected void setConnectedCashDrawers(List<CashDrawer> newConnectedCashDrawers) {
        this.connectedCashDrawers = this.connectedCashDrawers.clone();
        this.connectedCashDrawers.set(newConnectedCashDrawers);
    }

    protected void setConnectedPrinters(List<PhysicalPrinter> newConnectedPrinters) {
        this.connectedPrinters = this.connectedPrinters.clone();
        this.connectedPrinters.set(newConnectedPrinters);
    }

    protected void setAvailableCamera(List newAvailableCamera) {
        this.availableCamera = this.availableCamera.clone();
        this.availableCamera.set(newAvailableCamera);
    }

    @Transient
    protected List<DecrementStockArea> getDecrementStockAreas() {
        return this.decrementStockAreas;
    }

    protected void setDecrementStockAreas(List<DecrementStockArea> newDecrementStockAreas) {
        this.decrementStockAreas = this.decrementStockAreas.clone();
        this.decrementStockAreas.set(newDecrementStockAreas);
    }

    public void setSystemState(String newSystemState) {
        this.systemState = newSystemState;
    }

    @Column(name="integrate_ordatronics")
    protected boolean isHasOrdatronicsIntegration() {
        return this.hasOrdatronicsIntegration;
    }

    protected void setHasOrdatronicsIntegration(boolean newHasOrdatronicsIntegration) {
        this.hasOrdatronicsIntegration = newHasOrdatronicsIntegration;
    }

    protected void setAvailableCallerIDUnits(List<CallerIDUnit> newAvailableCallerIDUnits) {
        this.availableCallerIDUnits = this.availableCallerIDUnits.clone();
        this.availableCallerIDUnits.set(newAvailableCallerIDUnits);
    }

    protected void setAddress(String newAddress) {
        this.address = newAddress;
    }

    protected void setAvailableLogicallyConnectedCashDrawers(List newAvailableLogicallyConnectedCashDrawers) {
        this.availableLogicallyConnectedCashDrawers = this.availableLogicallyConnectedCashDrawers.clone();
        this.availableLogicallyConnectedCashDrawers.set(newAvailableLogicallyConnectedCashDrawers);
    }

    protected void setAvailableProximityReaders(List<ProximityReader> newAvailableProximityReaders) {
        this.availableProximityReaders = this.availableProximityReaders.clone();
        this.availableProximityReaders.set(newAvailableProximityReaders);
    }

    @Column(name="username")
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String value) {
        this.username = value;
    }

    @Column(name="general_manual_print_prep")
    public boolean isGeneralManualPrintPrep() {
        return this.generalManualPrintPrep;
    }

    public void setGeneralManualPrintPrep(boolean value) {
        this.generalManualPrintPrep = value;
    }

    public void setUnallocatedTableAllowed(boolean newUnallocatedTableAllowed) {
        this.unallocatedTableAllowed = newUnallocatedTableAllowed;
    }

    @Column(name="unallocated_table_mode")
    public boolean isUnallocatedTableAllowed() {
        return this.unallocatedTableAllowed;
    }

    @Column(name="defer_unallocated_table_prep_dockets")
    public boolean isDeferUnallocatedTablePrepDockets() {
        return this.deferUnallocatedTablePrepDockets;
    }

    public void setDeferUnallocatedTablePrepDockets(boolean defer) {
        this.deferUnallocatedTablePrepDockets = defer;
    }

    public void setLookAndFeelClassName(String lafClassName) {
        this.lookAndFeelClassName = lafClassName;
    }

    @Column(name="look_and_feel_class_name")
    public String getLookAndFeelClassName() {
        return this.lookAndFeelClassName;
    }

    @Column(name="gui_font_size")
    public int getGuiFontSize() {
        return this.guiFontSize;
    }

    public void setGuiFontSize(int size) {
        this.guiFontSize = size;
    }

    public void setHoldTable(boolean hold) {
        this.holdTable = hold;
    }

    @Column(name="hold_table")
    public boolean isHoldTable() {
        return this.holdTable;
    }

    public void setMinimumDeliveryOrder(Price minDelivery) {
        if (minDelivery == null || minDelivery.lessThan(Price.ZERO_DOLLAR)) {
            throw new IllegalArgumentException("You must specify a minimum delivery to set.");
        }
        this.minimumDeliveryOrder = minDelivery;
    }

    @Column(name="minimum_delivery_order", nullable=false)
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0.01")})
    public Price getMinimumDeliveryOrder() {
        return this.minimumDeliveryOrder == null ? Price.ZERO_DOLLAR : this.minimumDeliveryOrder;
    }

    public void setPreviousSalesQuickSale(boolean quickSales) {
        this.previousSalesQuickSale = quickSales;
    }

    @Column(name="previous_sales_quicksale")
    public boolean isPreviousSalesQuickSale() {
        return this.previousSalesQuickSale;
    }

    public void setPreviousSalesTable(boolean tableSales) {
        this.previousSalesTable = tableSales;
    }

    @Column(name="previous_sales_table")
    public boolean isPreviousSalesTable() {
        return this.previousSalesTable;
    }

    public void setPreviousSalesPhone(boolean phoneSales) {
        this.previousSalesPhone = phoneSales;
    }

    @Column(name="previous_sales_phone")
    public boolean isPreviousSalesPhone() {
        return this.previousSalesPhone;
    }

    public void setPreviousSalesTakeaway(boolean takeawaySales) {
        this.previousSalesTakeaway = takeawaySales;
    }

    @Column(name="previous_sales_takeaway")
    public boolean isPreviousSalesTakeaway() {
        return this.previousSalesTakeaway;
    }

    public void setPreviousSalesOnline(boolean value) {
        this.previousSalesOnline = value;
    }

    @Column(name="previous_sales_online")
    public boolean isPreviousSalesOnline() {
        return this.previousSalesOnline;
    }

    public boolean isShowPreviousSales(AccountType type) {
        if (AccountType.takeawayType.equals(type)) {
            return this.isPreviousSalesQuickSale();
        }
        if (AccountType.tableType.equals(type)) {
            return this.isPreviousSalesTable();
        }
        if (AccountType.phoneType.equals(type)) {
            return this.isPreviousSalesPhone();
        }
        if (AccountType.onlineDeliveryType.equals(type) || AccountType.onlinePickupType.equals(type)) {
            return this.isPreviousSalesOnline();
        }
        return false;
    }

    public boolean isShowPreviousSales(List<AccountType> types) {
        boolean showPreviousSales = false;
        for (AccountType type : types) {
            showPreviousSales |= Terminal.getLocalHost().isShowPreviousSales(type);
        }
        return showPreviousSales;
    }

    public void setHoldTakeaway(boolean holdIt) {
        this.holdTakeaway = holdIt;
    }

    @Column(name="hold_takeaway")
    public boolean isHoldTakeaway() {
        return this.holdTakeaway;
    }

    @Column(name="fingerprint_scanner")
    public boolean isFingerprintScanner() {
        return this.fingerprintScanner;
    }

    public void setFingerprintScanner(boolean value) {
        this.fingerprintScanner = value;
    }

    @Column(name="use_onscreen_keyboard")
    public boolean isUseOnscreenKeyboard() {
        return this.useOnscreenKeyboard;
    }

    public void setUseOnscreenKeyboard(boolean value) {
        this.useOnscreenKeyboard = value;
    }

    public void setCameraLayout(String value) {
        this.cameraLayout = value;
    }

    @Column(name="camera_layout")
    public String getCameraLayout() {
        return this.cameraLayout;
    }

    @JoinColumn(name="fk_config_gui_set")
    @ManyToOne
    public GuiConfigSet getScreenLayoutSet() {
        return this.screenLayoutSet.get();
    }

    public void setScreenLayoutSet(GuiConfigSet screenLayoutSet) {
        this.screenLayoutSet.set(screenLayoutSet);
    }

    @Column(name="waitermate_posiflex_reader_enabled")
    public boolean isPosiflexReaderEnabled() {
        return this.posiflexReaderEnabled;
    }

    public void setPosiflexReaderEnabled(boolean posiflexReaderEnabled) {
        this.posiflexReaderEnabled = posiflexReaderEnabled;
    }

    @Override
    @Transient
    public String getRebootableDeviceIPAddress() {
        return this.getIPAddress();
    }

    @Override
    @Transient
    public String getRebootableDeviceName() {
        return this.getName();
    }

    @Override
    @Transient
    public Integer getRebootableRMIPort() {
        return this.getRmiPort();
    }

    @Override
    @Transient
    public InetAddress getRebootableAddress() {
        return this.getAddress();
    }

    @Column(name="custom_button_flash_time")
    public Integer getCustomButtonFlashTime() {
        return this.customButtonFlashTime;
    }

    public void setCustomButtonFlashTime(Integer customButtonFlashTime) {
        this.customButtonFlashTime = customButtonFlashTime;
    }

    @Column(name="takeaway_stand_name")
    public boolean isTakeawayStandName() {
        return this.takeawayStandName;
    }

    public void setTakeawayStandName(boolean takeawayStandName) {
        this.takeawayStandName = takeawayStandName;
    }

    @Column(name="takeaway_stand_num")
    public boolean isTakeawayStandNum() {
        return this.takeawayStandNum;
    }

    public void setTakeawayStandNum(boolean takeawayStandNum) {
        this.takeawayStandNum = takeawayStandNum;
    }

    public void setQuicksaleTakeawayStandName(boolean shownName) {
        this.quicksaleTakeawayStandName = shownName;
    }

    public void setQuicksaleTakeawayStandNum(boolean stand) {
        this.quicksaleTakeawayStandNum = stand;
    }

    @Column(name="quicksale_takeaway_stand_name")
    public boolean isQuicksaleTakeawayStandName() {
        return this.quicksaleTakeawayStandName;
    }

    @Column(name="quicksale_takeaway_stand_num")
    public boolean isQuicksaleTakeawayStandNum() {
        return this.quicksaleTakeawayStandNum;
    }

    @Column(name="quicksale_dinein_stand_name")
    public boolean isQuicksaleDineinStandName() {
        return this.quicksaleDineinStandName;
    }

    public void setQuicksaleDineinStandName(boolean dineinStandName) {
        this.quicksaleDineinStandName = dineinStandName;
    }

    @Column(name="quicksale_dinein_stand_num")
    public boolean isQuicksaleDineinStandNum() {
        return this.quicksaleDineinStandNum;
    }

    public void setQuicksaleDineinStandNum(boolean dineinStandNum) {
        this.quicksaleDineinStandNum = dineinStandNum;
    }

    @Column(name="auto_prompt_TA")
    public boolean isAutoPromptTA() {
        return this.autoPromptTA;
    }

    public void setAutoPromptTA(boolean autoPromptTA) {
        this.autoPromptTA = autoPromptTA;
    }

    @Column(name="auto_prompt_QS")
    public boolean isAutoPromptQS() {
        return this.autoPromptQS;
    }

    public void setAutoPromptQS(boolean autoPromptQS) {
        this.autoPromptQS = autoPromptQS;
    }

    public void setBartabPreauth(boolean value) {
        this.bartabPreauth = value;
    }

    @Column(name="bartab_preauth")
    public boolean isBartabPreauth() {
        return this.bartabPreauth;
    }

    @Column(name="login_animating")
    public boolean isLoginAnimating() {
        return this.loginAnimating;
    }

    public void setLoginAnimating(boolean disableLoginAnimation) {
        this.loginAnimating = disableLoginAnimation;
    }

    @Column(name="show_online")
    public boolean isShowOnline() {
        return this.showOnline;
    }

    public void setShowOnline(boolean value) {
        this.showOnline = value;
    }

    @Column(name="ticket_data_config")
    @Enumerated(value=EnumType.STRING)
    public TicketDataConfig getTicketDataConfig() {
        return this.ticketDataConfig;
    }

    public void setTicketDataConfig(TicketDataConfig ticketDataConfig) {
        if (ticketDataConfig == null) {
            OrderMate.LOG.warn("Someone was setting the terminal's ticket data config to null! Setting it to no account type. " + Thread.currentThread().getStackTrace());
            this.ticketDataConfig = TicketDataConfig.NoAccountTypePrompt;
        } else {
            this.ticketDataConfig = ticketDataConfig;
        }
    }

    static {
        servermateTerminals = new HashSet<Terminal>();
    }

    public static class Props
    extends PersistentDisplayableObject.Props {
        public PropertiedObject.Property<CashDrawer> AVAILABLE_LOGICALLY_CONNECTED_CASHDRAWERS;
        public PropertiedObject.Property<ProximityReader> AVAILABLE_PROXIMITY_READERS;
        public PropertiedObject.Property<CashDrawer> CONNECTED_CASHDRAWERS;
        public PropertiedObject.Property<PhysicalPrinter> CONNECTED_PRINTERS;
        public PropertiedObject.Property<CallerIDUnit> AVAILABLE_CALLER_ID_UNITS;
        public PropertiedObject.Property<PoleDisplay> AVAILABLE_POLE_DISPLAYS;
        public PropertiedObject.Property<VirtualPrinter> AVAILABLE_RECEIPT_PRINTERS;
        public PropertiedObject.Property<Camera> AVAILABLE_CAMERA;
        public PropertiedObject.Property<TerminalLocation> LOCATION;
        public PropertiedObject.Property<TerminalLocation> DEFAULT_LOCATION;
        public PropertiedObject.Property<SalesLocation> SALES_LOCATION;
        public PropertiedObject.Property<SalesLocation> DEFAULT_SALES_LOCATION;
        public PropertiedObject.Property<StockArea> STOCK_AREA;
        public PropertiedObject.Property QUICK_LOGOUT;
        public PropertiedObject.Property SHOW_PIN;
        public PropertiedObject.Property SAVE_BUTTON_ENABLED;
        public PropertiedObject.Property SEAT_NUMS;
        public PropertiedObject.Property<GTL> GTL;
        public PropertiedObject.Property<ColourWheel.Palette> PALETTE;
        public PropertiedObject.Property HAS_AUTO_MENU_SELECT;
        public PropertiedObject.Property MENU_CACHING;
        public PropertiedObject.Property HAS_ASSIGNED_CASHDRAWERS;
        public PropertiedObject.Property BISTRO_MODE;
        public PropertiedObject.Property BISTRO_KEEP_OPEN;
        public PropertiedObject.Property HAS_BARCODES;
        public PropertiedObject.Property HAS_ORDATRONICS_INTEGRATION;
        public PropertiedObject.Property STICKY_MENU;
        public PropertiedObject.Property HAS_MENU_KEYPAD;
        public PropertiedObject.Property<String> TERMINAL_TYPE;
        public PropertiedObject.Property ADDRESS;
        public PropertiedObject.Property QUICK_DISCOUNT;
        public PropertiedObject.Property MANUALLY_PRINT_PREP;
        public PropertiedObject.Property<Shift> SHIFT;
        public PropertiedObject.Property QUICK_SEAT_SELECT;
        public PropertiedObject.Property QUICK_CUSTOMER;
        public PropertiedObject.Property QUICKSALE_BISTRO_MODE;
        public PropertiedObject.Property SKIMMING;
        public PropertiedObject.Property<String> SYSTEM_STATE;
        public PropertiedObject.Property TABBED_MENU_ORDERING;
        public PropertiedObject.Property FORCED_OPTIONS;
        public PropertiedObject.Property PRINT_PREP_AS_ORDERING;
        public PropertiedObject.Property QUICK_SALE_MENU_WIDTH;
        public PropertiedObject.Property<TerminalMode> TERMINAL_MODES;
        public PropertiedObject.Property STICKY_PLUS_MINUS;
        public PropertiedObject.Property QUICK_SALE_SINGLE_SCREEN_ORDERING;
        public PropertiedObject.Property QUICKSALE_QTY_KEYPAD;
        public PropertiedObject.Property SHOW_QUANTITY_KEYPAD;
        public PropertiedObject.Property PAY_TAB_DEBTOR;
        public PropertiedObject.Property SINGLE_SCREEN_ORDERING;
        public PropertiedObject.Property SHOW_QUICK_ORDER_INFO_BUTTON;
        public PropertiedObject.Property AUTO_SAVE_PAID_ACC_DELAY;
        public PropertiedObject.Property AUTO_SAVE_PAID_ACC_COUNT_DOWN;
        public PropertiedObject.Property AUTO_LOGOUT_DELAY;
        public PropertiedObject.Property BACK_TO_IDLE_TIMEOUT;
        public PropertiedObject.Property AUTO_LOGOUT_COUNT_DOWN;
        public PropertiedObject.Property SHOW_QUANTITY;
        public PropertiedObject.Property QUICK_SALE_SHOW_QUANTITY;
        public PropertiedObject.Property QUICK_SALE_ONE_TOUCH;
        public PropertiedObject.Property<DecrementStockArea> DECREMENT_STOCK_AREAS;
        public PropertiedObject.Property PROMPT_FOR_CUSTOM_DISCOUNT_REASON;
        public PropertiedObject.Property SHOW_MAKE_COMBO_IN_NAV;
        public PropertiedObject.Property QUICK_SALE_TABBED_MENU_ORDERING;
        public PropertiedObject.Property QUICK_SALE_QUICK_TRANSFER;
        public PropertiedObject.Property<VirtualPrinter> AUTO_PRINT_ON_DELETE;
        public PropertiedObject.Property<VirtualPrinter> AUTO_PRINT_ON_ADJUSTMENT;
        public PropertiedObject.Property DARK_LOGO;
        public PropertiedObject.Property USERNAME;
        public PropertiedObject.Property GENERAL_MANUAL_PRINT_PREP;
        public PropertiedObject.Property UNALLOCATED_TABLE_ALLOWED;
        public PropertiedObject.Property DEFER_UNALLOCATED_TABLE_PREP_DOCKETS;
        public PropertiedObject.Property TABLE_TICKET_DATA_NAME;
        public PropertiedObject.Property HOLD_TABLE;
        public PropertiedObject.Property HOLD_TAKEAWAY;
        public PropertiedObject.Property LOOK_AND_FEEL_CLASS_NAME;
        public PropertiedObject.Property GUI_FONT_SIZE;
        public PropertiedObject.Property<Price> MINIMUM_DELIVERY_ORDER;
        public PropertiedObject.Property PREVIOUS_SALES_QUICKSALE;
        public PropertiedObject.Property PREVIOUS_SALES_TABLE;
        public PropertiedObject.Property PREVIOUS_SALES_PHONE;
        public PropertiedObject.Property PREVIOUS_SALES_TAKEAWAY;
        public PropertiedObject.Property PREVIOUS_SALES_ONLINE;
        public PropertiedObject.Property FINGERPRINT_SCANNER;
        public PropertiedObject.Property<QuickSaleNavConfig> QUICK_SALE_NAV_CONFIG;
        public PropertiedObject.Property USE_ONSCREEN_KEYBOARD;
        public PropertiedObject.Property CAMERA_LAYOUT;
        public PropertiedObject.Property<GuiConfigSet> SCREEN_LAYOUT_SET;
        public PropertiedObject.Property<Integer> RMI_PORT;
        public PropertiedObject.Property POSIFLEX_READER_ENABLED;
        public PropertiedObject.Property<Integer> CUSTOM_BUTTON_FLASH_TIME;
        public PropertiedObject.Property BARTAB_PREAUTH;
        public PropertiedObject.Property LOGIN_ANIMATING;
        public PropertiedObject.Property<TicketDataConfig> TICKET_DATA_CONFIG;
        public PropertiedObject.Property<Boolean> TAKEAWAY_STAND_NAME;
        public PropertiedObject.Property<Boolean> TAKEAWAY_STAND_NUM;
        public PropertiedObject.Property<Boolean> QUICKSALE_TAKEAWAY_STAND_NAME;
        public PropertiedObject.Property<Boolean> QUICKSALE_TAKEAWAY_STAND_NUM;
        public PropertiedObject.Property<Boolean> QUICKSALE_DINEIN_STAND_NAME;
        public PropertiedObject.Property<Boolean> QUICKSALE_DINEIN_STAND_NUM;
        public PropertiedObject.Property<Boolean> AUTO_PROMPT_TA;
        public PropertiedObject.Property<Boolean> AUTO_PROMPT_QS;
        public PropertiedObject.Property<Boolean> SHOW_ONLINE;
    }
}

