/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.hardware;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.SaveableChild;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import ordermate.database.hardware.Terminal;
import org.hibernate.annotations.AccessType;

@Entity
@Table(name="config_terminal_mode")
@AccessType(value="property")
public class TerminalMode
extends PersistentObject
implements SaveableChild {
    public static final String TABLE_MODE = "Tables";
    public static final String PHONE_MODE = "Phone";
    public static final String PHONE_WITH_DELIVERY_MODE = "Phone with Delivery";
    public static final String TAKEAWAY_MODE = "Takeaway";
    public static final String DRIVE_THRU_MODE = "Drive Thru";
    public static final String QUICKSALE_MODE = "Quick Sale";
    public static final String BAR_TAB_MODE = "Bar Tabs";
    public static final String DEBTORS_MODE = "Debtors";
    public static final String ONLINE_MODE = "Online";
    public static final String DELIVERY = "Delivery";
    public static final Props Properties = new Props();
    private Reference<Terminal> terminal;
    private String mode;
    private int sequence;
    private String label;
    private static List allTerminalModes;

    public TerminalMode() {
        this.terminal = this.createReference(TerminalMode.Properties.TERMINAL);
        this.sequence = 0;
        this.label = "";
    }

    public TerminalMode(String theMode) {
        this.terminal = this.createReference(TerminalMode.Properties.TERMINAL);
        this.sequence = 0;
        this.label = "";
        this.setMode(theMode);
        this.setSequence(TerminalMode.getAllModes().indexOf(theMode));
    }

    protected TerminalMode(TerminalMode terminalMode) {
        this.terminal = this.createReference(TerminalMode.Properties.TERMINAL);
        this.sequence = 0;
        this.label = "";
        this.setMode(terminalMode.getMode());
        this.setSequence(terminalMode.getSequence());
    }

    @Column(name="label")
    public String getLabel() {
        if (this.label == null || this.label.isEmpty()) {
            if (this.mode != null && this.mode.equals(PHONE_WITH_DELIVERY_MODE)) {
                return PHONE_MODE;
            }
            return this.mode;
        }
        return this.label;
    }

    public void setLabel(String newLabel) {
        this.label = newLabel;
    }

    public void setMode(String theMode) {
        if (!TerminalMode.getAllModes().contains(theMode)) {
            throw new IllegalStateException(theMode + " is not a valid ordering mode");
        }
        this.mode = theMode;
    }

    @ManyToOne
    @JoinColumn(name="FK_config_terminal")
    public Terminal getTerminal() {
        return this.terminal.get();
    }

    public void setTerminal(Terminal theTerminal) {
        this.terminal.set(theTerminal);
    }

    public void setSequence(int newSeq) {
        this.sequence = newSeq;
    }

    @Column(name="sequence")
    public int getSequence() {
        return this.sequence;
    }

    @Column(name="mode")
    public String getMode() {
        return this.mode;
    }

    public static List getAllModes() {
        if (allTerminalModes == null) {
            ArrayList<String> allModes = new ArrayList<String>();
            allModes.add(TABLE_MODE);
            allModes.add(PHONE_MODE);
            allModes.add(PHONE_WITH_DELIVERY_MODE);
            allModes.add(DELIVERY);
            allModes.add(ONLINE_MODE);
            allModes.add(TAKEAWAY_MODE);
            allModes.add(DRIVE_THRU_MODE);
            allModes.add(QUICKSALE_MODE);
            allModes.add(BAR_TAB_MODE);
            allModes.add(DEBTORS_MODE);
            allTerminalModes = Collections.unmodifiableList(allModes);
        }
        return allTerminalModes;
    }

    @Override
    public void deleteChild() {
        PersistenceManager.deleteChild(this);
    }

    @Override
    public boolean hasChildChanged() {
        return PersistenceManager.hasChildChanged(this);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void saveChild() {
        PersistenceManager.saveChild(this);
    }

    public TerminalMode copy() {
        return new TerminalMode(this);
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property TERMINAL;
        public PropertiedObject.Property MODE;
        public PropertiedObject.Property SEQUENCE;
        public PropertiedObject.Property LABEL;
    }
}

