/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.hardware;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.Auditable;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentDisplayableObject;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.persistence.cache.LocalCacheListManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import javax.persistence.AttributeOverride;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import ordermate.database.hardware.DocketGrouping;
import ordermate.database.hardware.DocketSorting;
import ordermate.database.hardware.PrinterSummary;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.physical.PhysicalPrintDevice;
import ordermate.database.hardware.physical.PhysicalPrinter;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesLineItem;
import org.hibernate.annotations.AccessType;

@Entity
@Table(name="config_printer_virtual")
@AccessType(value="property")
@AttributeOverride(name="label", column=@Column(name="Name"))
public class VirtualPrinter
extends PersistentDisplayableObject
implements Saveable,
Auditable {
    public static final String SORT_SEQUENCES = "Sequences";
    public static final Props Properties = new Props();
    private static LocalCacheListManager<VirtualPrinter> allPrintersCacheList = new LocalCacheListManager<VirtualPrinter>(Query.createQueryList(VirtualPrinter.class, Query.select(VirtualPrinter.class).orderBy(VirtualPrinter.Properties.LABEL)));
    private Reference<PhysicalPrintDevice> printDevice;
    private PersistentWriteableList<VirtualPrinter> notifyPrinters;
    private int docketNumber;
    private String prepDocketGrouping;
    private String docketSortingStrategy;
    private boolean autoPrintPayoff;
    private String prepDocketFile;
    private boolean itemisedNotifiers;
    private Reference<DocketGrouping> docketGroupingPrep;
    private Reference<DocketSorting> docketSortingPrep;
    private Reference<DocketGrouping> docketGroupingRec;
    private Reference<DocketSorting> docketSortingRec;

    public VirtualPrinter() {
        this.printDevice = this.createReference(VirtualPrinter.Properties.PRINT_DEVICE);
        this.notifyPrinters = (PersistentWriteableList)this.createList(VirtualPrinter.Properties.NOTIFY_PRINTERS);
        this.prepDocketGrouping = "";
        this.docketSortingStrategy = "";
        this.itemisedNotifiers = false;
        this.docketGroupingPrep = this.createReference(VirtualPrinter.Properties.DOCKET_GROUPING_PREP);
        this.docketSortingPrep = this.createReference(VirtualPrinter.Properties.DOCKET_SORTING_PREP);
        this.docketGroupingRec = this.createReference(VirtualPrinter.Properties.DOCKET_GROUPING_REC);
        this.docketSortingRec = this.createReference(VirtualPrinter.Properties.DOCKET_SORTING_REC);
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="FK_config_printer")
    public PhysicalPrintDevice getPrintDevice() {
        return this.printDevice.get();
    }

    public String getReceiptXMLFile(Terminal terminalPrintedFrom) {
        Object[][] rs = PersistenceManager.getPersistenceDelegate().executeQuery("SELECT config_receipt_printer.receipt_docket_location FROM config_receipt_printer WHERE config_receipt_printer.FK_config_printer_virtual = ? AND FK_config_terminal = ?", new Object[]{this.getID(), terminalPrintedFrom.getID()});
        if (rs.length == 0) {
            return null;
        }
        String docketLocation = (String)rs[0][0];
        return docketLocation;
    }

    public String getPayoffXMLFile(Terminal terminalPrintedFrom) {
        Object[][] rs = PersistenceManager.getPersistenceDelegate().executeQuery("SELECT config_payoff_printer.payoff_docket_location FROM config_payoff_printer WHERE config_payoff_printer.FK_config_printer_virtual = ? AND config_payoff_printer.FK_config_terminal = ?", new Object[]{this.getID(), terminalPrintedFrom.getID()});
        if (rs.length == 0) {
            return null;
        }
        String docketLocation = (String)rs[0][0];
        return docketLocation;
    }

    @ManyToMany
    @JoinTable(name="config_printer_notify", joinColumns={@JoinColumn(name="Source_Virtual_Printer", referencedColumnName="ID")}, inverseJoinColumns={@JoinColumn(name="Notify_Virtual_Printer", referencedColumnName="ID")})
    public List<VirtualPrinter> getNotifyPrinters() {
        return this.notifyPrinters.getUnmodifiable();
    }

    public void setNotifyPrinters(List<VirtualPrinter> printers) {
        this.notifyPrinters.clear();
        this.notifyPrinters.addAll(printers);
    }

    public static Collection<VirtualPrinter> getDocketPrintersForItems(List items, Terminal terminal) {
        return VirtualPrinter.getDocketPrintersForItems(items, -1, terminal);
    }

    public static Collection<VirtualPrinter> getDocketPrintersForItems(List<SalesLineItem> items, int course, Terminal terminal) {
        LinkedHashSet<VirtualPrinter> printers = new LinkedHashSet<VirtualPrinter>();
        for (SalesLineItem item : items) {
            if (course != -1 && item.getCourse() != course) continue;
            for (VirtualPrinter printer : item.getDocketPrinters(terminal)) {
                printers.add(printer);
            }
        }
        return printers;
    }

    public static List getNotifyPrinters(List items, VirtualPrinter printer, Terminal terminal) {
        return VirtualPrinter.getNotifyPrinters(items, -1, printer, terminal);
    }

    public static List<VirtualPrinter> getNotifyPrinters(List items, int course, VirtualPrinter printer, Terminal terminal) {
        List<VirtualPrinter> notifyPrinters = printer.getNotifyPrinters();
        List<SalesItem> locallyPrintableItems = SalesItem.getItemsPrintableThrough(items, course, printer, terminal);
        ArrayList<VirtualPrinter> notifyPrintersToReturn = new ArrayList<VirtualPrinter>();
        for (VirtualPrinter notifyPrinter : notifyPrinters) {
            List<SalesItem> printableItems = SalesItem.getItemsPrintableThrough(items, course, notifyPrinter, terminal);
            if (locallyPrintableItems.containsAll(printableItems)) continue;
            notifyPrintersToReturn.add(notifyPrinter);
        }
        return notifyPrintersToReturn;
    }

    @Override
    @Transient
    public String getIcon() {
        return "/ordermate/images/printer32.png";
    }

    public void setPrintDevice(PhysicalPrintDevice newPrinter) {
        this.printDevice.set(newPrinter);
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void delete() {
        for (PrinterSummary summary : this.getPrinterSummaries()) {
            summary.delete();
        }
        PersistenceManager.delete(this);
        this.notifyPrinters.deleteChild();
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
        this.notifyPrinters.saveChild();
    }

    @Column(name="docket_number")
    public int getDocketNumber() {
        return this.docketNumber;
    }

    public void incrementDocketNumber() {
        ++this.docketNumber;
    }

    public void resetDocketNumber() {
        this.docketNumber = 0;
        this.save();
    }

    public static List<VirtualPrinter> getAllPrinters() {
        return allPrintersCacheList.getList();
    }

    public static void clearAllPrinterCacheList() {
        allPrintersCacheList.clearCache();
    }

    public void setPrepDocketGrouping(PrepDocketGrouping grouping) {
        this.prepDocketGrouping = grouping.toString();
    }

    @Column(name="prep_docket_grouping")
    public String getPrepDocketGrouping() {
        return this.prepDocketGrouping;
    }

    public void setPrepDocketGrouping(String grouping) {
        this.prepDocketGrouping = grouping;
    }

    @Column(name="docket_sorting_strategy")
    public String getDocketSortingStrategy() {
        return this.docketSortingStrategy;
    }

    public void setDocketSortingStrategy(String strat) {
        this.docketSortingStrategy = strat;
    }

    @Column(name="auto_print_payoff")
    public boolean isAutoPrintPayoff() {
        return this.autoPrintPayoff;
    }

    public void setAutoPrintPayoff(boolean enableAutoPrintPayoff) {
        this.autoPrintPayoff = enableAutoPrintPayoff;
    }

    @Transient
    public boolean isWindowPrinter() {
        PhysicalPrintDevice pPrinter = this.getPrintDevice();
        if (pPrinter == null || pPrinter.getPortType() == null) {
            return false;
        }
        return pPrinter.getPortType().equalsIgnoreCase("Windows");
    }

    @Column(name="prep_docket_location")
    public String getPrepDocketFile() {
        return this.prepDocketFile;
    }

    public void setPrepDocketFile(String fileName) {
        this.prepDocketFile = fileName;
    }

    public List<SalesItem> getItemsPrintableThrough(Terminal terminal, List salesItems) {
        ArrayList<SalesItem> itemsPrintable = new ArrayList<SalesItem>();
        for (SalesItem item : salesItems) {
            if (!item.isPrintableThrough(terminal, this)) continue;
            itemsPrintable.add(item);
        }
        return itemsPrintable;
    }

    protected void setDocketNumber(int newDocketNumber) {
        this.docketNumber = newDocketNumber;
    }

    @Transient
    public PhysicalPrinter getWindowsPrinter() {
        PhysicalPrintDevice device = this.getPrintDevice();
        if (device instanceof PhysicalPrinter) {
            return (PhysicalPrinter)device;
        }
        throw new IllegalStateException("The attached printer :" + device + " is not a windows printer.");
    }

    @Column(name="itemised_notifiers")
    public boolean isItemisedNotifiers() {
        return this.itemisedNotifiers;
    }

    public void setItemisedNotifiers(boolean value) {
        this.itemisedNotifiers = value;
    }

    @Transient
    public List<PrinterSummary> getPrinterSummaries() {
        List<PrinterSummary> listPS = PrinterSummary.getAllPrinterSummaries();
        ArrayList<PrinterSummary> toReturn = new ArrayList<PrinterSummary>();
        for (PrinterSummary ps : listPS) {
            VirtualPrinter localPrinter = ps.getVirtualPrinter();
            if (localPrinter == null || !localPrinter.getID().equals(this.getID())) continue;
            toReturn.add(ps);
        }
        return toReturn;
    }

    @Transient
    public DocketGrouping getDocketGroupingPrep() {
        return this.docketGroupingPrep.get();
    }

    public void setDocketGroupingPrep(DocketGrouping yourGrouping) {
        this.docketGroupingPrep.set(yourGrouping);
    }

    @Transient
    public DocketSorting getDocketSortingPrep() {
        return this.docketSortingPrep.get();
    }

    public void setDocketSortingPrep(DocketSorting value) {
        this.docketSortingPrep.set(value);
    }

    @Transient
    public DocketGrouping getDocketGroupingRec() {
        return this.docketGroupingRec.get();
    }

    public void setDocketGroupingRec(DocketGrouping yourGrouping) {
        this.docketGroupingRec.set(yourGrouping);
    }

    @Transient
    public DocketSorting getDocketSortingRec() {
        return this.docketSortingRec.get();
    }

    public void setDocketSortingRec(DocketSorting value) {
        this.docketSortingRec.set(value);
    }

    @Override
    @Transient
    public String getLogDetail() {
        StringBuilder sb = new StringBuilder();
        sb.append("Label(").append(this.getLabel()).append("),").append("PrintDevice(").append(this.getPrintDevice()).append("),").append("DocketSorting(").append(this.getDocketSortingStrategy()).append("),").append("PrepGrouping(").append(this.getPrepDocketGrouping()).append("),").append("PrepDocketFile(").append(this.getPrepDocketFile()).append("),").append("PrinterSummaries(").append(this.getPrinterSummaries()).append("),").append("ItemisedNotifiers(").append(this.isItemisedNotifiers()).append("),").append("NotifyPrinters(").append(this.getNotifyPrinters()).append(")");
        return sb.toString();
    }

    @Override
    @Transient
    public String getAuditName() {
        return "Virtual Printer";
    }

    public static class PrepDocketGrouping {
        public static final PrepDocketGrouping NONE = new PrepDocketGrouping("None");
        public static final PrepDocketGrouping ITEM_NAME = new PrepDocketGrouping("ItemName");
        public static final PrepDocketGrouping COMBO_ITEM_NAME = new PrepDocketGrouping("Combo Then Item Name");
        public static final PrepDocketGrouping ITEM_NAME_IGNORE_COMBO = new PrepDocketGrouping("Item Name Ignore Combo Check");
        private final String label;

        public static final List<String> getGroupingTypes() {
            ArrayList<String> types = new ArrayList<String>();
            types.add(NONE.toString());
            types.add(ITEM_NAME.toString());
            types.add(COMBO_ITEM_NAME.toString());
            types.add(ITEM_NAME_IGNORE_COMBO.toString());
            return types;
        }

        private PrepDocketGrouping(String newLabel) {
            this.label = newLabel;
        }

        public String toString() {
            return this.label;
        }
    }

    public static class Props
    extends PersistentDisplayableObject.Props {
        public PropertiedObject.Property<PhysicalPrintDevice> PRINT_DEVICE;
        public PropertiedObject.Property<VirtualPrinter> NOTIFY_PRINTERS;
        public PropertiedObject.Property DOCKET_NUMBER;
        public PropertiedObject.Property PREP_DOCKET_GROUPING;
        public PropertiedObject.Property DOCKET_SORTING_STRATEGY;
        public PropertiedObject.Property AUTO_PRINT_PAYOFF;
        public PropertiedObject.Property PREP_DOCKET_FILE;
        public PropertiedObject.Property ITEMISED_NOTIFIERS;
        public PersistentObject.DerivedProperty PRINTER_SUMMARY = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)VirtualPrinter.class), "printerSummaries");
        public PropertiedObject.Property<DocketGrouping> DOCKET_GROUPING_PREP;
        public PropertiedObject.Property<DocketSorting> DOCKET_SORTING_PREP;
        public PropertiedObject.Property<DocketGrouping> DOCKET_GROUPING_REC;
        public PropertiedObject.Property<DocketSorting> DOCKET_SORTING_REC;
    }
}

