/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.hardware.eftpos;

import au.com.ordermate.OrderMateLog;
import java.io.IOException;
import java.util.ArrayList;
import ordermate.OrderMate;
import ordermate.database.finance.transactions.EftposTransaction;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.VirtualPrinter;
import ordermate.database.hardware.eftpos.EftposPrintProcessor;
import ordermate.database.hardware.eftpos.EftposRequest;
import ordermate.docketprocessor.DocketProcessor;

public class DefaultEftposPrintProcessor
implements EftposPrintProcessor {
    @Override
    public boolean printEftposDocket(String docket, EftposRequest request, boolean customerCopy) {
        ArrayList<VirtualPrinter> printers = new ArrayList<VirtualPrinter>(Terminal.getLocalHost().getAvailableReceiptPrinters());
        if (printers.size() > 1) {
            VirtualPrinter toPrintFrom = (VirtualPrinter)printers.get(0);
            printers.clear();
            printers.add(toPrintFrom);
        } else if (printers.isEmpty()) {
            OrderMate.LOG.warn("No ReceiptPrinter found for printing an eftpos receipt, choosing any printer. No eftpos receipt can be printed.");
            return false;
        }
        EftposTransaction txn = null;
        if (request != null) {
            txn = request.getTransaction();
        }
        try {
            DocketProcessor.printEftposDocket(docket, printers, txn, customerCopy);
            return true;
        }
        catch (IOException ex) {
            OrderMateLog.LOG.warn("Couldn't print the eftpos docket.", (Throwable)ex);
            return false;
        }
    }
}

