/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.hardware.eftpos;

import au.com.ordermate.util.Price;
import ordermate.database.Payable;
import ordermate.database.finance.transactions.EftposTransaction;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.physical.CashDrawer;

public class EftposRequest {
    private EftposTransaction transaction;
    private final Payable payable;
    private final boolean blocking;
    private boolean reversal;
    private boolean moto;
    private final boolean tipping;
    private Price reversalAmount = null;
    private CashDrawer cashDrawerToUse;
    private Terminal terminalToUse;
    private boolean updateOriginalDetails = true;

    public void setReversal(boolean reversal) {
        this.reversal = reversal;
    }

    public EftposRequest(EftposTransaction theTransaction, Payable toPay, boolean isBlocking, boolean isReversal, boolean isTippingAdjustment) {
        this.transaction = theTransaction;
        this.payable = toPay;
        this.blocking = isBlocking;
        this.reversal = isReversal;
        this.tipping = isTippingAdjustment;
    }

    public final Payable getPayable() {
        return this.payable;
    }

    public final EftposTransaction getTransaction() {
        return this.transaction;
    }

    public final void setEftposTransaction(EftposTransaction value) {
        if (value != null) {
            this.transaction = value;
        }
    }

    public final boolean isBlocking() {
        return this.blocking;
    }

    public final boolean isReversal() {
        return this.reversal;
    }

    public final boolean isTippingAdjustment() {
        return this.tipping;
    }

    public CashDrawer getCashDrawerToUse() {
        return this.cashDrawerToUse != null ? this.cashDrawerToUse : this.transaction.getCashDrawer();
    }

    public void setCashDrawerToUse(CashDrawer cashDrawerToUse) {
        this.cashDrawerToUse = cashDrawerToUse;
    }

    public Terminal getTerminalToUse() {
        return this.terminalToUse != null ? this.terminalToUse : this.transaction.getTerminal();
    }

    public void setTerminalToUse(Terminal terminalToUse) {
        this.terminalToUse = terminalToUse;
    }

    public boolean isUpdateOriginalDetails() {
        return this.updateOriginalDetails;
    }

    public void setUpdateOriginalDetails(boolean updateOrdiginalDetails) {
        this.updateOriginalDetails = updateOrdiginalDetails;
    }

    public Price getReversalAmount() {
        return this.reversalAmount;
    }

    public void setReversalAmount(Price reversalAmount) {
        this.reversalAmount = reversalAmount;
    }

    public boolean isMoto() {
        return this.moto;
    }

    public void setMoto(boolean moto) {
        this.moto = moto;
    }
}

