/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.hardware.eftpos;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistentSummaryObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.Price;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.finance.transactions.FinanceUnit;

public class EftposSummary
extends PersistentSummaryObject {
    public static final Props Properties = new Props();
    private String financeUnit;
    private Price totalSales;
    private Price totalCashouts;
    private int numberOfTransactions;

    public final Price getTotalSales() {
        return this.totalSales;
    }

    public final Price getTotalCashouts() {
        return this.totalCashouts;
    }

    public final String getFinanceUnit() {
        return this.financeUnit;
    }

    public final int getNumberOfTransactions() {
        return this.numberOfTransactions;
    }

    public final void setNumberOfTransactions(int value) {
        this.numberOfTransactions = value;
    }

    protected ObjectQuery getSummaryQuery() {
        ObjectQuery query = Query.select(FinanceUnit.Properties.LABEL, "FinanceUnit").count(FinanceTransaction.class, "NumberOfTxns").sum(FinanceTransaction.Properties.PAID, "TotalAmount").linkUsing(FinanceTransaction.Properties.SUB_TYPE, FinanceUnit.Properties.ID).wherePropertyIn(FinanceTransaction.Properties.SUB_TYPE, FinanceUnit.getElectronicUnits()).equalsParam(FinanceTransaction.Properties.TRADING_DAY).groupBy(FinanceUnit.Properties.ID);
        return query;
    }

    public static class Props
    extends PersistentSummaryObject.Props {
        public PropertiedObject.Property FINANCE_UNIT;
        public PropertiedObject.Property TOTAL_SALES;
        public PropertiedObject.Property NUMBER_OF_TRANSACTIONS;
        public PropertiedObject.Property TOTAL_CASHOUTS;
    }
}

