/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.hardware.eftpos;

import au.com.ordermate.persistence.PersistentEnumeration;
import java.util.Map;
import ordermate.database.integration.webpayment.WebPaymentIntegration;

public class EftposType
extends PersistentEnumeration {
    public static final EftposType TYRO = new EftposType("Tyro", true, "Tyro");
    public static final EftposType TYROWEB = new EftposType("TyroWeb", false, "Tyro Web");
    public static final EftposType INGENICO = new EftposType("Ingenico", false, "Ingenico / PCEftpos");
    public static final EftposType ONLINE = new EftposType("Online", false, "Online / Oorb / Doshii");
    public static final EftposType TYROMOBILE = new EftposType("TyroMobile", false, "Tyro Mobile");
    public static final EftposType ASSEMBLY = new EftposType("Assembly", false, "Westpac Group");
    public static final EftposType NITROSKYZER = new EftposType("NitroSkyzer", false, "Nitro Skyzer");
    public static final EftposType MX51SPICE = new EftposType("mx51Spice", false, "Spice");
    public static final EftposType SMARTPAY = new EftposType("SmartPay", false, "SmartPay");
    public static final EftposType ADYEN = new EftposType("Adyen", false, "Oolio");
    public static final EftposType LINKLYCLOUD = new EftposType("LinklyCloud", false, "Oolio Cloud");
    private final boolean requiresFile;
    private final WebPaymentIntegration integration;
    public static final Map<String, EftposType> register = EftposType.buildRegister(INGENICO, TYRO, TYROWEB, TYROMOBILE, ONLINE, ASSEMBLY, NITROSKYZER, MX51SPICE, SMARTPAY, ADYEN, LINKLYCLOUD);

    private EftposType(String enumValue, boolean reqFile, String label) {
        super(enumValue, label);
        this.requiresFile = reqFile;
        this.integration = null;
    }

    public EftposType(WebPaymentIntegration integration) {
        super(integration.getType().name());
        this.requiresFile = false;
        this.integration = integration;
    }

    public static Map<String, EftposType> getRegister() {
        return register;
    }

    public boolean isPairingRequired() {
        return TYROWEB.equals(this) || ASSEMBLY.equals(this) || SMARTPAY.equals(this) || LINKLYCLOUD.equals(this);
    }

    public boolean isPingRequired() {
        return MX51SPICE.equals(this) || ADYEN.equals(this);
    }

    public boolean isSettingsAdjustable() {
        return ADYEN.equals(this);
    }

    public boolean requiresFile() {
        return this.requiresFile;
    }

    public WebPaymentIntegration getWebPaymentIntegration() {
        return this.integration;
    }
}

