/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.hardware.physical;

import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import java.net.InetAddress;
import java.net.Socket;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import ordermate.OrderMate;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.physical.Device;
import ordermate.integration.videopro.CCTVIntegration;
import org.hibernate.annotations.AccessType;

@Entity
@Table(name="config_camera")
@AccessType(value="property")
public class Camera
extends Device {
    public static final Props Properties = new Props();
    private String ipAddress;
    private int tcpPort;
    private String systemState = "ACTIVE";
    private boolean client;
    private boolean connectPerLine = false;

    public Camera() {
        this.terminals = (PersistentWriteableList)this.createList(Camera.Properties.TERMINALS);
    }

    @Transient
    public Terminal getTerminal() {
        return this.terminals.isEmpty() ? null : (Terminal)this.terminals.get(0);
    }

    public void setTerminal(Terminal terminalToAdd) {
        this.terminals.clear();
        this.terminals.add(terminalToAdd);
    }

    @Column(name="ip_address")
    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String address) {
        this.ipAddress = address;
    }

    @Column(name="tcp_port")
    public int getTcpPort() {
        return this.tcpPort;
    }

    public void setTcpPort(int port) {
        this.tcpPort = port;
    }

    @Transient
    public boolean isTcpIp() {
        return this.ipAddress != null && !this.ipAddress.isEmpty() && this.tcpPort > 0;
    }

    @Column(name="client")
    public boolean isClient() {
        return this.client;
    }

    public void setClient(boolean value) {
        this.client = value;
    }

    @Override
    public void startup(Terminal localHost) throws Exception {
        if (this.isTcpIp()) {
            if (this.isClient()) {
                CCTVIntegration.registerClientCamera(this);
            } else {
                this.connectToServer();
            }
        } else {
            super.startup(localHost);
        }
    }

    private void connectToServer() throws Exception {
        OrderMate.LOG.info("Attempting to connect to camera at:" + this.ipAddress + " on port:" + this.tcpPort);
        InetAddress machineAdd = InetAddress.getByName(this.ipAddress);
        Socket dataSocket = new Socket(machineAdd, this.tcpPort);
        dataSocket.close();
    }

    public synchronized void display(String output) {
        try {
            if (this.isTcpIp()) {
                CCTVIntegration.push(this, output);
            } else {
                this.sendData(output, "CCTV info");
            }
        }
        catch (Exception e) {
            OrderMate.LOG.error("Error sending data to the CCTV camera " + this.getLabel(), (Throwable)e);
        }
    }

    @Override
    public void delete() {
        this.systemState = "DELETED";
        this.terminals.clear();
        this.save();
    }

    @Column(name="system_state")
    protected String getSystemState() {
        return this.systemState;
    }

    protected void setSystemState(String systemState) {
        this.systemState = systemState;
    }

    @Override
    @ManyToOne
    @JoinColumn(name="FK_config_terminal")
    public Terminal getHost() {
        return super.getHost();
    }

    @Override
    public void setHost(Terminal newHost) {
        super.setHost(newHost);
    }

    @Override
    @Column(name="port")
    public String getPort() {
        return super.getPort();
    }

    @Override
    public void setPort(String newPort) {
        super.setPort(newPort);
    }

    @Override
    @Column(name="port_type")
    public String getPortType() {
        return super.getPortType();
    }

    @Override
    public void setPortType(String newPortType) {
        super.setPortType(newPortType);
    }

    @Override
    @Column(name="flow_control")
    public String getFlowControl() {
        return super.getFlowControl();
    }

    @Override
    public void setFlowControl(String control) {
        super.setFlowControl(control);
    }

    @Override
    @Column(name="port_speed")
    public int getPortSpeed() {
        return super.getPortSpeed();
    }

    @Override
    public void setPortSpeed(int newSpeed) {
        super.setPortSpeed(newSpeed);
    }

    @Column(name="connect_per_line")
    public boolean isConnectPerLine() {
        return this.connectPerLine;
    }

    public void setConnectPerLine(boolean value) {
        this.connectPerLine = value;
    }

    public static class Props
    extends Device.Props {
        public PropertiedObject.Property SYSTEM_STATE;
        public PropertiedObject.Property IP_ADDRESS;
        public PropertiedObject.Property TCP_PORT;
        public PropertiedObject.Property CLIENT;
        public PropertiedObject.Property CONNECT_PER_LINE;
    }
}

