/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.hardware.physical;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import ordermate.OrderMate;

public class CameraSocketServer
implements Runnable {
    private ServerSocket socket;
    private Socket clientSocket;
    private static final int TIMEOUT = 60000;
    private final int port;

    public CameraSocketServer(int port) throws IOException {
        this.port = port;
        this.connect();
    }

    private void connect() throws IOException {
        this.socket = new ServerSocket(this.port);
        if (this.socket != null && !this.socket.isClosed() && (this.clientSocket == null || this.clientSocket.isClosed())) {
            try {
                this.clientSocket = this.socket.accept();
            }
            catch (Exception ex) {
                OrderMate.LOG.warn("Socket was closed for camera:", (Throwable)ex);
                this.disconnect();
            }
        }
    }

    @Override
    public void run() {
        while (true) {
            if (this.socket == null || this.socket.isClosed()) {
                try {
                    this.connect();
                }
                catch (IOException ex) {
                    OrderMate.LOG.error("Cannot instantiate ServerSocket for client camera");
                }
            }
            try {
                Thread.sleep(60000L);
                continue;
            }
            catch (InterruptedException e) {
                OrderMate.LOG.warn("Camera retry thread interrupted");
                continue;
            }
            break;
        }
    }

    private void disconnect() {
        try {
            if (this.socket != null && !this.socket.isClosed()) {
                this.socket.close();
            }
            this.socket = null;
        }
        catch (Exception ex2) {
            OrderMate.LOG.warn("Couldn't close off camera socket", (Throwable)ex2);
        }
    }

    public void reconnect() throws IOException {
        this.disconnect();
        this.connect();
    }

    public boolean canPublish() {
        return this.socket != null && !this.socket.isBound() && !this.socket.isClosed() && this.clientSocket != null && this.clientSocket.isBound() && !this.clientSocket.isClosed();
    }

    public Socket getClientSocket() {
        return this.clientSocket;
    }
}

