/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.hardware.physical;

import au.com.ordermate.networkio.NetworkIO;
import au.com.ordermate.networkio.ports.IPPort;
import au.com.ordermate.networkio.ports.OutputPort;
import au.com.ordermate.networkio.ports.ParallelPort;
import au.com.ordermate.networkio.ports.SerialPort;
import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.simplermi.SimpleRMI;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.StringUtils;
import java.io.InputStream;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.AttributeOverride;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import ordermate.OrderMate;
import ordermate.database.Data;
import ordermate.database.EventContext;
import ordermate.database.finance.Shift;
import ordermate.database.finance.Skim;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.TerminalLocation;
import ordermate.database.hardware.physical.Device;
import ordermate.database.hardware.physical.PhysicalPrintDevice;
import ordermate.database.hardware.physical.PhysicalPrinter;
import ordermate.database.hardware.physical.PrinterEncoding;
import ordermate.database.users.User;
import org.hibernate.annotations.AccessType;

@Entity
@Table(name="config_cashdrawer")
@AccessType(value="property")
@AttributeOverride(name="label", column=@Column(name="Name"))
public class CashDrawer
extends Device {
    public static final Props Properties = new Props();
    public static final String NATIVE_KICKER = "Kicker";
    public static final String PRINTER_CBM_KICKER = "Printer_CBM";
    public static final String PRINTER_ESCPOS_PIN1_KICKER = "Printer_ESCPOS_1";
    public static final String PRINTER_ESCPOS_PIN5_KICKER = "Printer_ESCPOS_2";
    public static final String TERMINAL_KICKER = "Terminal";
    private static String NATIVE_MESSAGE = "UUUUU\u0007\u0007\u0007";
    private static String PRINTER_ESCPOS_PIN1_MESSAGE = "\u001bp\u00002\u00fa";
    private static String PRINTER_ESCPOS_PIN5_MESSAGE = "\u001bp\u00012\u00fa";
    private static String PRINTER_CBM_MESSAGE = "\u0007";
    public static final String OFFICE_CASH_DRAWER = "Officedrawer";
    public static final String ONLINE_CASH_DRAWER = "Online Cashdrawer";
    private String kickerType;
    private String systemState = "ACTIVE";
    private Reference<TerminalLocation> location;
    private int ipPort;
    private boolean userPayable;

    public CashDrawer() {
        this.location = this.createReference(CashDrawer.Properties.LOCATION);
        this.ipPort = 9100;
        this.userPayable = true;
        this.terminals = (PersistentWriteableList)this.createList(CashDrawer.Properties.TERMINALS);
    }

    public static final List<String> getKickerTypes() {
        ArrayList<String> kickers = new ArrayList<String>();
        kickers.add(NATIVE_KICKER);
        kickers.add(PRINTER_CBM_KICKER);
        kickers.add(PRINTER_ESCPOS_PIN1_KICKER);
        kickers.add(PRINTER_ESCPOS_PIN5_KICKER);
        kickers.add(TERMINAL_KICKER);
        return kickers;
    }

    @Column(name="system_state")
    public String getSystemState() {
        return this.systemState;
    }

    @Transient
    public boolean isActive() {
        return this.systemState.equals("ACTIVE");
    }

    @Column(name="Kicker_type")
    public String getKickerType() {
        return this.kickerType;
    }

    public void setKickerType(String kicker) {
        this.kickerType = kicker;
    }

    @Transient
    private String getServiceName() {
        return "Terminal kicker " + this.getID();
    }

    public void open(User openUser) throws Exception {
        if (this.getKickerType().equals(PRINTER_ESCPOS_PIN1_KICKER)) {
            this.sendData(PRINTER_ESCPOS_PIN1_MESSAGE, "Opening cashdrawer for " + openUser.getLabel());
        } else if (this.getKickerType().equals(PRINTER_ESCPOS_PIN5_KICKER)) {
            this.sendData(PRINTER_ESCPOS_PIN5_MESSAGE, "Opening cashdrawer for " + openUser.getLabel());
        } else if (this.getKickerType().equals(PRINTER_CBM_KICKER)) {
            this.sendData(PRINTER_CBM_MESSAGE, "Opening cashdrawer for " + openUser.getLabel());
        } else if (this.getKickerType().equals(TERMINAL_KICKER)) {
            Terminal owner = this.getHost();
            RemoteKicker kicker = (RemoteKicker)SimpleRMI.getObject(owner.getAddress(), this.getServiceName(), owner.getRmiPort());
            kicker.open();
        } else {
            this.sendData(NATIVE_MESSAGE, "Opening cashdrawer for " + openUser.getLabel());
        }
    }

    public void openCashDrawerSkim(User user) {
        try {
            this.open(user);
        }
        catch (Exception e) {
            OrderMate.LOG.error("Error opening cashdrawer " + this.getLabel(), (Throwable)e);
        }
    }

    @Override
    protected final OutputPort createPort(boolean addListener) {
        OutputPort out;
        if (this.getKickerType().equals(PRINTER_ESCPOS_PIN1_KICKER) || this.getKickerType().equals(PRINTER_ESCPOS_PIN5_KICKER) || this.getKickerType().equals(PRINTER_CBM_KICKER)) {
            String encoding;
            PrinterEncoding printerEncoding = this.lookForPhysicalPrinterEncoding();
            String string = encoding = printerEncoding.isEncoded() ? printerEncoding.getEncodingValue() : null;
            out = this.getPortType().equalsIgnoreCase("Serial") ? new SerialPort(this.getPort(), this.getPortSpeed(), addListener, 0, this.getFlowControl(), encoding) : (this.getPortType().equalsIgnoreCase("Parallel") ? new ParallelPort(this.getPort()) : (this.getPortType().equalsIgnoreCase("IP") ? new IPPort(this.getPort(), this.getIpPort(), encoding) : super.createPort(addListener)));
        } else {
            out = super.createPort(addListener);
        }
        return out;
    }

    private PrinterEncoding lookForPhysicalPrinterEncoding() {
        PhysicalPrinter printer = PersistenceManager.getObject(PhysicalPrinter.class, Query.select(PhysicalPrinter.class).equals(PhysicalPrintDevice.Properties.PORT, this.getPort()).equals(PhysicalPrintDevice.Properties.HOST, this.getHost()).toString());
        if (printer != null) {
            return printer.getEncoding() == null ? PrinterEncoding.Standard : printer.getEncoding();
        }
        return PrinterEncoding.Standard;
    }

    @Override
    public void startup(Terminal localHost) throws Exception {
        if (!NetworkIO.hasServer(this.getPort()) && !this.getKickerType().equals(TERMINAL_KICKER)) {
            if (!localHost.equals(this.getHost())) {
                throw new IllegalStateException("Can only share a device from the PC it is connected to");
            }
            OutputPort port = this.createPort(false);
            NetworkIO.startServer(port, OrderMate.LOG_DIR);
        } else if (this.getKickerType().equals(TERMINAL_KICKER)) {
            RemoteKickerImpl kickerService = new RemoteKickerImpl();
            SimpleRMI.shareObject(kickerService, this.getServiceName());
        }
    }

    @Transient
    public List<Terminal> getLogicallyConnectedTerminals() {
        List<Terminal> terms = PersistenceManager.getObjectList(Terminal.class, "SELECT config_terminal.* FROM config_terminal, config_terminal_cashdrawer WHERE config_terminal.system_state = 'ACTIVE' AND config_terminal.ID = config_terminal_cashdrawer.FK_config_terminal AND config_terminal_cashdrawer.FK_config_cashdrawer = ?", new Object[]{this.getID()});
        return terms;
    }

    public Price getSkimTotalForShift(Shift theShift) {
        List<Skim> skims = Skim.getSkims(theShift, this);
        Price total = Price.ZERO;
        if (skims == null || skims.size() == 0) {
            return total;
        }
        for (Skim current : skims) {
            total = total.add(current.getTotal());
        }
        return total;
    }

    public Price getSkimTotalForShift(Shift theShift, FinanceUnit type) {
        List<Skim> skims = Skim.getSkims(theShift, this);
        Price total = new Price(0.0);
        if (skims == null || skims.size() == 0) {
            return total;
        }
        for (Skim current : skims) {
            Price newAmount = current.getTotalForSubType(type);
            total = total.add(newAmount);
        }
        return total;
    }

    public static List<CashDrawer> getAvailableCashDrawers(EventContext ctx) {
        return CashDrawer.getAvailableCashDrawers(ctx.getTerminal(), ctx.getUser());
    }

    public static List<CashDrawer> getAvailableCashDrawers(Terminal terminal, User user) {
        if ("ServerMate".equals(terminal.getTerminalType())) {
            return PersistenceManager.getObjectList(CashDrawer.class, "SELECT config_cashdrawer.* FROM config_terminal_cashdrawer INNER JOIN config_cashdrawer ON config_terminal_cashdrawer.FK_config_cashdrawer = config_cashdrawer.ID INNER JOIN config_terminal ON config_terminal_cashdrawer.FK_config_terminal = config_terminal.ID WHERE  config_terminal_cashdrawer.FK_config_terminal = ? AND config_cashdrawer.system_state = 'ACTIVE' AND config_terminal.system_state = 'ACTIVE' ", new Object[]{terminal.getID()});
        }
        return PersistenceManager.getObjectList(CashDrawer.class, "SELECT config_cashdrawer.* FROM config_terminal_cashdrawer INNER JOIN config_cashdrawer ON config_terminal_cashdrawer.FK_config_cashdrawer = config_cashdrawer.ID INNER JOIN config_terminal ON config_terminal_cashdrawer.FK_config_terminal = config_terminal.ID WHERE  config_terminal_cashdrawer.FK_config_terminal = ? AND config_terminal_cashdrawer.FK_config_user = ? AND config_cashdrawer.system_state = 'ACTIVE' AND config_terminal.system_state = 'ACTIVE' ", new Object[]{terminal.getID(), user.getID()});
    }

    public static void setCashDrawerUser(CashDrawer drawer, Terminal terminal, User user) {
        try {
            if (user == null) {
                Data.database.setCashDrawerUser(drawer.intID(), terminal.getID().intValue(), 0L);
            } else {
                Data.database.setCashDrawerUser(drawer.intID(), terminal.getID().intValue(), user.intID());
            }
        }
        catch (RemoteException e) {
            Data.handleException(e);
        }
    }

    public static User getCashDrawerUser(CashDrawer drawer, Terminal terminal) {
        try {
            return Data.database.getCashDrawerUser(drawer.intID(), terminal.getID().intValue());
        }
        catch (RemoteException e) {
            Data.handleException(e);
            return null;
        }
    }

    @Override
    public void delete() {
        this.systemState = "DELETED";
        this.terminals.clear();
        this.save();
    }

    protected void setSystemState(String value) {
        this.systemState = value;
    }

    @Override
    @ManyToOne
    @JoinColumn(name="FK_config_terminal")
    public Terminal getHost() {
        return super.getHost();
    }

    @Override
    public void setHost(Terminal newHost) {
        super.setHost(newHost);
    }

    @Override
    @Column(name="port")
    public String getPort() {
        return super.getPort();
    }

    @Override
    public void setPort(String newPort) {
        super.setPort(newPort);
    }

    @Override
    @Column(name="port_type")
    public String getPortType() {
        return super.getPortType();
    }

    @Override
    public void setPortType(String newPortType) {
        super.setPortType(newPortType);
    }

    @Override
    @Column(name="flow_control")
    public String getFlowControl() {
        return super.getFlowControl();
    }

    @Override
    public void setFlowControl(String control) {
        super.setFlowControl(control);
    }

    @Override
    @Column(name="port_speed")
    public int getPortSpeed() {
        return super.getPortSpeed();
    }

    @Override
    public void setPortSpeed(int newSpeed) {
        super.setPortSpeed(newSpeed);
    }

    @Column(name="ip_port")
    public int getIpPort() {
        return this.ipPort;
    }

    public void setIpPort(int ipPort) {
        this.ipPort = ipPort;
    }

    @ManyToOne
    @JoinColumn(name="fk_config_terminal_location")
    public TerminalLocation getLocation() {
        if (this.location.get() == null) {
            if (this.getHost() == null) {
                this.location.set(TerminalLocation.getDefaultLocation());
            } else {
                this.location.set(this.getHost().getLocation());
            }
        }
        return this.location.get();
    }

    public void setLocation(TerminalLocation loc) {
        if (loc == null) {
            if (this.getHost() == null) {
                this.location.set(TerminalLocation.getDefaultLocation());
            } else {
                this.location.set(this.getHost().getLocation());
            }
        } else {
            this.location.set(loc);
        }
    }

    @Transient
    public boolean isUserPayable() {
        return this.userPayable;
    }

    public void setUserPayable(boolean value) {
        this.userPayable = value;
    }

    public static CashDrawer getOfficeCashDrawer(Terminal term, User user) {
        return CashDrawer.getSystemDrawer(OFFICE_CASH_DRAWER, term, user);
    }

    public static CashDrawer getOnlineCashDrawer(Terminal term, User user) {
        return CashDrawer.getSystemDrawer(ONLINE_CASH_DRAWER, term, user);
    }

    public static CashDrawer getByName(String label) {
        return PersistenceManager.getObject(CashDrawer.class, Query.select(CashDrawer.class).equals(CashDrawer.Properties.LABEL, label).toString());
    }

    private static CashDrawer getSystemDrawer(String label, Terminal term, User user) {
        ObjectQuery query = Query.select(CashDrawer.class).active(CashDrawer.class).equals(CashDrawer.Properties.LABEL, label).limit(1);
        CashDrawer systemDrawer = PersistenceManager.getObject(CashDrawer.class, query.toString(), null);
        if (systemDrawer == null) {
            query = Query.select(CashDrawer.class).equals(CashDrawer.Properties.LABEL, label).limit(1);
            systemDrawer = PersistenceManager.getObject(CashDrawer.class, query.toString(), null);
        }
        if (systemDrawer == null) {
            systemDrawer = new CashDrawer();
            systemDrawer.setLabel(label);
            systemDrawer.setPortType("None");
            systemDrawer.setHost(term);
            systemDrawer.setPort("Test Port");
            systemDrawer.setKickerType(PRINTER_ESCPOS_PIN1_KICKER);
            systemDrawer.setPortSpeed(9600);
            systemDrawer.setFlowControl("DtrDsr");
            systemDrawer.setUserPayable(false);
            systemDrawer.save();
            CashDrawer.checkTerminalCanUseCashDrawer(systemDrawer, term, user);
            if (ONLINE_CASH_DRAWER.equals(label)) {
                CashDrawer.linkToAllWMTerminals(systemDrawer);
            }
            systemDrawer = (CashDrawer)PersistenceManager.reacquire(systemDrawer);
        }
        CashDrawer.checkTerminalCanUseCashDrawer(systemDrawer, term, user);
        if (!systemDrawer.isActive()) {
            systemDrawer.setSystemState("ACTIVE");
            systemDrawer.save();
        }
        return systemDrawer;
    }

    private static void linkToAllWMTerminals(CashDrawer systemDrawer) {
        List<Terminal> terminals = Terminal.getAllWaiterMateTerminals();
        for (Terminal terminal : terminals) {
            if (terminal.getAvailableLogicallyConnectedCashDrawers().contains(systemDrawer)) continue;
            CashDrawer.checkTerminalCanUseCashDrawer(systemDrawer, terminal, null);
            terminal.save();
        }
    }

    public static void checkTerminalCanUseCashDrawer(CashDrawer drawer, Terminal term, User user) {
        if (!drawer.getTerminals().contains(term)) {
            ArrayList<Terminal> termList = new ArrayList<Terminal>();
            termList.addAll(drawer.getTerminals());
            OrderMate.LOG.info("Adding Terminal " + term.getLabel() + " to cash drawer " + drawer.getLabel());
            termList.add(term);
            drawer.setTerminals(termList);
            drawer.save();
            CashDrawer.setCashDrawerUser(drawer, term, user);
        }
    }

    public static List<CashDrawer> getAllCashDrawers() {
        return PersistenceManager.getObjectList(CashDrawer.class, Query.select(CashDrawer.class).active(CashDrawer.class).toString());
    }

    private class RemoteKickerImpl
    extends UnicastRemoteObject
    implements RemoteKicker {
        protected RemoteKickerImpl() throws RemoteException {
        }

        @Override
        public void open() throws RemoteException {
            try {
                if (!StringUtils.isEmpty(CashDrawer.this.getPort())) {
                    Process program = Runtime.getRuntime().exec(CashDrawer.this.getPort());
                    InputStream out = program.getInputStream();
                    while (out.read() != -1) {
                    }
                    InputStream err = program.getErrorStream();
                    while (err.read() != -1) {
                    }
                    program.waitFor();
                    int exitStatus = program.exitValue();
                    if (exitStatus != 0) {
                        OrderMate.LOG.info("Cashdrawer command " + CashDrawer.this.getPort() + " exited with status " + exitStatus);
                    }
                } else {
                    OrderMate.LOG.warn("Couldn't get the port for cashdrawer, getPort() returned empty.");
                }
            }
            catch (Exception e) {
                throw new RemoteException("Error while opening cashdrawer", e);
            }
        }
    }

    private static interface RemoteKicker
    extends Remote {
        public void open() throws RemoteException;
    }

    public static class Props
    extends Device.Props {
        public PropertiedObject.Property KICKER_TYPE;
        public PropertiedObject.Property SYSTEM_STATE;
        public PropertiedObject.Property IP_PORT;
        public PropertiedObject.Property<TerminalLocation> LOCATION;
        public PropertiedObject.Property<Boolean> USER_PAYABLE;
    }
}

