/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.hardware.physical;

import au.com.ordermate.OMLogUtil;
import au.com.ordermate.OrderMateLog;
import au.com.ordermate.networkio.NetworkIO;
import au.com.ordermate.networkio.NotificationDetails;
import au.com.ordermate.networkio.ports.GuiPort;
import au.com.ordermate.networkio.ports.GuiPortFactory;
import au.com.ordermate.networkio.ports.NullPort;
import au.com.ordermate.networkio.ports.OutputPort;
import au.com.ordermate.networkio.ports.ParallelPort;
import au.com.ordermate.networkio.ports.SerialPort;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentDisplayableObject;
import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import javax.persistence.MappedSuperclass;
import javax.persistence.Transient;
import ordermate.OrderMate;
import ordermate.database.hardware.Terminal;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import org.apache.logging.log4j.core.Logger;

@MappedSuperclass
public abstract class Device
extends PersistentDisplayableObject
implements EventListener,
Saveable {
    public static final Props Properties = new Props();
    public static final String SERIAL_PORT = "Serial";
    public static final String PARALLEL_PORT = "Parallel";
    public static final String GUI_PORT = "Gui";
    public static final String NONE_PORT = "None";
    public static final String IP_PORT = "IP";
    public static final String WINDOWS_PORT = "Windows";
    public static final String FLOW_HARDWARE = "DtrDsr";
    public static final String FLOW_XON_XOFF = "XonXoff";
    public static final String FLOW_DELAY = "Delay";
    public static final String FLOW_NONE = "None";
    private static final int WHOZZ_CALLING_PORT = 3520;
    public transient Signal<Device, ?, ?, ?, ?> getData = Signals.createSignal(Device.class, "device");
    private Reference<Terminal> host;
    private String port;
    private String portType;
    private int portSpeed;
    private String flowControl;
    protected PersistentWriteableList<Terminal> terminals;

    public Device() {
        this.host = this.createReference(new PropertiedObject.Property(this.getClass(), Device.Properties.HOST));
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.getData = Signals.createSignal(Device.class, "device");
    }

    public void startup(Terminal localHost) throws Exception {
        Terminal deviceHost = this.host.get();
        if (!localHost.equals(deviceHost)) {
            throw new IllegalStateException("Can only share a device from the PC it is connected to; the given local host '" + localHost.getName() + "' did not match that of the device '" + deviceHost.getName() + "'");
        }
        OutputPort newPort = this.createPort(true);
        NetworkIO.startServer(newPort, OrderMate.LOG_DIR);
        this.setupLog();
    }

    protected OutputPort createPort(boolean addListener) {
        OutputPort out;
        if (this.portType.equalsIgnoreCase(SERIAL_PORT)) {
            out = new SerialPort(this.getPort(), this.getPortSpeed(), addListener, this.getFlowControl());
        } else if (this.portType.equalsIgnoreCase(PARALLEL_PORT)) {
            out = new ParallelPort(this.getPort());
        } else if (this.portType.equalsIgnoreCase("None")) {
            out = new NullPort(this.getPort());
        } else if (this.portType.equalsIgnoreCase(GUI_PORT)) {
            GuiPort guiPort = GuiPortFactory.createGuiPort(this.getPort());
            guiPort.init();
            out = guiPort;
        } else {
            throw new IllegalArgumentException("Cannot start device " + this.getLabel() + " with port type " + this.portType);
        }
        out.getDataAvailableSignal().connect(this, "gotData");
        return out;
    }

    protected void setupLog() throws Exception {
        String safeName = "Port-" + this.port.replaceAll("[^a-zA-Z0-9]", "") + "-" + this.getClass().getSimpleName() + "-output";
        Logger configurePortLog = OrderMateLog.createAppenderForLogger(this.port, OMLogUtil.getDeviceParentFolder(), safeName);
        configurePortLog.setAdditive(false);
    }

    protected final void sendData(String toSend, String description) throws IOException {
        NetworkIO.sendData(toSend, this.getPort(), this.getHost().getRmiPort(), this.getHost().getAddress(), description);
    }

    protected final void sendData(String toSend, String description, NotificationDetails details) throws IOException {
        NetworkIO.sendData(toSend, this.getPort(), this.getHost().getRmiPort(), this.getHost().getAddress(), description, details);
    }

    @Transient
    public String getPort() {
        return this.port;
    }

    public void setPort(String newPort) {
        this.port = newPort;
    }

    @Transient
    public String getPortType() {
        return this.portType;
    }

    public void setPortType(String newPortType) {
        this.portType = newPortType;
    }

    @Transient
    public Terminal getHost() {
        return this.host.get();
    }

    public void setHost(Terminal newHost) {
        this.host.set(newHost);
    }

    @Transient
    public int getPortSpeed() {
        return this.portSpeed;
    }

    public void setPortSpeed(int newSpeed) {
        this.portSpeed = newSpeed;
    }

    @Transient
    public String getFlowControl() {
        return this.flowControl;
    }

    public void setFlowControl(String control) {
        this.flowControl = control;
    }

    public void gotData() {
        this.getData.emit(this);
    }

    public static List<String> getPortTypes() {
        ArrayList<String> types = new ArrayList<String>();
        types.add(SERIAL_PORT);
        types.add(PARALLEL_PORT);
        types.add(GUI_PORT);
        types.add(IP_PORT);
        types.add("None");
        types.add(WINDOWS_PORT);
        return types;
    }

    public static List<String> getFlowControlTypes() {
        ArrayList<String> types = new ArrayList<String>();
        types.add(FLOW_HARDWARE);
        types.add(FLOW_XON_XOFF);
        types.add(FLOW_DELAY);
        types.add("None");
        return types;
    }

    @Transient
    public List<Terminal> getTerminals() {
        if (this.terminals != null) {
            return this.terminals.getUnmodifiable();
        }
        return new ArrayList<Terminal>();
    }

    public void setTerminals(List<Terminal> theTerminals) {
        this.terminals.clear();
        this.terminals.addAll(theTerminals);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
        if (this.terminals != null) {
            this.terminals.saveChild();
        }
    }

    @Override
    public void delete() {
        if (this.terminals != null) {
            this.terminals.deleteChild();
        }
        PersistenceManager.delete(this);
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    public static Integer[] getDefaultSpeeds() {
        return new Integer[]{9600, 19200, 115200, 38400};
    }

    public static class Props
    extends PersistentDisplayableObject.Props {
        public PropertiedObject.Property<Terminal> HOST;
        public PropertiedObject.Property PORT;
        public PropertiedObject.Property PORT_TYPE;
        public PropertiedObject.Property PORT_SPEED;
        public PropertiedObject.Property FLOW_CONTROL;
        public PropertiedObject.Property<Terminal> TERMINALS;
    }
}

