/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.hardware.physical;

import au.com.ordermate.networkio.NotificationDetails;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import java.io.IOException;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import ordermate.database.docket.AbstractDocket;
import ordermate.database.hardware.physical.Device;
import ordermate.database.hardware.physical.PhysicalPrintDeviceType;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Entity
@Table(name="config_printer")
@DiscriminatorColumn(name="print_device_type")
public abstract class PhysicalPrintDevice
extends Device {
    public static final Props Properties = new Props();
    private PhysicalPrintDeviceType printDeviceType;
    private String systemState = "ACTIVE";
    private Reference<PhysicalPrintDevice> backupPrinter;

    public PhysicalPrintDevice() {
        this.backupPrinter = this.createReference(PhysicalPrintDevice.Properties.BACKUP_PRINTER);
    }

    public abstract void print(AbstractDocket var1, NotificationDetails var2) throws IOException;

    public abstract boolean canPrint(AbstractDocket var1);

    @Transient
    protected abstract PhysicalPrintDeviceType getDeviceType();

    public static List<PhysicalPrintDevice> getAllActivePrintDevices() {
        String sql = Query.select(PhysicalPrintDevice.class).active(PhysicalPrintDevice.class).orderBy(PhysicalPrintDevice.Properties.LABEL).toString();
        List<PhysicalPrintDevice> printers = PersistenceManager.getObjectList(PhysicalPrintDevice.class, sql, null);
        return printers;
    }

    public static PhysicalPrintDevice getPrintDeviceByLabel(String label) {
        return PersistenceManager.getObject(PhysicalPrintDevice.class, Query.select(PhysicalPrintDevice.class).equals(PhysicalPrintDevice.Properties.LABEL, label).toString());
    }

    @Column(name="system_state")
    public String getSystemState() {
        return this.systemState;
    }

    protected void setSystemState(String value) {
        this.systemState = value;
    }

    @ManyToOne
    @JoinColumn(name="FK_config_printer_backup")
    public PhysicalPrintDevice getBackupPrinter() {
        return this.backupPrinter.get();
    }

    public void setBackupPrinter(PhysicalPrintDevice backup) {
        this.backupPrinter.set(backup);
    }

    @Override
    public void delete() {
        this.systemState = "DELETED";
        this.save();
    }

    @Column(name="print_device_type", insertable=false, updatable=false)
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.EnumMapping", parameters={@Parameter(name="enumClass", value="ordermate.database.hardware.physical.PhysicalPrintDeviceType")})
    public PhysicalPrintDeviceType getPrintDeviceType() {
        return this.printDeviceType == null ? (this.printDeviceType = this.getDeviceType()) : this.printDeviceType;
    }

    protected void setPrintDeviceType(PhysicalPrintDeviceType newType) {
        this.printDeviceType = newType;
    }

    public static class Props
    extends Device.Props {
        public PropertiedObject.Property<PhysicalPrintDevice> BACKUP_PRINTER;
        public PropertiedObject.Property<String> SYSTEM_STATE;
    }
}

