/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.hardware.physical;

import au.com.ordermate.dockets.CBMCommander;
import au.com.ordermate.dockets.CharacterProcessor;
import au.com.ordermate.dockets.CommandSet;
import au.com.ordermate.dockets.DebugCommander;
import au.com.ordermate.dockets.ESCPOSCommander;
import au.com.ordermate.dockets.PrintCommanderInterface;
import au.com.ordermate.dockets.ThaiCharacterProcessor;
import au.com.ordermate.dockets.XMLDocketScanner;
import au.com.ordermate.dockets.international.ArabicPrinterStringifier;
import au.com.ordermate.dockets.international.FarsiPrinterStringifier;
import au.com.ordermate.networkio.NetworkIO;
import au.com.ordermate.networkio.NotificationDetails;
import au.com.ordermate.networkio.ports.IPPort;
import au.com.ordermate.networkio.ports.NullPort;
import au.com.ordermate.networkio.ports.OutputPort;
import au.com.ordermate.networkio.ports.ParallelPort;
import au.com.ordermate.networkio.ports.SerialPort;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.Auditable;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.reports.AbstractReport;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.persistence.AttributeOverride;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.HashPrintServiceAttributeSet;
import javax.print.attribute.standard.PrinterName;
import javax.swing.JFrame;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.export.JRPrintServiceExporter;
import net.sf.jasperreports.engine.export.JRPrintServiceExporterParameter;
import ordermate.OrderMate;
import ordermate.database.docket.AbstractDocket;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.physical.PhysicalPrintDevice;
import ordermate.database.hardware.physical.PhysicalPrintDeviceType;
import ordermate.database.hardware.physical.PrinterCommandSet;
import ordermate.database.hardware.physical.PrinterEncoding;
import ordermate.database.misc.SystemProperty;
import ordermate.dockets.groovy.DiscardDocket;
import ordermate.dockets.groovy.StartUpDocket;
import ordermate.dockets.groovy.XmlDocket;
import org.hibernate.annotations.AccessType;
import org.xml.sax.SAXException;

@Entity
@AccessType(value="property")
@DiscriminatorValue(value="PHYSICAL_PRINTER")
@AttributeOverride(name="label", column=@Column(name="Name"))
public class PhysicalPrinter
extends PhysicalPrintDevice
implements Auditable {
    public static final String WINDOWS_PRINTER = "Windows";
    public static final Props Properties = new Props();
    private PrinterEncoding encoding;
    private PrinterCommandSet commandSet;
    private boolean supportsGraphics;
    private int width;
    private int linesAtEnd;
    private int charTable;
    private transient PrintCommanderInterface commanderInterface;
    private transient String discardCommand;
    private transient CharacterProcessor cp;
    private int ipPort = 9100;

    @Override
    @Transient
    public String getLogDetail() {
        StringBuilder sb = new StringBuilder();
        sb.append("Label(").append(this.getLabel()).append("),").append("Host(").append(this.getHost()).append("),").append("Port(").append(this.getPort()).append("),").append("IP Port(").append(this.getIpPort()).append("),").append("Graphics(").append(this.getSupportsGraphics()).append("),").append("Port Speed(").append(this.getPortSpeed()).append("),").append("Width(").append(this.getWidth()).append("),").append("End Lines(").append(this.getLinesAtEnd()).append("),").append("Backup(").append(this.getBackupPrinter()).append(")");
        return sb.toString();
    }

    @Override
    public void init() {
        if (PrinterEncoding.Thai.equals((Object)this.encoding)) {
            this.charTable = 21;
            this.cp = new ThaiCharacterProcessor();
        }
        super.init();
    }

    @Override
    public final void startup(Terminal localHost) throws Exception {
        if (!this.getPortType().equals(WINDOWS_PRINTER)) {
            if (!NetworkIO.hasServer(this.getPort())) {
                super.startup(localHost);
            }
            if (!PrinterCommandSet.Debug.equals((Object)this.commandSet)) {
                CommandSet commandSet = this.getPrintCommanderInterface().getCommandsSet();
                this.sendData(commandSet.getSelectCharacterTable(this.charTable), "Setting character code table");
            }
            this.getPrintCommanderInterface().clear();
            StartUpDocket gDocket = new StartUpDocket();
            List<PhysicalPrinter> params = Collections.singletonList(this);
            gDocket.setParams(params);
            String toPrint = this.getDocketData(gDocket);
            if (toPrint != null) {
                this.sendData(toPrint, "Printer startup docket");
            }
        }
    }

    public void setCommandSet(PrinterCommandSet value) {
        this.commandSet = value != null ? value : PrinterCommandSet.ESCPOS;
    }

    @Column(name="command_set")
    @Enumerated(value=EnumType.STRING)
    public PrinterCommandSet getCommandSet() {
        return this.commandSet;
    }

    @Transient
    public String getDiscardCommand() {
        if (this.discardCommand == null) {
            DiscardDocket gDocket = new DiscardDocket();
            this.discardCommand = this.getDocketData(gDocket);
            if (this.discardCommand == null) {
                this.discardCommand = "";
            }
        }
        return this.discardCommand;
    }

    @Column(name="Graphics")
    public boolean getSupportsGraphics() {
        return this.supportsGraphics;
    }

    public void setSupportsGraphics(boolean canSupport) {
        this.supportsGraphics = canSupport;
    }

    @Transient
    public PrintCommanderInterface getPrintCommanderInterface() {
        if (this.commanderInterface == null) {
            switch (this.commandSet) {
                case ESCPOS: {
                    this.commanderInterface = new ESCPOSCommander(this.width, this.supportsGraphics, this.linesAtEnd, this.cp);
                    break;
                }
                case CBM: {
                    this.commanderInterface = new CBMCommander(this.width, this.linesAtEnd, this.cp);
                    break;
                }
                case Debug: {
                    this.commanderInterface = new DebugCommander(60, this.linesAtEnd);
                    break;
                }
                case Html: {
                    this.commanderInterface = new DebugCommander(60, this.linesAtEnd);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Cannot initialise printer " + this.getLabel() + " with invalid char set: \"" + (Object)((Object)this.commandSet) + "\"");
                }
            }
        }
        return this.commanderInterface;
    }

    public void setWidth(int w) {
        this.width = w;
    }

    @Column(name="width")
    public int getWidth() {
        return this.width;
    }

    @Column(name="encoding")
    @Enumerated(value=EnumType.STRING)
    public PrinterEncoding getEncoding() {
        return this.encoding;
    }

    public void setEncoding(PrinterEncoding value) {
        this.encoding = value;
    }

    @Transient
    public int getCharacterTable() {
        return this.charTable;
    }

    @Override
    protected final OutputPort createPort(boolean addListener) {
        String encoding;
        String string = encoding = this.getEncoding().isEncoded() ? this.getEncoding().getEncodingValue() : null;
        OutputPort out = this.getPortType().equalsIgnoreCase("Serial") ? new SerialPort(this.getPort(), this.getPortSpeed(), addListener, 1000, this.getFlowControl(), encoding) : (this.getPortType().equalsIgnoreCase("Parallel") ? new ParallelPort(this.getPort(), 1000, this.getEncoding().getEncodingValue()) : (this.getPortType().equalsIgnoreCase(WINDOWS_PRINTER) ? new NullPort(this.getPort()) : (this.getPortType().equalsIgnoreCase("IP") ? new IPPort(this.getPort(), this.getIpPort(), this.getEncoding().getEncodingValue()) : super.createPort(addListener))));
        out.setErrorCommandString(this.getDiscardCommand());
        return out;
    }

    public void print(final AbstractReport toPrint, final String description) throws IOException {
        if (this.getPortType().equals("Gui")) {
            JFrame reportDisplay = new JFrame();
            reportDisplay.setContentPane(toPrint.getReportViewer());
            reportDisplay.setSize(800, 600);
            reportDisplay.setVisible(true);
            return;
        }
        if (!this.getPortType().equals(WINDOWS_PRINTER)) {
            throw new UnsupportedOperationException("Cannot send reports to printers of type " + this.getPortType() + " can only send strings");
        }
        OrderMate.LOG.info("Starting printing " + description + " to windows printer '" + this.getPort() + "'");
        HashPrintServiceAttributeSet printerNameAttributeSet = new HashPrintServiceAttributeSet();
        printerNameAttributeSet.add(new PrinterName(this.getPort(), Locale.getDefault()));
        final PrintService[] matchingServices = PrintServiceLookup.lookupPrintServices(DocFlavor.SERVICE_FORMATTED.PRINTABLE, printerNameAttributeSet);
        if (matchingServices.length > 1) {
            throw new IOException("More than one printer matches the name '" + this.getPort() + "'");
        }
        if (matchingServices.length == 0) {
            throw new IOException("Could not find printer with name " + this.getPort() + "'");
        }
        Thread reportPrintingThread = new Thread(new Runnable(){

            @Override
            public void run() {
                OrderMate.LOG.info("Starting thread to print " + description + " to windows printer '" + PhysicalPrinter.this.getPort() + "'");
                JRPrintServiceExporter reportPrintExporter = new JRPrintServiceExporter();
                reportPrintExporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)toPrint.getReport());
                reportPrintExporter.setParameter((JRExporterParameter)JRPrintServiceExporterParameter.PRINT_SERVICE, (Object)matchingServices[0]);
                try {
                    reportPrintExporter.exportReport();
                    OrderMate.LOG.info("Done printing " + description + " to windows printer '" + PhysicalPrinter.this.getPort() + "'");
                }
                catch (JRException e) {
                    OrderMate.LOG.error("Error printing to windows printer '" + PhysicalPrinter.this.getPort() + "'", (Throwable)e);
                }
            }
        }, "Printing '" + description + "' dockets");
        reportPrintingThread.start();
    }

    public void print(AbstractDocket docket) throws IOException {
        this.print(docket, null);
    }

    @Override
    public void print(AbstractDocket docket, NotificationDetails details) throws IOException {
        if (this.getPortType().equals(WINDOWS_PRINTER)) {
            throw new UnsupportedOperationException("Cannot send strings to windows printers, can only send Reports");
        }
        if (SystemProperty.getInstance().getPrintBigChinese() && this.commandSet.equals((Object)PrinterCommandSet.ESCPOS)) {
            if (docket.getDocketType().equals("PREP")) {
                ((ESCPOSCommander)this.getPrintCommanderInterface()).setBigChinese(true);
            } else {
                ((ESCPOSCommander)this.getPrintCommanderInterface()).setBigChinese(false);
            }
        }
        this.getPrintCommanderInterface().clear();
        XMLDocketScanner scanner = this.makeScanner();
        String cmdString = null;
        try {
            cmdString = scanner.visitDocument(docket.getXMLPhase1(), docket.isReprint());
        }
        catch (ParserConfigurationException e) {
            OrderMate.LOG.error("Error printing docket :" + docket + " aborting docket print.", (Throwable)e);
        }
        catch (SAXException e) {
            OrderMate.LOG.error("Error printing docket :" + docket + " aborting docket print.", (Throwable)e);
        }
        catch (IOException e) {
            OrderMate.LOG.error("Could not read docket " + docket.toString() + " aborting docket print", (Throwable)e);
        }
        this.sendData(cmdString, docket.getDescription(), details);
    }

    private XMLDocketScanner makeScanner() {
        XMLDocketScanner scanner = new XMLDocketScanner(this.getPrintCommanderInterface());
        if (PrinterEncoding.ArabicOM.equals((Object)this.getEncoding())) {
            scanner.setStringifier(new ArabicPrinterStringifier());
        } else if (PrinterEncoding.FarsiOM.equals((Object)this.getEncoding())) {
            scanner.setStringifier(new FarsiPrinterStringifier());
        }
        return scanner;
    }

    @Override
    @Transient
    public String getIcon() {
        return "/waitermate/guikit/images/print.png";
    }

    public static List<PhysicalPrinter> getAllPrinters() {
        String sql = Query.select(PhysicalPrinter.class).active(PhysicalPrinter.class).orderBy(PhysicalPrinter.Properties.LABEL).toString();
        List<PhysicalPrinter> printers = PersistenceManager.getObjectList(PhysicalPrinter.class, sql, null);
        return printers;
    }

    @Column(name="end_lines")
    public int getLinesAtEnd() {
        return this.linesAtEnd;
    }

    public void setLinesAtEnd(int end) {
        this.linesAtEnd = end;
    }

    private String getDocketData(XmlDocket gDocket) {
        String xml = gDocket.generateXml();
        XMLDocketScanner scanner = this.makeScanner();
        String toPrint = null;
        try {
            toPrint = scanner.visitDocument(xml, false);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            OrderMate.LOG.error((Object)parserConfigurationException);
        }
        catch (SAXException saxException) {
            OrderMate.LOG.error("Incorrect xml content: " + xml, (Throwable)saxException);
        }
        catch (IOException iOException) {
            OrderMate.LOG.error((Object)iOException);
        }
        return toPrint;
    }

    @Column(name="character_table")
    protected int getCharTable() {
        return this.charTable;
    }

    protected void setCharTable(int newCharTable) {
        this.charTable = newCharTable;
    }

    @Override
    @ManyToOne
    @JoinColumn(name="FK_config_terminal")
    public Terminal getHost() {
        return super.getHost();
    }

    @Override
    public void setHost(Terminal newHost) {
        super.setHost(newHost);
    }

    @Override
    @Column(name="port")
    public String getPort() {
        return super.getPort();
    }

    @Override
    public void setPort(String newPort) {
        super.setPort(newPort);
    }

    @Override
    @Column(name="port_type")
    public String getPortType() {
        return super.getPortType();
    }

    @Override
    public void setPortType(String newPortType) {
        super.setPortType(newPortType);
    }

    @Override
    @Column(name="flow_control")
    public String getFlowControl() {
        return super.getFlowControl();
    }

    @Override
    public void setFlowControl(String control) {
        super.setFlowControl(control);
    }

    @Override
    @Column(name="port_speed")
    public int getPortSpeed() {
        return super.getPortSpeed();
    }

    @Override
    public void setPortSpeed(int newSpeed) {
        super.setPortSpeed(newSpeed);
    }

    @Override
    public boolean canPrint(AbstractDocket docket) {
        return true;
    }

    @Override
    @Transient
    protected PhysicalPrintDeviceType getDeviceType() {
        return PhysicalPrintDeviceType.physicalPrinter;
    }

    @Column(name="ip_port")
    public int getIpPort() {
        return this.ipPort;
    }

    public void setIpPort(int ipPort) {
        this.ipPort = ipPort;
    }

    @Override
    @Transient
    public String getAuditName() {
        return "Physical Printer";
    }

    public static class Props
    extends PhysicalPrintDevice.Props {
        public PropertiedObject.Property COMMAND_SET;
        public PropertiedObject.Property SUPPORTS_GRAPHICS;
        public PropertiedObject.Property WIDTH;
        public PropertiedObject.Property LINES_AT_END;
        public PropertiedObject.Property<PrinterEncoding> ENCODING;
        public PropertiedObject.Property CHAR_TABLE;
        public PropertiedObject.Property IP_PORT;
    }
}

