/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.hardware.physical;

import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.util.Price;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import ordermate.OrderMate;
import ordermate.database.finance.FinanceInfo;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.physical.Device;
import ordermate.database.misc.SystemProperty;
import org.hibernate.annotations.AccessType;

@Entity
@Table(name="config_pole")
@AccessType(value="property")
public class PoleDisplay
extends Device
implements FinanceInfo {
    private static final String DEFAULT_LINE_ONE = "Powered by OrderMate";
    private static final String DEFAULT_LINE_TWO = "www.ordermate.com.au";
    private String LINE_ONE;
    private String LINE_TWO;
    private static final int WIDTH = 20;
    private static long WAIT_TO_CLEAN_TIME = 15000L;
    public static final Props Properties = new Props();
    private transient Timer timer;
    private transient TimerTask clearTask;
    private String firstLine;
    private String secondLine;
    private Semaphore latch = new Semaphore(1);

    public PoleDisplay() {
        this.terminals = (PersistentWriteableList)this.createList(PoleDisplay.Properties.TERMINALS);
    }

    @Override
    public synchronized void startup(Terminal localHost) throws Exception {
        super.startup(localHost);
        this.showDefaultText();
    }

    public synchronized void showDefaultText() {
        SystemProperty info = SystemProperty.getInstance();
        if (info.getPoleDefaultLine1() != null) {
            this.LINE_ONE = info.getPoleDefaultLine1();
            this.LINE_TWO = info.getPoleDefaultLine2();
        } else {
            this.LINE_ONE = DEFAULT_LINE_ONE;
            this.LINE_TWO = DEFAULT_LINE_TWO;
        }
        this.firstLine = "\u001b@" + this.padCenter(this.LINE_ONE);
        this.secondLine = this.padCenter(this.LINE_TWO);
        this.render();
    }

    public synchronized void setFirstLine(String line) {
        this.setFirstLine(line, false);
    }

    public synchronized void setFirstLine(String line, boolean center) {
        this.firstLine = center ? this.padCenter(line) : this.pad(line);
        this.render();
        this.restartClearCountdown();
    }

    public synchronized void setSecondLine(String line) {
        this.setSecondLine(line, false);
    }

    public synchronized void setSecondLine(String line, boolean center) {
        this.secondLine = center ? this.padCenter(line) : this.pad(line);
        this.render();
        this.restartClearCountdown();
    }

    @Override
    public synchronized void setFinanceInfo(Price newTotal, Price due, Price newPaid, Price newTendered, Price change, Price remaining) {
        final String newFirstLine = "Total: " + newTotal;
        final String newSecondLine = !change.isZero() ? "Change : " + change : "";
        Runnable sendToPole = new Runnable(){

            @Override
            public void run() {
                try {
                    if (PoleDisplay.this.latch.tryAcquire(3L, TimeUnit.SECONDS)) {
                        PoleDisplay.this.setFirstLine(newFirstLine);
                        PoleDisplay.this.setSecondLine(newSecondLine);
                    }
                }
                catch (Exception ex) {
                    OrderMate.LOG.error("Couldn't send message to pole", (Throwable)ex);
                }
            }
        };
        new Thread(sendToPole).start();
    }

    private String pad(String toPad) {
        String toReturn;
        if (toPad.length() > 20) {
            toReturn = toPad.substring(0, 21);
        } else {
            StringBuffer buf = new StringBuffer(toPad);
            for (int i = 0; i < 20 - toPad.length(); ++i) {
                buf.append(' ');
            }
            toReturn = buf.toString();
        }
        return toReturn;
    }

    private String padCenter(String toPad) {
        String toReturn;
        if (toPad.length() > 20) {
            toReturn = toPad.substring(0, 21);
        } else {
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < (20 - toPad.length()) / 2; ++i) {
                buf.append(' ');
            }
            buf.append(toPad);
            toReturn = buf.toString();
        }
        return toReturn;
    }

    private void render() {
        try {
            this.sendData("\u001f$\u0001\u0001" + this.firstLine + "\u001f$\u0001\u0002" + this.secondLine, "Pole display update");
        }
        catch (Exception e) {
            OrderMate.LOG.error("Error displaying to pole on" + this.getPort(), (Throwable)e);
        }
    }

    private void restartClearCountdown() {
        if (this.timer == null) {
            this.timer = new Timer();
        }
        if (this.clearTask != null) {
            this.clearTask.cancel();
        }
        this.clearTask = new ClearTask();
        this.timer.schedule(this.clearTask, WAIT_TO_CLEAN_TIME);
    }

    public static void showOnAllPoles(String lineOne, String lineTwo, Terminal localHost) {
        List<PoleDisplay> poles = localHost.getAvailablePoleDisplays();
        for (PoleDisplay pole : poles) {
            pole.setFirstLine(lineOne);
            pole.setSecondLine(lineTwo);
        }
    }

    public static void setAllPolesToDefault(Terminal localHost) {
        List<PoleDisplay> poles = localHost.getAvailablePoleDisplays();
        for (PoleDisplay pole : poles) {
            pole.showDefaultText();
        }
    }

    @Override
    @ManyToOne
    @JoinColumn(name="FK_config_terminal")
    public Terminal getHost() {
        return super.getHost();
    }

    @Override
    @Column(name="port")
    public String getPort() {
        return super.getPort();
    }

    @Override
    @Column(name="port_speed")
    public int getPortSpeed() {
        return super.getPortSpeed();
    }

    @Override
    @Column(name="port_type")
    public String getPortType() {
        return super.getPortType();
    }

    @Override
    @Column(name="flow_control")
    public void setFlowControl(String control) {
        super.setFlowControl(control);
    }

    @Override
    public void setHost(Terminal newHost) {
        super.setHost(newHost);
    }

    @Override
    public void setPort(String newPort) {
        super.setPort(newPort);
    }

    @Override
    public void setPortSpeed(int newSpeed) {
        super.setPortSpeed(newSpeed);
    }

    @Override
    public void setPortType(String newPortType) {
        super.setPortType(newPortType);
    }

    private class ClearTask
    extends TimerTask {
        private ClearTask() {
        }

        @Override
        public void run() {
            PoleDisplay.this.showDefaultText();
        }
    }

    public static class Props
    extends Device.Props {
    }
}

