/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.hardware.physical;

import au.com.ordermate.persistence.PersistentEnumeration;
import java.util.Map;

public enum PrinterEncoding {
    Standard(null, "Standard", false),
    ChineseSimple("GB18030", "Chinese Simple", true),
    ChineseTraditional("Big5", "Chinese Traditional", true),
    Thai("TIS620", "Thai", false),
    Arabic("ISO-8859-6", "Arabic", true),
    ArabicWindows("Windows-1256", "Arabic - 1256", true),
    ArabicOM("Arabic-OrderMate", "Arabic - OrderMate", false),
    FarsiOM("ISO-8859-1", "Farsi - OrderMate", false);

    public static final Map<String, PrinterEncoding> register;
    private final String label;
    private final String encodingValue;
    private final boolean isEncoded;

    private PrinterEncoding(String encoding, String label, boolean isEncoded) {
        this.label = label;
        this.encodingValue = encoding;
        this.isEncoded = isEncoded;
    }

    public String getLabel() {
        return this.label;
    }

    public String getEncodingValue() {
        return this.encodingValue;
    }

    public String toString() {
        return this.encodingValue;
    }

    public boolean isEncoded() {
        return this.isEncoded;
    }

    static {
        register = PersistentEnumeration.buildRegister(PrinterEncoding.values());
    }
}

