/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.hardware.physical;

import au.com.ordermate.networkio.ports.OutputPort;
import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.util.StringUtils;
import java.util.Arrays;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import ordermate.OrderMate;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.physical.Device;
import org.hibernate.annotations.AccessType;

@Entity
@Table(name="config_proximity")
@AccessType(value="property")
public class ProximityReader
extends Device {
    public static final Props Properties = new Props();
    public static final String PROXIMITY_READER_PREFIX = "!";
    private transient OutputPort outputPort;

    public ProximityReader() {
        this.terminals = (PersistentWriteableList)this.createList(ProximityReader.Properties.TERMINALS);
    }

    @Override
    public void startup(Terminal localHost) throws Exception {
        if (!localHost.equals(this.getHost())) {
            throw new IllegalStateException("Can only share a device from the PC it is connected to");
        }
        this.outputPort = this.createPort(true);
        this.outputPort.openConnection();
    }

    @Transient
    public String getDataAsString() {
        int PROX_SCAN_LEN = 13;
        int beginScanDelimiter = 63;
        String userName = "";
        if (this.hasData()) {
            byte[] userNameBytes = new byte[13];
            try {
                userNameBytes = this.outputPort.receiveBytes(13);
                if (userNameBytes == null || userNameBytes.length == 0 || userNameBytes[0] != 63) {
                    return "";
                }
                int[] bytesToRemove = new int[]{0};
                byte[] finalBytes = StringUtils.removeBytesFromArray(userNameBytes, bytesToRemove);
                finalBytes = Arrays.copyOf(finalBytes, 10);
                userName = StringUtils.byteArrayToHexString(finalBytes);
                userName = PROXIMITY_READER_PREFIX + userName;
            }
            catch (Exception e) {
                OrderMate.LOG.error("Error reading data from Proximity Reader", (Throwable)e);
            }
        }
        return userName;
    }

    public boolean hasData() {
        try {
            return this.outputPort.hasData();
        }
        catch (Exception e) {
            OrderMate.LOG.error("Error reading data from Proximity Reader", (Throwable)e);
            return false;
        }
    }

    @Override
    @ManyToOne
    @JoinColumn(name="FK_config_terminal")
    public Terminal getHost() {
        return super.getHost();
    }

    @Override
    public void setHost(Terminal newHost) {
        super.setHost(newHost);
    }

    @Override
    @Column(name="port")
    public String getPort() {
        return super.getPort();
    }

    @Override
    public void setPort(String newPort) {
        super.setPort(newPort);
    }

    @Override
    @Column(name="port_type")
    public String getPortType() {
        return super.getPortType();
    }

    @Override
    public void setPortType(String newPortType) {
        super.setPortType(newPortType);
    }

    @Override
    @Column(name="flow_control")
    public String getFlowControl() {
        return super.getFlowControl();
    }

    @Override
    public void setFlowControl(String control) {
        super.setFlowControl(control);
    }

    @Override
    @Column(name="port_speed")
    public int getPortSpeed() {
        return super.getPortSpeed();
    }

    @Override
    public void setPortSpeed(int newSpeed) {
        super.setPortSpeed(newSpeed);
    }

    public static class Props
    extends Device.Props {
    }
}

