/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.hardware.physical;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentDisplayableObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.util.StringUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.eftpos.EftposPrintReceiptType;
import ordermate.database.hardware.eftpos.EftposType;
import ordermate.database.hardware.eftpos.PhysicalEftpos;
import ordermate.database.hardware.physical.CashDrawer;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Entity
@Table(name="config_virtual_eftpos")
@AccessType(value="property")
public class VirtualEftpos
extends PersistentDisplayableObject
implements Saveable {
    public static final String DEFAULT_IP = "127.0.0.1";
    public static final int DEFAULT_PORT = 2011;
    public static final String DEFAULT_FS_DIR = "C:\\Tyro\\FileWatcher\\";
    public static final int DEFAULT_TIMEOUT = 90000;
    public static final Props Properties = new Props();
    private String ipAddress = "127.0.0.1";
    private String fileSwapDirectory = "C:\\Tyro\\FileWatcher\\";
    private int port = 2011;
    private int timeoutMillis = 90000;
    private SystemState systemState = SystemState.ACTIVE_STATE;
    private Reference<CashDrawer> cashDrawer;
    private EftposType eftposType;
    private transient PhysicalEftpos physicalEftpos;
    private String lastTxnReference;
    private boolean online;
    private boolean enableTip;
    private String terminalId;
    private String merchantId;
    private String pairingKeys;
    private boolean printReceipts;
    private boolean autoSurcharge;
    private String pollingUrl;
    private boolean supportsCardAcq;
    private boolean testing;
    private Reference<Terminal> preferredTerminal;
    private String lastConnectedBank;
    private String pairUsername;
    private String pairPassword;
    private EftposPrintReceiptType printReceiptType;
    private String hmacKey;
    private String encKey;
    private transient Map<Long, String> pairingMap;

    public VirtualEftpos() {
        this.cashDrawer = this.createReference(VirtualEftpos.Properties.CASH_DRAWER);
        this.eftposType = EftposType.INGENICO;
        this.online = true;
        this.enableTip = false;
        this.autoSurcharge = false;
        this.supportsCardAcq = false;
        this.testing = false;
        this.preferredTerminal = this.createReference(VirtualEftpos.Properties.PREFERRED_TERMINAL);
        this.printReceiptType = EftposPrintReceiptType.NEVER_PRINT;
    }

    @Column(name="hmac_key")
    public String getHmacKey() {
        return this.hmacKey;
    }

    public void setHmacKey(String hmac) {
        this.hmacKey = hmac;
    }

    @Column(name="enc_key")
    public String getEncKey() {
        return this.encKey;
    }

    public void setEncKey(String encKey) {
        this.encKey = encKey;
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.EnumMapping", parameters={@Parameter(name="enumClass", value="ordermate.database.hardware.eftpos.EftposType")})
    @Column(name="eftpos_type")
    public EftposType getEftposType() {
        return this.eftposType;
    }

    public void setEftposType(EftposType value) {
        if (this.eftposType != value) {
            this.physicalEftpos = null;
        }
        this.eftposType = value;
    }

    @Column(name="ip_address")
    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String terminalIPAddress) {
        this.ipAddress = terminalIPAddress;
    }

    @Column(name="port")
    public int getPort() {
        return this.port;
    }

    public void setPort(int thePort) {
        this.port = thePort;
    }

    @Column(name="timeout_millis")
    public int getTimeoutMillis() {
        return this.timeoutMillis;
    }

    public void setTimeoutMillis(int value) {
        this.timeoutMillis = value;
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.SystemStateMapping")
    @Column(name="system_state")
    public SystemState getSystemState() {
        return this.systemState;
    }

    public void setSystemState(SystemState newValue) {
        this.systemState = newValue;
    }

    @ManyToOne
    @JoinColumn(name="fk_config_cashdrawer")
    public CashDrawer getCashDrawer() {
        return this.cashDrawer.get();
    }

    public void setCashDrawer(CashDrawer drawer) {
        this.cashDrawer.set(drawer);
    }

    @ManyToOne
    @JoinColumn(name="fk_config_terminal")
    public Terminal getPreferredTerminal() {
        return this.preferredTerminal.get();
    }

    public void setPreferredTerminal(Terminal term) {
        this.preferredTerminal.set(term);
    }

    @Column(name="file_swap_directory")
    public String getFileSwapDirectory() {
        return this.fileSwapDirectory;
    }

    public void setFileSwapDirectory(String value) {
        this.fileSwapDirectory = value;
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
    }

    @Override
    public void delete() {
        this.systemState = SystemState.DELETED_STATE;
        PersistenceManager.save(this);
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Column(name="last_txn_reference")
    public String getLastTxnReference() {
        return this.lastTxnReference;
    }

    public void setLastTxnReference(String value) {
        this.lastTxnReference = value;
    }

    @Column(name="terminal_id")
    public String getTerminalId() {
        return this.terminalId;
    }

    public void setTerminalId(String value) {
        this.terminalId = value;
    }

    @Column(name="merchant_id")
    public String getMerchantId() {
        return this.merchantId;
    }

    public void setMerchantId(String value) {
        this.merchantId = value;
    }

    @Column(name="online")
    public boolean isOnline() {
        return this.online;
    }

    public void setOnline(boolean value) {
        this.online = value;
    }

    @Column(name="enable_tip")
    public boolean isEnableTip() {
        return this.enableTip;
    }

    public void setEnableTip(boolean value) {
        this.enableTip = value;
    }

    @Column(name="pairing_keys")
    public String getPairingKeys() {
        return this.pairingKeys;
    }

    public void setPairingKeys(String value) {
        this.pairingKeys = value;
    }

    public void addPairingKey(Terminal terminal, String key) {
        this.buildPairMap();
        this.pairingMap.put(terminal.getID(), key);
        this.updateKeys();
    }

    public void removePairingKey(Terminal terminal) {
        this.buildPairMap();
        this.pairingMap.remove(terminal.getID());
        this.updateKeys();
    }

    private void buildPairMap() {
        if (this.pairingMap == null) {
            this.pairingMap = new HashMap<Long, String>();
            if (!StringUtils.isEmpty(this.pairingKeys)) {
                for (String pair : StringUtils.splitToList(this.pairingKeys, ",")) {
                    String[] parts = pair.split("=");
                    if (parts.length != 2) continue;
                    this.pairingMap.put(Long.parseLong(parts[0]), parts[1]);
                }
            }
        }
    }

    private void updateKeys() {
        if (this.pairingMap == null) {
            this.pairingKeys = null;
        } else {
            StringBuilder SB = new StringBuilder();
            for (Long nextKey : this.pairingMap.keySet()) {
                SB.append(nextKey).append("=").append(this.pairingMap.get(nextKey)).append(",");
            }
            this.pairingKeys = SB.toString();
        }
    }

    public void reset() {
        this.physicalEftpos.closeOff();
        this.physicalEftpos = null;
    }

    @Transient
    public Map<Long, String> getPairingMap() {
        this.buildPairMap();
        return Collections.unmodifiableMap(this.pairingMap);
    }

    @Column(name="print_receipts")
    public boolean isPrintReceipts() {
        return this.printReceipts;
    }

    public void setPrintReceipts(boolean value) {
        this.printReceipts = value;
    }

    @Column(name="auto_surcharge")
    public boolean isAutoSurcharge() {
        return this.autoSurcharge;
    }

    public void setAutoSurcharge(boolean value) {
        this.autoSurcharge = value;
    }

    @Transient
    public boolean isAlreadyPaired() {
        return !StringUtils.isEmpty(this.getHmacKey()) && !StringUtils.isEmpty(this.getEncKey());
    }

    @Column(name="polling_url")
    public String getPollingUrl() {
        return this.pollingUrl;
    }

    public void setPollingUrl(String pollingUrl) {
        this.pollingUrl = pollingUrl;
    }

    @Transient
    public boolean isSupportsCardAcq() {
        return this.supportsCardAcq;
    }

    public void setSupportsCardAcq(boolean supportsCardAcq) {
        this.supportsCardAcq = supportsCardAcq;
    }

    @Transient
    public boolean isTesting() {
        return this.testing;
    }

    public void setTesting(boolean testing) {
        this.testing = testing;
    }

    @Transient
    public String getLastConnectedBank() {
        return this.lastConnectedBank;
    }

    public void setLastConnectedBank(String lastConnectedBank) {
        this.lastConnectedBank = lastConnectedBank;
    }

    @Transient
    public EftposPrintReceiptType getPrintReceiptType() {
        return this.printReceiptType;
    }

    public void setPrintReceiptType(EftposPrintReceiptType printReceiptType) {
        this.printReceiptType = printReceiptType;
    }

    @Transient
    public String getPairUsername() {
        return this.pairUsername;
    }

    @Transient
    public String getPairPassword() {
        return this.pairPassword;
    }

    public void setPairUsername(String pairUsername) {
        this.pairUsername = pairUsername;
    }

    public void setPairPassword(String pairPassword) {
        this.pairPassword = pairPassword;
    }

    public static class Props
    extends PersistentDisplayableObject.Props {
        public PropertiedObject.Property PORT;
        public PropertiedObject.Property<String> IP_ADDRESS;
        public PropertiedObject.Property<String> FILE_SWAP_DIRECTORY;
        public PropertiedObject.Property TIMEOUT_MILLIS;
        public PropertiedObject.Property<CashDrawer> CASH_DRAWER;
        public PropertiedObject.Property<EftposType> EFTPOS_TYPE;
        public PropertiedObject.Property<String> LAST_TXN_REFERENCE;
        public PropertiedObject.Property<Boolean> ONLINE;
        public PropertiedObject.Property<String> TERMINAL_ID;
        public PropertiedObject.Property<String> MERCHANT_ID;
        public PropertiedObject.Property<Boolean> ENABLE_TIP;
        public PropertiedObject.Property<String> PAIRING_KEYS;
        public PropertiedObject.Property<SystemState> SYSTEM_STATE;
        public PropertiedObject.Property<Boolean> PRINT_RECEIPTS;
        public PropertiedObject.Property<Boolean> AUTO_SURCHARGE;
        public PropertiedObject.Property<String> HMAC_KEY;
        public PropertiedObject.Property<String> ENC_KEY;
        public PropertiedObject.Property<String> POLLING_URL;
        public PropertiedObject.Property<Boolean> SUPPORTS_CARD_ACQ;
        public PropertiedObject.Property<Boolean> TESTING;
        public PropertiedObject.Property<Terminal> PREFERRED_TERMINAL;
        public PropertiedObject.Property<String> LAST_CONNECTED_BANK;
        public PropertiedObject.Property<String> PAIR_USERNAME;
        public PropertiedObject.Property<String> PAIR_PASSWORD;
        public PropertiedObject.Property<EftposPrintReceiptType> PRINT_RECEIPT_TYPE;
    }
}

