/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.hardware.physical.callerid;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.simplermi.SimpleRMI;
import java.io.Serializable;
import java.util.List;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.physical.callerid.CallerIDNetwork;
import ordermate.database.hardware.physical.callerid.CallerIDUnit;
import ordermate.database.sales.Customer;

public class Call
implements Serializable {
    public static final int EXPECTED_SIZE = 65;
    private static final int LINE_NUMBER = 2;
    private static final int DIRECTION = 1;
    private static final int TERMINATION = 1;
    private static final int DURATION = 4;
    private static final int CHECKSUM = 1;
    private static final int TYPEOFRING = 2;
    private static final int DATE = 5;
    private static final int TIME = 5;
    private static final int AMPM = 2;
    private static final int PHONE_NUMBER = 14;
    private static final int PHONE_NAME = 15;
    private final int lineNumber;
    private final String time;
    private final String amOrPm;
    private final String number;
    private final String customerName;
    private final String input;
    private static final int CUS_NAME_LIMIT = 2;

    public Call(String data) {
        this.input = data;
        if (!Call.isValid(data)) {
            throw new IllegalArgumentException("Data is not valid :" + data);
        }
        int offset = this.input.length() - 65;
        String line = this.input.substring(offset, offset + 2);
        this.lineNumber = Integer.parseInt(line);
        offset = offset + 2 + 1;
        offset = offset + 1 + 1;
        offset = offset + 1 + 1;
        offset = offset + 4 + 1;
        offset = offset + 1 + 1;
        offset = offset + 2 + 1;
        offset = offset + 5 + 1;
        this.time = this.input.substring(offset, offset + 5);
        offset = offset + 5 + 1;
        this.amOrPm = this.input.substring(offset, offset + 2);
        offset = offset + 2 + 1;
        this.number = this.input.substring(offset, offset + 14).trim();
        offset = offset + 14 + 1;
        offset += 15;
        this.customerName = this.searchForCustomerName(this.number);
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getPhoneNumber() {
        return this.number;
    }

    public String getTime() {
        return this.time + " " + this.amOrPm;
    }

    public static boolean isValid(String data) {
        return data != null && data.length() >= 65 && data.substring(data.length() - 3).contains("\r\n");
    }

    private String searchForCustomerName(String phoneNumber) {
        String strippedNumber = phoneNumber.replace("-", "");
        ObjectQuery custQuery = Query.select(Customer.class).active(Customer.class).equals(Customer.Properties.PRIMARY_PHONE_NUMBER, strippedNumber).or().equals(Customer.Properties.SECONDARY_PHONE_NUMBER, strippedNumber).orderByDesc(Customer.Properties.MOD).limit(3);
        List<Customer> custList = PersistenceManager.getObjectList(Customer.class, custQuery.toString());
        String custNames = "";
        if (!custList.isEmpty()) {
            int numAdded = 0;
            for (Customer cust : custList) {
                if (!custNames.isEmpty()) {
                    custNames = custNames + "<br>";
                }
                custNames = custNames + cust.getName();
                if (++numAdded != 2) continue;
                if (custList.size() <= 2) break;
                custNames = custNames + "..";
                break;
            }
        }
        return custNames;
    }

    public String getCustomerName() {
        return this.customerName;
    }

    static void handleCall(Call theCall) {
        CallerIDUnit.portLog.info((Object)("Caller ID unit received phone call from " + theCall.getPhoneNumber() + " on line " + theCall.getLineNumber()));
        for (Terminal terminal : Terminal.getAllWaiterMateTerminals()) {
            if (terminal.getAvailableCallerIDUnit() == null) continue;
            Thread thread = new Thread(Call.createTerminalRunner(terminal, theCall), "Notify " + terminal.getName() + " of incoming call");
            thread.start();
        }
    }

    private static Runnable createTerminalRunner(final Terminal terminal, final Call theCall) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    CallerIDNetwork termControl = (CallerIDNetwork)SimpleRMI.getObject(terminal.getAddress(), "Caller ID Control", terminal.getRmiPort());
                    termControl.callDetected(theCall);
                    CallerIDUnit.portLog.info((Object)("Notified " + terminal.getName() + " of incoming call"));
                }
                catch (Exception e) {
                    CallerIDUnit.portLog.warn((Object)("Could not contact terminal " + terminal.getName() + " to notify of an incoming call"), (Throwable)e);
                }
            }
        };
    }
}

